﻿using System;
using System.Collections.Generic;

namespace FDK.カウンタ
{
	/// <summary>
	/// FPS（１秒間の進行処理回数）と VPS（１秒間の描画処理回数）を計測する。
	/// </summary>
	/// <remarks>
	/// 計測するだけで、表示はしない。
	/// FPSをカウントする() を呼び出さないと、VPS も更新されないので注意。
	/// </remarks>
	public class FPS
	{
		public int 現在のFPS
		{
			get
			{
				lock( this._スレッド間同期 )
				{
					return this._現在のFPS;
				}
			}
		}

		public int 現在のVPS
		{
			get
			{
				lock( this._スレッド間同期 )
				{
					return this._現在のVPS;
				}
			}
		}

		public FPS()
		{
			this._初めてのFPS更新 = true;
			this._現在のFPS = 0;
			this._現在のVPS = 0;
		}

		public void FPSをカウントしプロパティを更新する()
		{
			lock( this._スレッド間同期 )
			{
				if( this._初めてのFPS更新 )
				{
					this._初めてのFPS更新 = false;
					this._fps用カウンタ = 0;
					this._vps用カウンタ = 0;
					this._定間隔進行 = new 定間隔進行();
					this._定間隔進行.経過時間の計測を開始する();
				}
				else
				{
					// FPS 更新。
					this._fps用カウンタ++;

					// 1秒ごとに FPS, VPS プロパティの値を更新。
					this._定間隔進行.経過時間の分だけ進行する( 1000, () => {

						this._現在のFPS = this._fps用カウンタ;
						this._現在のVPS = this._vps用カウンタ;
						this._fps用カウンタ = 0;
						this._vps用カウンタ = 0;

					} );
				}
			}
		}

		public void VPSをカウントする()
		{
			lock( this._スレッド間同期 )
			{
				// VPS 更新。
				this._vps用カウンタ++;
			}
		}

		private int _現在のFPS = 0;

		private int _現在のVPS = 0;

		private int _fps用カウンタ = 0;

		private int _vps用カウンタ = 0;

		private FDK.カウンタ.定間隔進行 _定間隔進行 = null;

		private bool _初めてのFPS更新 = true;

		private readonly object _スレッド間同期 = new object();
	}
}
