﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FDK
{
	/// <summary>
	///		SharpDX.IUnknown の拡張メソッド。
	/// </summary>
	public static class SharpDXIUnknownExtensions
	{
		/// <summary>
		///		現在の COM 参照カウンタを返す。
		/// </summary>
		public static int GetRefferenceCount( this SharpDX.IUnknown unknownObject )
		{
			try
			{
				unknownObject.AddReference();
			}
			catch( InvalidOperationException )
			{
				// すでに Dispose されている。
				return 0;
			}

			return unknownObject.Release();
		}
	}
}
