﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Threading;

namespace FDK.同期
{
	/// <summary>
	///		ReadWriterLock アクセスを提供する。
	/// </summary>
	/// <typeparam name="T">排他アクセスを行いたい型。</typeparam>
	public class RWLock<T>
	{
		public T Value
		{
			get
			{
				this._スレッド間同期.EnterReadLock();
				try
				{
					return this._Value;
				}
				finally
				{
					this._スレッド間同期.ExitReadLock();
				}
			}
			set
			{
				this._スレッド間同期.EnterWriteLock();
				try
				{
					this._Value = value;
				}
				finally
				{
					this._スレッド間同期.ExitWriteLock();
				}
			}
		}


		public RWLock()
			: this( default( T ) )
		{
		}

		public RWLock( T 初期値 )
		{
			this._スレッド間同期 = new ReaderWriterLockSlim( LockRecursionPolicy.SupportsRecursion );  // 再入可能（実は推奨されない）
			this._Value = 初期値;
		}

		public RWLock( ReaderWriterLockSlim rwLocker, T 初期値 )
		{
			Debug.Assert( null != rwLocker );

			this._スレッド間同期 = rwLocker;
			this._Value = 初期値;
		}

		public RWLock( ReaderWriterLockSlim rwLocker ) 
			: this( rwLocker, default( T ) )
		{
		}


		private T _Value = default( T );

		private readonly ReaderWriterLockSlim _スレッド間同期;
	}
}
