package org.sqlite.event;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.sqlite.Database;
import org.sqlite.jdbc.JdbcConnection;
import org.sqlite.swig.SQLite3Constants;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class ProgressHandlerTest {

    public ProgressHandlerTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }


    private static final String DRIVER_CLASS = "org.sqlite.Driver";
    private static final String DATABASE = System.getProperty("user.dir") + "/test/unittest.db";

    private static Database newDatabase() throws ClassNotFoundException, SQLException {
        Class.forName(DRIVER_CLASS);
        return new Database(DATABASE, null);
    }
    
    private static Connection newConnection(Database db) throws ClassNotFoundException, SQLException {
        return new JdbcConnection(db, null);
    }

    @Test(expected = java.sql.SQLException.class)
    public void setProgressHandler() throws ClassNotFoundException, SQLException, IOException {
        final Database db = newDatabase();
        final ProgressHandler progHandler
                = new ProgressHandler(1) {
                        @Override
                        protected int xProgress() {
                            System.out.println("Called xProgress()");
                            return -1;
                        }
                    };
        assertFalse(progHandler.isRegistered());
        try {
            db.setProgressHandler(progHandler);
            assertTrue(progHandler.isRegistered());
            
            final Connection conn = newConnection(db);
            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS tbl_progress_handler_test("
                        + "  ID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", VALUE TEXT"
                    + ")";
            stmt.executeUpdate(sql);

            conn.setAutoCommit(false);
            sql = "INSERT INTO tbl_progress_handler_test(VALUE) VALUES('Progress...')";
            for (int i = 0; i < 1000; ++i) {
                assertEquals(1, stmt.executeUpdate(sql));
            }
            conn.commit();

            sql = "SELECT * FROM tbl_progress_handler_test";
            for (final ResultSet rs = stmt.executeQuery(sql); rs.next(); ) {
                System.out.printf("ID:[%d] VALUE:[%s]\n", rs.getInt(1), rs.getString(2));
            }
            stmt.close();
            conn.close();
        } catch (SQLException ex) {
            assertEquals(SQLite3Constants.SQLITE_INTERRUPT, ex.getErrorCode());
            throw ex;
            
        } finally {
            db.close();
            assertFalse(progHandler.isRegistered());
        }
    }
}