import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.sqlite.udf.Context;
import org.sqlite.jdbc.JdbcConnection;
import org.sqlite.udf.Function;
import org.sqlite.udf.ScalarFunction;

public class ScalarFunctionExample {

    @org.junit.Test
    public void example() throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.Driver");
        final String url = "jdbc:sqlite:mem:";
        final JdbcConnection conn = (JdbcConnection) DriverManager.getConnection(url);
        try {
            // new scalar function
            final Function strcat
                    = new ScalarFunction("strcat") {
                        @Override
                        protected void xFunc(Context ctx) throws SQLException {
                            if (!ctx.hasValues()) {
                                throw new IllegalArgumentException("argument is 0");
                            }

                            final StringBuilder ret = new StringBuilder();
                            for (int i = 0; i < ctx.getArgumentCount(); ++i) {
                                final int idx = i + 1;
                                ret.append(ctx.getString(idx));
                            }
                            ctx.result(ret.toString());
                        }
                    };

            // new regular expression function
            final Function regexp
                    = new ScalarFunction("REGEXP", 2) {
                        @Override
                        protected void xFunc(Context ctx) throws SQLException {
                            Pattern regex = (Pattern) ctx.getAuxData(1);
                            if (regex == null) {
                                try {
                                    regex = Pattern.compile(ctx.getString(1));
                                    ctx.setAuxData(1, regex);

                                } catch (PatternSyntaxException ex) {
                                    ctx.resultError(ex.toString());
                                    return;
                                }
                            }

                            ctx.result(regex.matcher(ctx.getString(2)).matches());
                        }
                    };

            // create function
            conn.createFunction(strcat);
            conn.createFunction(regexp);

            final Statement stmt = conn.createStatement();
            final String sql
                    = "SELECT HELLO "
                    + "FROM ("
                            + "SELECT strcat('Hello', ', ', 'SQLite!') AS HELLO UNION ALL "
                            + "SELECT strcat('Hello', ', ', 'SQLite JDBC Driver') AS HELLO UNION ALL "
                            + "SELECT strcat('Hello', ', ', 'Java!') AS HELLO UNION ALL "
                            + "SELECT strcat('Hello', ', ', 'World!') AS HELLO"
                        + ") "
                    + "WHERE HELLO REGEXP '.*SQLite.*'";
            for (final ResultSet rs = stmt.executeQuery(sql); rs.next(); ) {
                System.out.println(rs.getString(1));
            }
            stmt.close();

            // drop function
            conn.dropFunction(strcat);
            conn.dropFunction(regexp);

        } finally {
            conn.close();
        }
    }

    public static void main(String[] args) throws Exception {
        new ScalarFunctionExample().example();
    }
}
