import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.sqlite.jdbc.JdbcResultSet;

public class BlobIncrementalIOExample {

    @org.junit.Test
    public void example() throws ClassNotFoundException, SQLException, IOException {
        Class.forName("org.sqlite.Driver");
        final String url = "jdbc:sqlite:mem:";
        final Connection conn = DriverManager.getConnection(url);
        try {
            // create table if not exists
            final Statement stmt = conn.createStatement();
            stmt.executeUpdate(
                    "CREATE TABLE IF NOT EXISTS blob_sample("
                        + "  id INTEGER PRIMARY KEY"
                        + ", bVal BLOB"
                    + ")"
                );
            // insert new record
            stmt.executeUpdate(
                    "INSERT INTO blob_sample(bVal) "
                    + "VALUES('Hello, Incremental BLOB I/O!')"
                );
            // select record
            JdbcResultSet rs
                    = (JdbcResultSet) stmt.executeQuery("SELECT * FROM blob_sample");
            if (rs.next()) {
                final long rowId = rs.getLong("id");

                // get writable BLOB object
                final Blob blob = rs.getBlob(2, rowId, true);
                final InputStream in = blob.getBinaryStream();
                final ByteArrayOutputStream bout = new ByteArrayOutputStream();
                int x = -1;
                while ((x = in.read()) != -1) {
                    bout.write(x);
                }
                System.out.println("Before: " + bout.toString("UTF8"));
                in.close();

                // update BLOB value
                final byte[] val = bout.toByteArray();
                final OutputStream out = blob.setBinaryStream(1);
                for (int i = val.length - 1; i >= 0; --i) {
                    out.write(val[i]);
                }
                out.close();
            }
            rs.close();

            // select updated record
            rs = (JdbcResultSet) stmt.executeQuery("SELECT bVal FROM blob_sample");
            if (rs.next()) {
                System.out.println("After : " + rs.getString(1));
            }
            rs.close();
            stmt.close();

        } finally {
            conn.close();
        }        
    }

    public static void main(String[] args) throws Exception {
        new BlobIncrementalIOExample().example();
    }
}
