package org.sqlite.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.sqlite.Statement;

/**
 *
 * @author calico
 */
public class JdbcParameterMetaData implements ParameterMetaData {
    private final Statement stmt;
    
    /**
     * default constructor.
     * @param stmt
     */
    public JdbcParameterMetaData(Statement stmt) {
        this.stmt = stmt;
    }
    
    // START implements
    /**
     * invoke org.sqlite.Statement#getParameterCount() method.
     * @return parameter count
     * @throws java.sql.SQLException
     * @see org.sqlite.Statement#getParameterCount()
     */
    public int getParameterCount() throws SQLException {
        return stmt.getParameterCount();
    }

    /**
     * CallableStatement is not supported yet.<br/>
     * It always returns parameterNullable.
     * @param param ignored
     * @return java.sql.ParameterMetaData.parameterNullable
     * @throws java.sql.SQLException SQLException is not generated.
     */
    public int isNullable(int param) throws SQLException {
        return parameterNullable;
    }

    // TODO do implements. If you're so inclined.

    /**
     * Not supporetd yet.
     * @throws java.sql.SQLException SQLException is not generated.
     * @throws java.lang.UnsupportedOperationException
     */
    public boolean isSigned(int param) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * Not supporetd yet.
     * @throws java.sql.SQLException SQLException is not generated.
     * @throws java.lang.UnsupportedOperationException
     */
    public int getPrecision(int param) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * Not supporetd yet.
     * @throws java.sql.SQLException SQLException is not generated.
     * @throws java.lang.UnsupportedOperationException
     */
    public int getScale(int param) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * Not supporetd yet.
     * @throws java.sql.SQLException SQLException is not generated.
     * @throws java.lang.UnsupportedOperationException
     */
    public int getParameterType(int param) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * Not supporetd yet.
     * @throws java.sql.SQLException SQLException is not generated.
     * @throws java.lang.UnsupportedOperationException
     */
    public String getParameterTypeName(int param) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * Not supporetd yet.
     * @throws java.sql.SQLException SQLException is not generated.
     * @throws java.lang.UnsupportedOperationException
     */
    public String getParameterClassName(int param) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * CallableStatement is not supported yet.<br/>
     * It always returns parameterModeIn.
     * @param param ignored
     * @return java.sql.ParameterMetaData.parameterModeIn
     * @throws java.sql.SQLException SQLException is not generated.
     */
    public int getParameterMode(int param) throws SQLException {
        return parameterModeIn;
    }
    // END implements
}
