import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.sqlite.jdbc.JdbcConnection;
import org.sqlite.udf.AggregateFunction;
import org.sqlite.udf.Context;
import org.sqlite.udf.Function;

public class AggregateFunctionExample {

    @org.junit.Test
    public void example() throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.Driver");
        final String url = "jdbc:sqlite:mem:";
        final JdbcConnection conn = (JdbcConnection) DriverManager.getConnection(url);
        try {
            // new aggregate function
            final Function sum
                    = new AggregateFunction<Long>("mySum") {
                            @Override
                            protected Long initialValue() {
                                return 0L;
                            }

                            @Override
                            protected void xStep(Context ctx) throws SQLException {
                                Long sum = get();
                                sum += ctx.getLong(1);
                                set(sum);
                            }

                            @Override
                            protected void xFinal(Context ctx) throws SQLException {
                                ctx.result(get());
                            }
                        };

            // create function
            conn.createFunction(sum);

            final Statement stmt = conn.createStatement();
            final String sql
                    = "SELECT mySum(VAL) FROM ("
                        + "SELECT 1 AS VAL UNION ALL "
                        + "SELECT 2 AS VAL UNION ALL "
                        + "SELECT 3 AS VAL UNION ALL "
                        + "SELECT 4 AS VAL UNION ALL "
                        + "SELECT 5 AS VAL "
                    + ")";

            for (final ResultSet rs = stmt.executeQuery(sql); rs.next(); ) {
                System.out.println(rs.getString(1));
            }
            stmt.close();

            // drop function
            conn.dropFunction(sum);

        } finally {
            conn.close();
        }
    }

    public static void main(String[] args) throws Exception {
        new AggregateFunctionExample().example();
    }
}
