package org.sqlite.profiler;

import org.sqlite.callback.Callback;

/**
 * SQL statement tracing class.
 * @author calico
 * @see <a href="http://sqlite.org/c3ref/profile.html">Tracing And Profiling Functions</a>
 * @see org.sqlite.jdbc.JdbcConnection#setTracer(Tracer)
 * @see org.sqlite.jdbc.JdbcConnection#clearTracer()
 */
public abstract class Tracer extends Callback {

    /**
     * Called from the sqlite3_step() function.
     * @param sql SQL to be evaluated
     */
    protected abstract void xTrace(String sql);
}
