package org.sqlite.event;

import org.sqlite.callback.Callback;

/**
 * COMMIT TRANSACTION hook class.
 * @author calico
 * @see <a href="http://sqlite.org/c3ref/commit_hook.html">Commit And Rollback Notification Callbacks</a>
 * @see org.sqlite.jdbc.JdbcConnection#setCommitHook(CommitHook)
 * @see org.sqlite.jdbc.JdbcConnection#clearCommitHook()
 */
public abstract class CommitHook extends Callback {

    /**
     * invoked whenever a transaction is committed.
     * @return 0 if the transaction is commited. non-zero if the transaction is rollbacked.
     */
    protected abstract int xCommit();
}
