/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class JdbcPreparedStatementTest {

    public JdbcPreparedStatementTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private static final String DRIVER_CLASS = "org.sqlite.Driver";
    private static final String DATABASE = System.getProperty("user.dir") + "/test/unittest.db";
    
    private static Connection newConnection() throws ClassNotFoundException, SQLException {
        Class.forName(DRIVER_CLASS);
        return DriverManager.getConnection("jdbc:sqlite:file:" + DATABASE);
    }
    
    @Test
    public void execute() throws ClassNotFoundException, SQLException {
        final Connection conn = newConnection();
        try {
            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS temp_tbl_1("
                        + "  ROWID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", ID INTEGER NOT NULL"
                        + ", tVALUE TEXT DEFAULT '_blank'"
                        + ", rVALUE REAL"
                        + ", bVALUE BLOB"
                        + ", nVALUE NULL"
                        + ", tVALUE2 text DEFAULT ''"
                        + ", tVALUE3 VarChar DEFAULT NULL"
                    + ")";
            stmt.executeUpdate(sql);
            stmt.close();
            
            sql = "INSERT INTO temp_tbl_1("
                    + "ID"
                    + ", rVALUE"
                    + ", bVALUE"
                    + ", nVALUE"
                + ") VALUES(?, ?, ?, ?)";
            PreparedStatement pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, 1);
            pstmt.setDouble(2, 2.22d);
            pstmt.setBytes(3, new byte[] { Byte.MAX_VALUE, Byte.MIN_VALUE, 1, 2, 3, });
            pstmt.setString(4, "TEST");
            assertFalse(pstmt.execute());
            assertEquals(1, pstmt.getUpdateCount());
            
            pstmt.setInt(1, 2);
            assertFalse(pstmt.execute());
            assertEquals(1, pstmt.getUpdateCount());

            pstmt.close();

            sql = "SELECT * FROM temp_tbl_1 WHERE ID = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, 1);
            assertTrue(pstmt.execute());
            assertEquals(-1, pstmt.getUpdateCount());
            ResultSet rs = pstmt.getResultSet();
            assertTrue(rs.next());
            assertEquals(1, rs.getInt(1));
            assertFalse(rs.next());
            rs.close();
            
            pstmt.setInt(1, 2);
            assertTrue(pstmt.execute());
            assertEquals(-1, pstmt.getUpdateCount());
            rs = pstmt.getResultSet();
            assertTrue(rs.next());
            assertEquals(2, rs.getInt(1));
            assertFalse(rs.next());
            rs.close();
            
            pstmt.close();
            
            
        } finally {
            conn.close();
        }
    }

}