/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class JdbcDatabaseMetaDataTest {

    public JdbcDatabaseMetaDataTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private static final String DRIVER_CLASS = "org.sqlite.Driver";
    private static final String DATABASE = System.getProperty("user.dir") + "/test/unittest.db";
    
    @Test
    public void getColumns() throws ClassNotFoundException, SQLException {
        Class.forName(DRIVER_CLASS);
        final Connection conn = DriverManager.getConnection("jdbc:sqlite:file:" + DATABASE);
        final Statement stmt = conn.createStatement();
        String sql
                = "CREATE TEMPORARY TABLE IF NOT EXISTS temp_tbl_1("
                    + "  ROWID INTEGER PRIMARY KEY AUTOINCREMENT"
                    + ", ID INTEGER NOT NULL"
                    + ", tVALUE TEXT DEFAULT '_blank''_'"
                    + ", rVALUE REAL"
                    + ", bVALUE BLOB"
                    + ", nVALUE NULL"
                    + ", tVALUE2 text DEFAULT ''"
                    + ", tVALUE3 VarChar DEFAULT NULL"
                + ")";
        stmt.executeUpdate(sql);
        sql = "INSERT INTO temp_tbl_1("
                + "ID"
                + ", rVALUE"
                + ", bVALUE"
                + ", nVALUE"
            + ") VALUES(1, 2.345, X'E38182E38184E38186E38188E3818A00', 10)";
        stmt.executeUpdate(sql);
        stmt.close();
        
        DatabaseMetaData dbMeta = conn.getMetaData();
        for (ResultSet rs = dbMeta.getColumns(null, null, "temp_tbl_1", "%VALUE%"); rs.next(); ) {
            int cntColumns = rs.getMetaData().getColumnCount();
            for (int i = 1; i <= cntColumns; ++i) {
                System.out.print(rs.getString(i) + " | ");
            }
            System.out.println();
        }
        
        conn.close();
    }

}