/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.types;

import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SWIGTYPE_p_p_sqlite3;

/**
 * SQLite3Handle wrapper class.
 * @author calico
 */
public class SQLite3Handle extends org.sqlite.swig.SQLite3Handle {
    
    public SQLite3Handle() {
        super();
        if (getCPtr(this) == 0) {
            throw new OutOfMemoryError("Not enough memory.");
        }
    }
    
    public boolean isDeleted() {
        return (SQLite3Handle.getCPtr(this) == 0);
    }
    
    public SWIGTYPE_p_p_sqlite3 getSQLite3PtrPtr() {
        if (isDeleted()) {
            throw new IllegalStateException("SQLite3Handle is already deleted.");
        }            
        return SQLite3.get_sqlite3_ptr_ptr(this);
    }

}
