/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.34
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sqlite.swig;

public class SQLite3 implements SQLite3Constants {

  /**
   * sqlite3** wrapper class.
   * @see <a href="http://sqlite.org/c3ref/sqlite3.html">Database Connection Handle</a>
   */
  public static class SQLite3PtrPtr extends SWIGTYPE_p_p_sqlite3 {
    private boolean isDeleted = false;
    private SWIGTYPE_p_sqlite3 handle;

    /**
     * default constructor.
     */
    public SQLite3PtrPtr() {
      super(SQLite3JNI.new_p_p_sqlite3(), false);
    }

    public boolean isDeleted() {
      return isDeleted;
    }

    /**
     * Delete this object.
     * @see #delete_p_p_sqlite3(SWIGTYPE_p_p_sqlite3)
     */
    public synchronized void delete() {
      if (!isDeleted) {
        delete_p_p_sqlite3(this);
        isDeleted = true;
        handle = null;
      }
    }

    /**
     * Allocate sqlite3* value.
     * @see #get_p_sqlite3(SWIGTYPE_p_p_sqlite3)
     */
    public void allocateHandle() {
      if (!isDeleted) {
        if (handle == null) {
          handle = get_p_sqlite3(this);
        } else {
          throw new IllegalStateException("sqlite3 handle is already allocated.");
        }
      } else {
        throw new IllegalStateException("SQLite3PtrPtr is already deleted.");
      }
    }

    /**
     * Returns the sqlite3* value.</br>
     * It is necessary to invoke the allocateHandle() method beforehand.
     * @return the sqlite3* value
     * @see #allocateHandle()
     */
    public SWIGTYPE_p_sqlite3 getSQLite3Ptr() {
      if (!isDeleted) {
        return handle;
      }
      throw new IllegalStateException("SQLite3PtrPtr is already deleted.");
    }

    /**
     * invoke delete() method.
     * @throws java.lang.Throwable
     * @see #delete()
     */
    @Override
    protected void finalize() throws Throwable {
      delete();
      super.finalize();
    }
  }

  /**
   * sqlite3_stmt** wrapper class.
   * @see <a href="http://sqlite.org/c3ref/stmt.html">SQL Statement Object</a>
   */
  public static class SQLite3StmtPtrPtr extends SWIGTYPE_p_p_sqlite3_stmt {
    private boolean isDeleted = false;

    /**
     * default constructor.
     */
    public SQLite3StmtPtrPtr() {
      super(SQLite3JNI.new_p_p_sqlite3_stmt(), false);
    }

    public boolean isDeleted() {
      return isDeleted;
    }

    /**
     * Delete this object.
     * @see #delete_p_p_sqlite3_stmt(SWIGTYPE_p_p_sqlite3_stmt)
     */
    public synchronized void delete() {
      if (!isDeleted) {
        delete_p_p_sqlite3_stmt(this);
        isDeleted = true;
      }
    }

    /**
     * Returns the sqlite3_stmt* value.
     * @return the sqlite3_stmt* value.
     * @see #get_p_sqlite3_stmt(SWIGTYPE_p_p_sqlite3_stmt)
     */
    public SWIGTYPE_p_sqlite3_stmt getSQLite3StmtPtr() {
      if (!isDeleted) {
        return get_p_sqlite3_stmt(this);
      }
      throw new IllegalStateException("SQLite3StmtPtrPtr is already deleted.");
    }

    /**
     * invoke delete() method.
     * @throws java.lang.Throwable
     * @see #delete()
     */
    @Override
    protected void finalize() throws Throwable {
      delete();
      super.finalize();
    }
  }

  public static final int SQLITE_TRANSIENT = -1;

  /**
   * Returns in-memory filename.
   * @return ":memory:"
   * @see <a href="http://sqlite.org/c3ref/open.html">Opening A New Database Connection</a>
   */
  public static String getInMemoryFileName() {
    return ":memory:";
  }

  /**
   * Returns date format pattern.
   * @return "yyyy-MM-dd"
   * @see <a href="http://sqlite.org/lang_createtable.html">CREATE TABLE</a>
   */
  public static String getDateFormatPattern() {
    return "yyyy-MM-dd";
  }

  /**
   * Returns time format pattern.
   * @return "HH:mm:ss"
   * @see <a href="http://sqlite.org/lang_createtable.html">CREATE TABLE</a>
   */
  public static String getTimeFormatPattern() {
    return "HH:mm:ss";
  }

  /**
   * Returns timestamp format pattern.
   * @return "yyyy-MM-dd HH:mm:ss"
   * @see <a href="http://sqlite.org/lang_createtable.html">CREATE TABLE</a>
   */
  public static String getTimestampFormatPattern() {
    return "yyyy-MM-dd HH:mm:ss";
  }
  
  /**
   * invoke new java.text.SimpleDateFormat(String).format(Date) method.
   * @param pattern the pattern describing the date and time format
   * @param x the time value to be formatted into a time string
   * @return the formatted time string.
   * @see java.text.SimpleDateFormat#SimpleDateFormat(String)
   * @see java.text.DateFormat#format(java.util.Date)
   */
  public static String format(String pattern, java.util.Date x) {
    return new java.text.SimpleDateFormat(pattern).format(x);
  }
  
  /**
   * invoke format(getDateFormatPattern(), Date) method.
   * @param x the time value to be formatted into a time string
   * @return the formatted time string.
   * @see #getDateFormatPattern()
   * @see #format(String, java.util.Date x)
   */
  public static String format(java.sql.Date x) {
    return format(getDateFormatPattern(), x);
  }
  
  /**
   * invoke format(getTimeFormatPattern(), Date) method.
   * @param x the time value to be formatted into a time string
   * @return the formatted time string.
   * @see #getTimeFormatPattern()
   * @see #format(String, java.util.Date x)
   */
  public static String format(java.sql.Time x) {
    return format(getTimeFormatPattern(), x);
  }
  
  /**
   * invoke format(getTimestampFormatPattern(), Date) method.
   * @param x the time value to be formatted into a time string
   * @return the formatted time string.
   * @see #getTimestampFormatPattern()
   * @see #format(String, java.util.Date x)
   */
  public static String format(java.sql.Timestamp x) {
    return format(getTimestampFormatPattern(), x);
  }

  /**
   * invoke new java.text.SimpleDateFormat(String).parse(String, ParsePosition) method.
   * @param pattern the pattern describing the date and time format
   * @param x the date/time string to be parsed
   * @return value of Date#getTime()
   * @throws java.sql.SQLException
   * @see java.text.SimpleDateFormat#SimpleDateFormat(String)
   * @see java.text.SimpleDateFormat#parse(String, java.text.ParsePosition)
   * @see java.util.Date#getTime()
   */
  public static long parse(String pattern, String x) throws java.sql.SQLException {
    final java.text.DateFormat formatter = new java.text.SimpleDateFormat(pattern);
    formatter.setLenient(false);
    final java.text.ParsePosition position = new java.text.ParsePosition(0);
    final java.util.Date date = formatter.parse(x, position);
    if (position.getErrorIndex() != -1 || position.getIndex() != x.length()) {
        // parse failed
        throw new java.sql.SQLException("Format error.", "90J09");
    }
    return date.getTime();
  }
  
  /**
   * invoke parse(getDateFormatPattern(), String) method.
   * @param x the date/time string to be parsed
   * @return value of Date#getTime()
   * @throws java.sql.SQLException
   * @see #getDateFormatPattern()
   * @see #parse(String, String)
   */
  public static long parseDate(String x) throws java.sql.SQLException {
    return parse(getDateFormatPattern(), x);
  }
  
  /**
   * invoke parse(getTimeFormatPattern(), String) method.
   * @param x the date/time string to be parsed
   * @return value of Date#getTime()
   * @throws java.sql.SQLException
   * @see #getTimeFormatPattern()
   * @see #parse(String, String)
   */
  public static long parseTime(String x) throws java.sql.SQLException {
    return parse(getTimeFormatPattern(), x);
  }
  
  /**
   * invoke parse(getTimestampFormatPattern(), String) method.
   * @param x the date/time string to be parsed
   * @return value of Date#getTime()
   * @throws java.sql.SQLException
   * @see #getTimestampFormatPattern()
   * @see #parse(String, String)
   */
  public static long parseTimestamp(String x) throws java.sql.SQLException {
    return parse(getTimestampFormatPattern(), x);
  }

  /**
   * Returns the unescaped string.
   * @param str single quoted string
   * @return unescaped string
   */
  public static String unescapeSingleQuotedString(String str) {
    if (str != null
        && str.length() > 1
        && str.charAt(0) == '\''
        && str.charAt(str.length() - 1) == '\'') {
      return str.substring(1, str.length() - 1).replaceAll("''", "'");
    }
    return str;
  }

  /**
   * Returns the encoding name corresponding to the argument.
   * @param enc the text encoding code
   * @see <a href="http://sqlite.org/c3ref/c_any.html">Text Encodings</a>
   */
  public static String getEncoding(int enc) {
    switch (enc) {
      case SQLITE_UTF8:
        return "UTF8";

      case SQLITE_UTF16BE:
        return "UnicodeBigUnmarked";

      case SQLITE_UTF16LE:
        return "UnicodeLittleUnmarked";

      case SQLITE_UTF16:
      case SQLITE_UTF16_ALIGNED:
        return "UTF-16";
    }
    throw new IllegalArgumentException("Unsupported text encodings '" + enc + "'");
  }

  public static int sqlite3_exec(SWIGTYPE_p_sqlite3 db, String sql) {
    return SQLite3JNI.sqlite3_exec(SWIGTYPE_p_sqlite3.getCPtr(db), sql, null, 0);
  }

  public static int sqlite3_exec(SWIGTYPE_p_sqlite3 db, String sql, org.sqlite.callback.ExecCallback callback, SWIGTYPE_p_p_char errmsg) {
    return SQLite3JNI.sqlite3_exec(SWIGTYPE_p_sqlite3.getCPtr(db), sql, callback, SWIGTYPE_p_p_char.getCPtr(errmsg));
  }

  public static int sqlite3_get_table(SWIGTYPE_p_sqlite3 db, String sql, java.util.List<String[]> result, SWIGTYPE_p_p_char errmsg) {
    return SQLite3JNI.sqlite3_get_table(SWIGTYPE_p_sqlite3.getCPtr(db), sql, result, SWIGTYPE_p_p_char.getCPtr(errmsg));
  }

  /** invoke sqlite3_prepare_v2() method. */
  public static int sqlite3_prepare(SWIGTYPE_p_sqlite3 db, String zSql, int nBytes, SWIGTYPE_p_p_sqlite3_stmt ppStmt, String[] pzTail) {
    return SQLite3JNI.sqlite3_prepare_v2(SWIGTYPE_p_sqlite3.getCPtr(db), zSql, nBytes, SWIGTYPE_p_p_sqlite3_stmt.getCPtr(ppStmt), pzTail);
  }

  public static int sqlite3_bind_blob(SWIGTYPE_p_sqlite3_stmt stmt, int parameterIndex, byte[] val, int len) {
    return SQLite3JNI.sqlite3_bind_blob_by_bytes(SWIGTYPE_p_sqlite3_stmt.getCPtr(stmt), parameterIndex, val, len, SQLITE_TRANSIENT);
  }

  public static int sqlite3_bind_text(SWIGTYPE_p_sqlite3_stmt stmt, int parameterIndex, String val) {
    return SQLite3JNI.sqlite3_bind_text(SWIGTYPE_p_sqlite3_stmt.getCPtr(stmt), parameterIndex, val, -1, SQLITE_TRANSIENT);
  }

  public static int sqlite3_create_function(SWIGTYPE_p_sqlite3 db, org.sqlite.udf.Function func) {
    return SQLite3JNI.sqlite3_create_function(SWIGTYPE_p_sqlite3.getCPtr(db), func);
  }

  public static int sqlite3_drop_function(SWIGTYPE_p_sqlite3 db, org.sqlite.udf.Function func) {
    return SQLite3JNI.sqlite3_drop_function(SWIGTYPE_p_sqlite3.getCPtr(db), func);
  }

  public static void sqlite3_result_blob(SWIGTYPE_p_sqlite3_context ctx, SWIGTYPE_p_void blob, int len) {
    SQLite3JNI.sqlite3_result_blob(SWIGTYPE_p_sqlite3_context.getCPtr(ctx), SWIGTYPE_p_void.getCPtr(blob), len, SQLITE_TRANSIENT);
  }

  public static void sqlite3_result_blob(SWIGTYPE_p_sqlite3_context ctx, byte[] val, int len) {
    SQLite3JNI.sqlite3_result_blob_by_bytes(SWIGTYPE_p_sqlite3_context.getCPtr(ctx), val, len, SQLITE_TRANSIENT);
  }

  public static void sqlite3_result_error(SWIGTYPE_p_sqlite3_context ctx, String message) {
    SQLite3JNI.sqlite3_result_error(SWIGTYPE_p_sqlite3_context.getCPtr(ctx), message, -1);
  }

  public static void sqlite3_result_text(SWIGTYPE_p_sqlite3_context ctx, String val) {
    SQLite3JNI.sqlite3_result_text(SWIGTYPE_p_sqlite3_context.getCPtr(ctx), val, -1, SQLITE_TRANSIENT);
  }

  public static int sqlite3_create_collation(SWIGTYPE_p_sqlite3 db, org.sqlite.text.Collator col) {
    return SQLite3JNI.sqlite3_create_collation(SWIGTYPE_p_sqlite3.getCPtr(db), col);
  }

  public static int sqlite3_drop_collation(SWIGTYPE_p_sqlite3 db, org.sqlite.text.Collator col) {
    return SQLite3JNI.sqlite3_drop_collation(SWIGTYPE_p_sqlite3.getCPtr(db), col);
  }

  public static SWIGTYPE_p_sqlite3 new_p_sqlite3(long cPtr) {
    return new SWIGTYPE_p_sqlite3(cPtr, false);
  }

  public static SWIGTYPE_p_sqlite3_context new_p_sqlite3_context(long cPtr) {
    return new SWIGTYPE_p_sqlite3_context(cPtr, false);
  }

  public static SWIGTYPE_p_p_Mem new_p_p_sqlite3_value(long cPtr) {
    return new SWIGTYPE_p_p_Mem(cPtr, false);
  }

  public static int sqlite3_collation_needed(SWIGTYPE_p_sqlite3 db, org.sqlite.event.CollationNeededHandler needed) {
    return SQLite3JNI.sqlite3_collation_needed(SWIGTYPE_p_sqlite3.getCPtr(db), needed);
  }

  public static int sqlite3_clear_collation_needed(SWIGTYPE_p_sqlite3 db, org.sqlite.event.CollationNeededHandler needed) {
    return SQLite3JNI.sqlite3_clear_collation_needed(SWIGTYPE_p_sqlite3.getCPtr(db), needed);
  }

  public static int sqlite3_set_authorizer(SWIGTYPE_p_sqlite3 db, org.sqlite.auth.Authorizer auth) {
    return SQLite3JNI.sqlite3_set_authorizer(SWIGTYPE_p_sqlite3.getCPtr(db), auth);
  }

  public static int sqlite3_clear_authorizer(SWIGTYPE_p_sqlite3 db, org.sqlite.auth.Authorizer auth) {
    return SQLite3JNI.sqlite3_clear_authorizer(SWIGTYPE_p_sqlite3.getCPtr(db), auth);
  }

  public static int sqlite3_busy_handler(SWIGTYPE_p_sqlite3 db, org.sqlite.event.BusyHandler busy) {
    return SQLite3JNI.sqlite3_busy_handler(SWIGTYPE_p_sqlite3.getCPtr(db), busy);
  }

  public static int sqlite3_clear_busy_handler(SWIGTYPE_p_sqlite3 db, org.sqlite.event.BusyHandler busy) {
    return SQLite3JNI.sqlite3_clear_busy_handler(SWIGTYPE_p_sqlite3.getCPtr(db), busy);
  }

  public static void sqlite3_progress_handler(SWIGTYPE_p_sqlite3 db, org.sqlite.event.ProgressHandler prog) {
    SQLite3JNI.sqlite3_progress_handler(SWIGTYPE_p_sqlite3.getCPtr(db), prog);
  }

  public static void sqlite3_clear_progress_handler(SWIGTYPE_p_sqlite3 db, org.sqlite.event.ProgressHandler prog) {
    SQLite3JNI.sqlite3_clear_progress_handler(SWIGTYPE_p_sqlite3.getCPtr(db), prog);
  }

  public static void sqlite3_commit_hook(SWIGTYPE_p_sqlite3 db, org.sqlite.event.CommitHook hook) {
    SQLite3JNI.sqlite3_commit_hook(SWIGTYPE_p_sqlite3.getCPtr(db), hook);
  }

  public static void sqlite3_rollback_hook(SWIGTYPE_p_sqlite3 db, org.sqlite.event.RollbackHook hook) {
    SQLite3JNI.sqlite3_rollback_hook(SWIGTYPE_p_sqlite3.getCPtr(db), hook);
  }

  public static void sqlite3_update_hook(SWIGTYPE_p_sqlite3 db, org.sqlite.event.UpdateHook hook) {
    SQLite3JNI.sqlite3_update_hook(SWIGTYPE_p_sqlite3.getCPtr(db), hook);
  }

  public static void sqlite3_profile(SWIGTYPE_p_sqlite3 db, org.sqlite.profiler.Profiler prof) {
    SQLite3JNI.sqlite3_profile(SWIGTYPE_p_sqlite3.getCPtr(db), prof);
  }

  public static void sqlite3_trace(SWIGTYPE_p_sqlite3 db, org.sqlite.profiler.Tracer tracer) {
    SQLite3JNI.sqlite3_trace(SWIGTYPE_p_sqlite3.getCPtr(db), tracer);
  }

  public static int sqlite3_prepare_v1(SWIGTYPE_p_sqlite3 arg0, String arg1, int arg2, SWIGTYPE_p_p_sqlite3_stmt arg3, Object[] arg4) {
    return SQLite3JNI.sqlite3_prepare_v1(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1, arg2, SWIGTYPE_p_p_sqlite3_stmt.getCPtr(arg3), arg4);
  }

  public static int sqlite3_prepare_v2(SWIGTYPE_p_sqlite3 arg0, String arg1, int arg2, SWIGTYPE_p_p_sqlite3_stmt arg3, Object[] arg4) {
    return SQLite3JNI.sqlite3_prepare_v2(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1, arg2, SWIGTYPE_p_p_sqlite3_stmt.getCPtr(arg3), arg4);
  }

  private static int sqlite3_create_function(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
    return SQLite3JNI.sqlite3_create_function(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
  }

  private static int sqlite3_drop_function(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
    return SQLite3JNI.sqlite3_drop_function(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
  }

  private static int sqlite3_create_collation(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
    return SQLite3JNI.sqlite3_create_collation(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
  }

  private static int sqlite3_drop_collation(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
    return SQLite3JNI.sqlite3_drop_collation(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
  }

  private static int sqlite3_set_authorizer(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
    return SQLite3JNI.sqlite3_set_authorizer(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
  }

  private static int sqlite3_clear_authorizer(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
    return SQLite3JNI.sqlite3_clear_authorizer(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
  }

  private static int sqlite3_busy_handler(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
    return SQLite3JNI.sqlite3_busy_handler(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
  }

  private static int sqlite3_clear_busy_handler(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
    return SQLite3JNI.sqlite3_clear_busy_handler(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
  }

  private static int sqlite3_collation_needed(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
    return SQLite3JNI.sqlite3_collation_needed(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
  }

  private static int sqlite3_clear_collation_needed(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
    return SQLite3JNI.sqlite3_clear_collation_needed(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
  }

  private static void sqlite3_progress_handler(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
    SQLite3JNI.sqlite3_progress_handler(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
  }

  private static void sqlite3_clear_progress_handler(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
    SQLite3JNI.sqlite3_clear_progress_handler(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
  }

  private static void sqlite3_commit_hook(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
    SQLite3JNI.sqlite3_commit_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
  }

  public static void sqlite3_clear_commit_hook(SWIGTYPE_p_sqlite3 arg0) {
    SQLite3JNI.sqlite3_clear_commit_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0));
  }

  private static void sqlite3_rollback_hook(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
    SQLite3JNI.sqlite3_rollback_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
  }

  public static void sqlite3_clear_rollback_hook(SWIGTYPE_p_sqlite3 arg0) {
    SQLite3JNI.sqlite3_clear_rollback_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0));
  }

  private static void sqlite3_update_hook(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
    SQLite3JNI.sqlite3_update_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
  }

  public static void sqlite3_clear_update_hook(SWIGTYPE_p_sqlite3 arg0) {
    SQLite3JNI.sqlite3_clear_update_hook(SWIGTYPE_p_sqlite3.getCPtr(arg0));
  }

  private static void sqlite3_profile(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
    SQLite3JNI.sqlite3_profile(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
  }

  public static void sqlite3_clear_profile(SWIGTYPE_p_sqlite3 arg0) {
    SQLite3JNI.sqlite3_clear_profile(SWIGTYPE_p_sqlite3.getCPtr(arg0));
  }

  private static void sqlite3_trace(SWIGTYPE_p_sqlite3 arg0, Object arg1) {
    SQLite3JNI.sqlite3_trace(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1);
  }

  public static void sqlite3_clear_trace(SWIGTYPE_p_sqlite3 arg0) {
    SQLite3JNI.sqlite3_clear_trace(SWIGTYPE_p_sqlite3.getCPtr(arg0));
  }

  public static void sqlite3_set_auxdata(SWIGTYPE_p_sqlite3_context arg0, int arg1, Object arg2) {
    SQLite3JNI.sqlite3_set_auxdata(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1, arg2);
  }

  public static Object sqlite3_get_auxdata(SWIGTYPE_p_sqlite3_context arg0, int arg1) {
    return SQLite3JNI.sqlite3_get_auxdata(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1);
  }

  public static byte[] sqlite3_column_blob_by_bytes(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
    return SQLite3JNI.sqlite3_column_blob_by_bytes(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
  }

  public static byte[] sqlite3_value_blob_by_bytes(SWIGTYPE_p_Mem arg0) {
    return SQLite3JNI.sqlite3_value_blob_by_bytes(SWIGTYPE_p_Mem.getCPtr(arg0));
  }

  public static void set_sqlite3_temp_directory(String arg0) {
    SQLite3JNI.set_sqlite3_temp_directory(arg0);
  }

  private static int sqlite3_exec(SWIGTYPE_p_sqlite3 arg0, String arg1, Object arg2, long arg3) {
    return SQLite3JNI.sqlite3_exec(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1, arg2, arg3);
  }

  private static int sqlite3_get_table(SWIGTYPE_p_sqlite3 arg0, String arg1, Object arg2, long arg3) {
    return SQLite3JNI.sqlite3_get_table(SWIGTYPE_p_sqlite3.getCPtr(arg0), arg1, arg2, arg3);
  }

  public static String sqlite3_libversion() {
    return SQLite3JNI.sqlite3_libversion();
  }

  public static int sqlite3_libversion_number() {
    return SQLite3JNI.sqlite3_libversion_number();
  }

  public static int sqlite3_close(SWIGTYPE_p_sqlite3 arg0) {
    return SQLite3JNI.sqlite3_close(SWIGTYPE_p_sqlite3.getCPtr(arg0));
  }

  public static int sqlite3_extended_result_codes(SWIGTYPE_p_sqlite3 arg0, int onoff) {
    return SQLite3JNI.sqlite3_extended_result_codes(SWIGTYPE_p_sqlite3.getCPtr(arg0), onoff);
  }

  public static long sqlite3_last_insert_rowid(SWIGTYPE_p_sqlite3 arg0) {
    return SQLite3JNI.sqlite3_last_insert_rowid(SWIGTYPE_p_sqlite3.getCPtr(arg0));
  }

  public static int sqlite3_changes(SWIGTYPE_p_sqlite3 arg0) {
    return SQLite3JNI.sqlite3_changes(SWIGTYPE_p_sqlite3.getCPtr(arg0));
  }

  public static int sqlite3_total_changes(SWIGTYPE_p_sqlite3 arg0) {
    return SQLite3JNI.sqlite3_total_changes(SWIGTYPE_p_sqlite3.getCPtr(arg0));
  }

  public static void sqlite3_interrupt(SWIGTYPE_p_sqlite3 arg0) {
    SQLite3JNI.sqlite3_interrupt(SWIGTYPE_p_sqlite3.getCPtr(arg0));
  }

  public static int sqlite3_complete(String sql) {
    return SQLite3JNI.sqlite3_complete(sql);
  }

  public static int sqlite3_busy_timeout(SWIGTYPE_p_sqlite3 arg0, int ms) {
    return SQLite3JNI.sqlite3_busy_timeout(SWIGTYPE_p_sqlite3.getCPtr(arg0), ms);
  }

  public static SWIGTYPE_p_void sqlite3_malloc(int arg0) {
    long cPtr = SQLite3JNI.sqlite3_malloc(arg0);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  public static SWIGTYPE_p_void sqlite3_realloc(SWIGTYPE_p_void arg0, int arg1) {
    long cPtr = SQLite3JNI.sqlite3_realloc(SWIGTYPE_p_void.getCPtr(arg0), arg1);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  public static void sqlite3_free(SWIGTYPE_p_void arg0) {
    SQLite3JNI.sqlite3_free(SWIGTYPE_p_void.getCPtr(arg0));
  }

  public static int sqlite3_open(String filename, SWIGTYPE_p_p_sqlite3 ppDb) {
    return SQLite3JNI.sqlite3_open(filename, SWIGTYPE_p_p_sqlite3.getCPtr(ppDb));
  }

  public static int sqlite3_errcode(SWIGTYPE_p_sqlite3 db) {
    return SQLite3JNI.sqlite3_errcode(SWIGTYPE_p_sqlite3.getCPtr(db));
  }

  public static String sqlite3_errmsg(SWIGTYPE_p_sqlite3 arg0) {
    return SQLite3JNI.sqlite3_errmsg(SWIGTYPE_p_sqlite3.getCPtr(arg0));
  }

  public static int sqlite3_bind_blob(SWIGTYPE_p_sqlite3_stmt arg0, int arg1, SWIGTYPE_p_void arg2, int n, SWIGTYPE_p_f_p_void__void arg4) {
    return SQLite3JNI.sqlite3_bind_blob(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1, SWIGTYPE_p_void.getCPtr(arg2), n, SWIGTYPE_p_f_p_void__void.getCPtr(arg4));
  }

  public static int sqlite3_bind_double(SWIGTYPE_p_sqlite3_stmt arg0, int arg1, double arg2) {
    return SQLite3JNI.sqlite3_bind_double(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1, arg2);
  }

  public static int sqlite3_bind_int(SWIGTYPE_p_sqlite3_stmt arg0, int arg1, int arg2) {
    return SQLite3JNI.sqlite3_bind_int(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1, arg2);
  }

  public static int sqlite3_bind_int64(SWIGTYPE_p_sqlite3_stmt arg0, int arg1, long arg2) {
    return SQLite3JNI.sqlite3_bind_int64(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1, arg2);
  }

  public static int sqlite3_bind_null(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
    return SQLite3JNI.sqlite3_bind_null(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
  }

  public static int sqlite3_bind_text(SWIGTYPE_p_sqlite3_stmt arg0, int arg1, String arg2, int n, SWIGTYPE_p_f_p_void__void arg4) {
    return SQLite3JNI.sqlite3_bind_text(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1, arg2, n, SWIGTYPE_p_f_p_void__void.getCPtr(arg4));
  }

  public static int sqlite3_bind_value(SWIGTYPE_p_sqlite3_stmt arg0, int arg1, SWIGTYPE_p_Mem arg2) {
    return SQLite3JNI.sqlite3_bind_value(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1, SWIGTYPE_p_Mem.getCPtr(arg2));
  }

  public static int sqlite3_bind_parameter_count(SWIGTYPE_p_sqlite3_stmt arg0) {
    return SQLite3JNI.sqlite3_bind_parameter_count(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0));
  }

  public static String sqlite3_bind_parameter_name(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
    return SQLite3JNI.sqlite3_bind_parameter_name(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
  }

  public static int sqlite3_bind_parameter_index(SWIGTYPE_p_sqlite3_stmt arg0, String zName) {
    return SQLite3JNI.sqlite3_bind_parameter_index(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), zName);
  }

  public static int sqlite3_clear_bindings(SWIGTYPE_p_sqlite3_stmt arg0) {
    return SQLite3JNI.sqlite3_clear_bindings(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0));
  }

  public static int sqlite3_column_count(SWIGTYPE_p_sqlite3_stmt pStmt) {
    return SQLite3JNI.sqlite3_column_count(SWIGTYPE_p_sqlite3_stmt.getCPtr(pStmt));
  }

  public static String sqlite3_column_name(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
    return SQLite3JNI.sqlite3_column_name(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
  }

  public static String sqlite3_column_database_name(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
    return SQLite3JNI.sqlite3_column_database_name(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
  }

  public static String sqlite3_column_table_name(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
    return SQLite3JNI.sqlite3_column_table_name(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
  }

  public static String sqlite3_column_origin_name(SWIGTYPE_p_sqlite3_stmt arg0, int arg1) {
    return SQLite3JNI.sqlite3_column_origin_name(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), arg1);
  }

  public static String sqlite3_column_decltype(SWIGTYPE_p_sqlite3_stmt arg0, int i) {
    return SQLite3JNI.sqlite3_column_decltype(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), i);
  }

  public static int sqlite3_step(SWIGTYPE_p_sqlite3_stmt arg0) {
    return SQLite3JNI.sqlite3_step(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0));
  }

  public static int sqlite3_data_count(SWIGTYPE_p_sqlite3_stmt pStmt) {
    return SQLite3JNI.sqlite3_data_count(SWIGTYPE_p_sqlite3_stmt.getCPtr(pStmt));
  }

  public static SWIGTYPE_p_void sqlite3_column_blob(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
    long cPtr = SQLite3JNI.sqlite3_column_blob(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  public static int sqlite3_column_bytes(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
    return SQLite3JNI.sqlite3_column_bytes(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
  }

  public static int sqlite3_column_bytes16(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
    return SQLite3JNI.sqlite3_column_bytes16(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
  }

  public static double sqlite3_column_double(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
    return SQLite3JNI.sqlite3_column_double(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
  }

  public static int sqlite3_column_int(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
    return SQLite3JNI.sqlite3_column_int(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
  }

  public static long sqlite3_column_int64(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
    return SQLite3JNI.sqlite3_column_int64(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
  }

  public static String sqlite3_column_text(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
    return SQLite3JNI.sqlite3_column_text(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
  }

  public static int sqlite3_column_type(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
    return SQLite3JNI.sqlite3_column_type(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
  }

  public static SWIGTYPE_p_Mem sqlite3_column_value(SWIGTYPE_p_sqlite3_stmt arg0, int iCol) {
    long cPtr = SQLite3JNI.sqlite3_column_value(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), iCol);
    return (cPtr == 0) ? null : new SWIGTYPE_p_Mem(cPtr, false);
  }

  public static int sqlite3_finalize(SWIGTYPE_p_sqlite3_stmt pStmt) {
    return SQLite3JNI.sqlite3_finalize(SWIGTYPE_p_sqlite3_stmt.getCPtr(pStmt));
  }

  public static int sqlite3_reset(SWIGTYPE_p_sqlite3_stmt pStmt) {
    return SQLite3JNI.sqlite3_reset(SWIGTYPE_p_sqlite3_stmt.getCPtr(pStmt));
  }

  public static SWIGTYPE_p_void sqlite3_value_blob(SWIGTYPE_p_Mem arg0) {
    long cPtr = SQLite3JNI.sqlite3_value_blob(SWIGTYPE_p_Mem.getCPtr(arg0));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  public static int sqlite3_value_bytes(SWIGTYPE_p_Mem arg0) {
    return SQLite3JNI.sqlite3_value_bytes(SWIGTYPE_p_Mem.getCPtr(arg0));
  }

  public static double sqlite3_value_double(SWIGTYPE_p_Mem arg0) {
    return SQLite3JNI.sqlite3_value_double(SWIGTYPE_p_Mem.getCPtr(arg0));
  }

  public static int sqlite3_value_int(SWIGTYPE_p_Mem arg0) {
    return SQLite3JNI.sqlite3_value_int(SWIGTYPE_p_Mem.getCPtr(arg0));
  }

  public static long sqlite3_value_int64(SWIGTYPE_p_Mem arg0) {
    return SQLite3JNI.sqlite3_value_int64(SWIGTYPE_p_Mem.getCPtr(arg0));
  }

  public static String sqlite3_value_text(SWIGTYPE_p_Mem arg0) {
    return SQLite3JNI.sqlite3_value_text(SWIGTYPE_p_Mem.getCPtr(arg0));
  }

  public static int sqlite3_value_type(SWIGTYPE_p_Mem arg0) {
    return SQLite3JNI.sqlite3_value_type(SWIGTYPE_p_Mem.getCPtr(arg0));
  }

  public static int sqlite3_value_numeric_type(SWIGTYPE_p_Mem arg0) {
    return SQLite3JNI.sqlite3_value_numeric_type(SWIGTYPE_p_Mem.getCPtr(arg0));
  }

  public static void sqlite3_result_blob(SWIGTYPE_p_sqlite3_context arg0, SWIGTYPE_p_void arg1, int arg2, SWIGTYPE_p_f_p_void__void arg3) {
    SQLite3JNI.sqlite3_result_blob(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), SWIGTYPE_p_void.getCPtr(arg1), arg2, SWIGTYPE_p_f_p_void__void.getCPtr(arg3));
  }

  public static void sqlite3_result_double(SWIGTYPE_p_sqlite3_context arg0, double arg1) {
    SQLite3JNI.sqlite3_result_double(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1);
  }

  public static void sqlite3_result_error(SWIGTYPE_p_sqlite3_context arg0, String arg1, int arg2) {
    SQLite3JNI.sqlite3_result_error(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1, arg2);
  }

  public static void sqlite3_result_error_code(SWIGTYPE_p_sqlite3_context arg0, int arg1) {
    SQLite3JNI.sqlite3_result_error_code(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1);
  }

  public static void sqlite3_result_int(SWIGTYPE_p_sqlite3_context arg0, int arg1) {
    SQLite3JNI.sqlite3_result_int(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1);
  }

  public static void sqlite3_result_int64(SWIGTYPE_p_sqlite3_context arg0, long arg1) {
    SQLite3JNI.sqlite3_result_int64(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1);
  }

  public static void sqlite3_result_null(SWIGTYPE_p_sqlite3_context arg0) {
    SQLite3JNI.sqlite3_result_null(SWIGTYPE_p_sqlite3_context.getCPtr(arg0));
  }

  public static void sqlite3_result_text(SWIGTYPE_p_sqlite3_context arg0, String arg1, int arg2, SWIGTYPE_p_f_p_void__void arg3) {
    SQLite3JNI.sqlite3_result_text(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), arg1, arg2, SWIGTYPE_p_f_p_void__void.getCPtr(arg3));
  }

  public static void sqlite3_result_value(SWIGTYPE_p_sqlite3_context arg0, SWIGTYPE_p_Mem arg1) {
    SQLite3JNI.sqlite3_result_value(SWIGTYPE_p_sqlite3_context.getCPtr(arg0), SWIGTYPE_p_Mem.getCPtr(arg1));
  }

  public static int sqlite3_sleep(int arg0) {
    return SQLite3JNI.sqlite3_sleep(arg0);
  }

  public static int sqlite3_expired(SWIGTYPE_p_sqlite3_stmt arg0) {
    return SQLite3JNI.sqlite3_expired(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0));
  }

  public static int sqlite3_transfer_bindings(SWIGTYPE_p_sqlite3_stmt arg0, SWIGTYPE_p_sqlite3_stmt arg1) {
    return SQLite3JNI.sqlite3_transfer_bindings(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0), SWIGTYPE_p_sqlite3_stmt.getCPtr(arg1));
  }

  public static int sqlite3_global_recover() {
    return SQLite3JNI.sqlite3_global_recover();
  }

  public static int sqlite3_get_autocommit(SWIGTYPE_p_sqlite3 arg0) {
    return SQLite3JNI.sqlite3_get_autocommit(SWIGTYPE_p_sqlite3.getCPtr(arg0));
  }

  public static SWIGTYPE_p_sqlite3 sqlite3_db_handle(SWIGTYPE_p_sqlite3_stmt arg0) {
    long cPtr = SQLite3JNI.sqlite3_db_handle(SWIGTYPE_p_sqlite3_stmt.getCPtr(arg0));
    return (cPtr == 0) ? null : new SWIGTYPE_p_sqlite3(cPtr, false);
  }

  public static int sqlite3_enable_shared_cache(int arg0) {
    return SQLite3JNI.sqlite3_enable_shared_cache(arg0);
  }

  public static void sqlite3_thread_cleanup() {
    SQLite3JNI.sqlite3_thread_cleanup();
  }

  public static int sqlite3_table_column_metadata(SWIGTYPE_p_sqlite3 db, String zDbName, String zTableName, String zColumnName, SWIGTYPE_p_p_char pzDataType, SWIGTYPE_p_p_char pzCollSeq, SWIGTYPE_p_int pNotNull, SWIGTYPE_p_int pPrimaryKey, SWIGTYPE_p_int pAutoinc) {
    return SQLite3JNI.sqlite3_table_column_metadata(SWIGTYPE_p_sqlite3.getCPtr(db), zDbName, zTableName, zColumnName, SWIGTYPE_p_p_char.getCPtr(pzDataType), SWIGTYPE_p_p_char.getCPtr(pzCollSeq), SWIGTYPE_p_int.getCPtr(pNotNull), SWIGTYPE_p_int.getCPtr(pPrimaryKey), SWIGTYPE_p_int.getCPtr(pAutoinc));
  }

  public static int sqlite3_load_extension(SWIGTYPE_p_sqlite3 db, String zFile, String zProc, SWIGTYPE_p_p_char pzErrMsg) {
    return SQLite3JNI.sqlite3_load_extension(SWIGTYPE_p_sqlite3.getCPtr(db), zFile, zProc, SWIGTYPE_p_p_char.getCPtr(pzErrMsg));
  }

  public static int sqlite3_enable_load_extension(SWIGTYPE_p_sqlite3 db, int onoff) {
    return SQLite3JNI.sqlite3_enable_load_extension(SWIGTYPE_p_sqlite3.getCPtr(db), onoff);
  }

  public static int sqlite3_auto_extension(SWIGTYPE_p_void xEntryPoint) {
    return SQLite3JNI.sqlite3_auto_extension(SWIGTYPE_p_void.getCPtr(xEntryPoint));
  }

  public static void sqlite3_reset_auto_extension() {
    SQLite3JNI.sqlite3_reset_auto_extension();
  }

  public static SWIGTYPE_p_p_sqlite3 new_p_p_sqlite3() {
    long cPtr = SQLite3JNI.new_p_p_sqlite3();
    return (cPtr == 0) ? null : new SWIGTYPE_p_p_sqlite3(cPtr, false);
  }

  public static void delete_p_p_sqlite3(SWIGTYPE_p_p_sqlite3 self) {
    SQLite3JNI.delete_p_p_sqlite3(SWIGTYPE_p_p_sqlite3.getCPtr(self));
  }

  public static SWIGTYPE_p_sqlite3 get_p_sqlite3(SWIGTYPE_p_p_sqlite3 self) {
    long cPtr = SQLite3JNI.get_p_sqlite3(SWIGTYPE_p_p_sqlite3.getCPtr(self));
    return (cPtr == 0) ? null : new SWIGTYPE_p_sqlite3(cPtr, false);
  }

  public static SWIGTYPE_p_p_sqlite3_stmt new_p_p_sqlite3_stmt() {
    long cPtr = SQLite3JNI.new_p_p_sqlite3_stmt();
    return (cPtr == 0) ? null : new SWIGTYPE_p_p_sqlite3_stmt(cPtr, false);
  }

  public static void delete_p_p_sqlite3_stmt(SWIGTYPE_p_p_sqlite3_stmt self) {
    SQLite3JNI.delete_p_p_sqlite3_stmt(SWIGTYPE_p_p_sqlite3_stmt.getCPtr(self));
  }

  public static SWIGTYPE_p_sqlite3_stmt get_p_sqlite3_stmt(SWIGTYPE_p_p_sqlite3_stmt self) {
    long cPtr = SQLite3JNI.get_p_sqlite3_stmt(SWIGTYPE_p_p_sqlite3_stmt.getCPtr(self));
    return (cPtr == 0) ? null : new SWIGTYPE_p_sqlite3_stmt(cPtr, false);
  }

  public static SWIGTYPE_p_p_char new_p_p_char() {
    long cPtr = SQLite3JNI.new_p_p_char();
    return (cPtr == 0) ? null : new SWIGTYPE_p_p_char(cPtr, false);
  }

  public static void delete_p_p_char(SWIGTYPE_p_p_char self) {
    SQLite3JNI.delete_p_p_char(SWIGTYPE_p_p_char.getCPtr(self));
  }

  public static String get_p_char(SWIGTYPE_p_p_char self) {
    return SQLite3JNI.get_p_char(SWIGTYPE_p_p_char.getCPtr(self));
  }

  public static SWIGTYPE_p_int new_p_int() {
    long cPtr = SQLite3JNI.new_p_int();
    return (cPtr == 0) ? null : new SWIGTYPE_p_int(cPtr, false);
  }

  public static void delete_p_int(SWIGTYPE_p_int self) {
    SQLite3JNI.delete_p_int(SWIGTYPE_p_int.getCPtr(self));
  }

  public static int get_int(SWIGTYPE_p_int self) {
    return SQLite3JNI.get_int(SWIGTYPE_p_int.getCPtr(self));
  }

  private static int sqlite3_bind_blob_by_bytes(SWIGTYPE_p_sqlite3_stmt pStmt, int parameterIndex, byte[] BYTE, int length, SWIGTYPE_p_f_p_void__void xDel) {
    return SQLite3JNI.sqlite3_bind_blob_by_bytes(SWIGTYPE_p_sqlite3_stmt.getCPtr(pStmt), parameterIndex, BYTE, length, SWIGTYPE_p_f_p_void__void.getCPtr(xDel));
  }

  public static void read_blob(SWIGTYPE_p_void blob, long pos, byte[] BYTE, int offset, int len) {
    SQLite3JNI.read_blob(SWIGTYPE_p_void.getCPtr(blob), pos, BYTE, offset, len);
  }

  public static SWIGTYPE_p_Mem get_p_sqlite3_value(SWIGTYPE_p_p_Mem value, int i) {
    long cPtr = SQLite3JNI.get_p_sqlite3_value(SWIGTYPE_p_p_Mem.getCPtr(value), i);
    return (cPtr == 0) ? null : new SWIGTYPE_p_Mem(cPtr, false);
  }

  public static void sqlite3_result_blob_by_bytes(SWIGTYPE_p_sqlite3_context pCtx, byte[] BYTE, int length, SWIGTYPE_p_f_p_void__void xDel) {
    SQLite3JNI.sqlite3_result_blob_by_bytes(SWIGTYPE_p_sqlite3_context.getCPtr(pCtx), BYTE, length, SWIGTYPE_p_f_p_void__void.getCPtr(xDel));
  }

  public static String sqlite3_get_errmsg(int rc) {
    return SQLite3JNI.sqlite3_get_errmsg(rc);
  }

}
