package org.sqlite.profiler;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.sqlite.Database;
import org.sqlite.jdbc.JdbcConnection;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class ProfilerTest {

    public ProfilerTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private static final String DRIVER_CLASS = "org.sqlite.Driver";
    private static final String DATABASE = System.getProperty("user.dir") + "/test/unittest.db";

    private static Database newDatabase() throws ClassNotFoundException, SQLException {
        Class.forName(DRIVER_CLASS);
        return new Database(DATABASE, null);
    }
    
    private static Connection newConnection(Database db) throws ClassNotFoundException, SQLException {
        return new JdbcConnection(db, null);
    }
    
    @Test
    public void setProfiler() throws ClassNotFoundException, SQLException {
        final Database db = newDatabase();
        final Profiler prof
                = new Profiler() {
                        @Override
                        protected void xProfile(String sql, long elapseTime) {
                            System.out.println(elapseTime + " : " + sql);
                        }
                    };
        assertFalse(prof.isRegistered());
        try {
            db.setProfiler(prof);
            assertTrue(prof.isRegistered());
            
            final Connection conn = newConnection(db);
            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS tbl_profiler_test("
                        + "  ID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", VALUE TEXT"
                    + ")";
            stmt.executeUpdate(sql);            
            
            stmt.close();
            
        } finally {
            db.close();
            assertFalse(prof.isRegistered());
        }
    }
}