package org.sqlite.event;

import org.sqlite.callback.Callback;

/**
 * INSERT, UPDATE, DELETE hook class.
 * @author calico
 * @see <a href="http://sqlite.org/c3ref/update_hook.html">Data Change Notification Callbacks</a>
 * @see org.sqlite.jdbc.JdbcConnection#setUpdateHook(UpdateHook)
 * @see org.sqlite.jdbc.JdbcConnection#clearUpdateHook()
 */
public abstract class UpdateHook extends Callback {

    /**
     * invoke when a row is updated, inserted or deleted.
     * @param action SQLITE_INSERT or SQLITE_DELETE or SQLITE_UPDATE
     * @param dbName database name
     * @param tableName table name
     * @param rowId rowid
     * @see <a href="http://sqlite.org/c3ref/c_alter_table.html">Authorizer Action Codes</a>
     */
    protected abstract void xUpdate(int action, String dbName, String tableName, long rowId);
}
