import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import org.sqlite.event.CollationNeededHandler;
import org.sqlite.jdbc.JdbcConnection;
import org.sqlite.text.Collator;

public class CollationNeededHandlerExample {

    @org.junit.Test
    public void example() throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.Driver");
        final String url = "jdbc:sqlite:mem:";
        final JdbcConnection conn = (JdbcConnection) DriverManager.getConnection(url);
        try {
            // new collation needed handler
            final CollationNeededHandler handler = new CollationNeededHandler();

            // set collation needed handler
            conn.setCollationNeededHandler(handler);

            // new collation sequence
            final Collator myCollSeq
                    = new Collator("LOGGING") {
                            public int compare(String str1, String str2) {
                                final Logger logger = Logger.getLogger("global");
                                logger.info("str1 = '" + str1 + "', str2 = '" + str2 + "'");
                                return 0;
                            }
                        };

            // add collation sequence
            handler.addCollator(myCollSeq);
            
            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS temp_tbl_1("
                        + "  ID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", VALUE TEXT COLLATE LOGGING"
                    + ")";
            stmt.executeUpdate(sql);

            sql = "INSERT INTO temp_tbl_1 VALUES(1, 'One');"
                    + "INSERT INTO temp_tbl_1 VALUES(2, 'Two');"
                    + "INSERT INTO temp_tbl_1 VALUES(3, 'Three');"
                    + "INSERT INTO temp_tbl_1 VALUES(4, 'Four');"
                    + "INSERT INTO temp_tbl_1 VALUES(5, 'Five');";
            stmt.execute(sql);

            sql = "SELECT * FROM temp_tbl_1 ORDER BY VALUE";
            for (final ResultSet rs = stmt.executeQuery(sql); rs.next(); ) {
                System.out.println(rs.getString(1) + " : " + rs.getString(2));
            }
            
            stmt.close();

            // clear collation sequence handler
            conn.clearCollationNeededHandler();

        } finally {
            conn.close();
        }
    }

    public static void main(String[] args) throws Exception {
        new CollationNeededHandlerExample().example();
    }

}
