package org.sqlite.event;

import org.sqlite.callback.Callback;

/**
 * SQLITE_BUSY Error Handler class.
 * @author calico
 * @see <a href="http://sqlite.org/c3ref/busy_handler.html">Register A Callback To Handle SQLITE_BUSY Errors</a>
 */
public abstract class BusyHandler extends Callback {

    /**
     * Called from the sqlite3_step() function.
     * @param count the number of times that the busy handler has been invoked for this locking event.
     * @return non-zero if the operation is continued. 0 if the operation is interrupted.
     */
    protected abstract int xBusy(int count);
}
