package org.sqlite;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import org.sqlite.jdbc.JdbcConnection;
import org.sqlite.jdbc.Scheme;

/**
 * SQLite JDBC Driver class
 * @author calico
 */
public class Driver implements java.sql.Driver {
    static {
        try {
            System.loadLibrary("sqlite3jni");
            DriverManager.registerDriver(new org.sqlite.Driver());
        } catch (SQLException ex) {
            Logger.getLogger(Driver.class.getName()).throwing(Driver.class.getName(), "<clinit>", ex);
            throw new Error(ex.fillInStackTrace());
        }
    }

    /**
     * It always returns "SQLite JDBC Driver".
     * @return "SQLite JDBC Driver"
     */
    public static String getDriverName() {
        return "SQLite JDBC Driver";
    }
    
    public static String getDriverVersion() {
        return getDriverMajorVersion()
                + "." + getDriverMinorVersion()
                + "." + getDriverReleaseVersion();
    }
    
    public static int getDriverMajorVersion() {
        return 0;
    }
    
    public static int getDriverMinorVersion() {
        return 0;
    }
    
    public static int getDriverReleaseVersion() {
        return 3;
    }
    
    // START implements
    public boolean acceptsURL(String url) {
        for (Scheme scheme : Scheme.values()) {
            if (scheme.matches(url)) {
                return true;
            }
        }
        return false;
    }

    public Connection connect(String url, Properties info) throws SQLException {
        for (final Scheme scheme : Scheme.values()) {
            final Properties prop = scheme.parse(url);
            if (prop != null) {
                final String filename = (String) prop.remove(";filename;");
                if (info != null) {
                    prop.putAll(info);
                }
                final Database db = new Database(filename, prop);
                return new JdbcConnection(db, url);
            }
        }
        // unsupported URL
        return null;
    }

    /**
     * invoke getDriverMajorVersion() method.
     * @return
     * @see org.sqlite.Driver#getDriverMajorVersion()
     */
    public int getMajorVersion() {
        return getDriverMajorVersion();
    }

    /**
     * invoke getDriverMinorVersion() method.
     * @return
     * @see org.sqlite.Driver#getDriverMinorVersion()
     */
    public int getMinorVersion() {
        return getDriverMinorVersion();
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        // TODO do implements!
        return new DriverPropertyInfo[] {
                    new DriverPropertyInfo("OPEN_MODE", "READWRITE"),
                    new DriverPropertyInfo("TRANSACTION_TYPE", "DEFERRED"),
                    new DriverPropertyInfo("ENCODING", "UTF-8"),
                    new DriverPropertyInfo("BUSY_TIMEOUT", "0"),
                    new DriverPropertyInfo("CACHE_SIZE", "2000"),
                    // @see sqliteLimit.h - SQLITE_DEFAULT_CACHE_SIZE
                    new DriverPropertyInfo("DEFAULT_CACHE_SIZE", "2000"),
                    // @see sqliteLimit.h - SQLITE_DEFAULT_PAGE_SIZE
                    new DriverPropertyInfo("PAGE_SIZE", "1024"),
                    // @see sqliteLimit.h - SQLITE_MAX_PAGE_COUNT
                    new DriverPropertyInfo("MAX_PAGE_COUNT", "1073741823"),
                };
    }

    /**
     * It always returns false.
     * @return false
     */
    public boolean jdbcCompliant() {
        return false;
    }
    // END implements
    
}
