/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flex2.compiler.util.Edge;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Vertex {
    private static final int INITIAL_CAPACITY = 5;
    private Object weight;
    int id;
    private Set incidentEdges;
    private Set emanatingEdges;
    private Set predecessors;
    private List successors;

    public Vertex(Object weight) {
        this.weight = weight;
    }

    public Object getWeight() {
        return this.weight;
    }

    public void addIncidentEdge(Edge e) {
        if (this.incidentEdges == null) {
            this.incidentEdges = new HashSet(5);
        }
        this.incidentEdges.add(e);
    }

    public void removeIncidentEdge(Edge e) {
        if (this.incidentEdges != null) {
            this.incidentEdges.remove(e);
        }
    }

    public Set getIncidentEdges() {
        return this.incidentEdges;
    }

    public void addEmanatingEdge(Edge e) {
        if (this.emanatingEdges == null) {
            this.emanatingEdges = new HashSet(5);
        }
        this.emanatingEdges.add(e);
    }

    public void removeEmanatingEdge(Edge e) {
        if (this.emanatingEdges != null) {
            this.emanatingEdges.remove(e);
        }
    }

    public Set getEmanatingEdges() {
        return this.emanatingEdges;
    }

    public void addPredecessor(Vertex v) {
        if (this.predecessors == null) {
            this.predecessors = new HashSet(5);
        }
        this.predecessors.add(v);
    }

    public void removePredecessor(Vertex v) {
        if (this.predecessors != null) {
            this.predecessors.remove(v);
        }
    }

    public Set getPredecessors() {
        return this.predecessors;
    }

    public void addSuccessor(Vertex v) {
        if (this.successors == null) {
            this.successors = new ArrayList(5);
        }
        this.successors.add(v);
    }

    public void removeSuccessor(Vertex v) {
        if (this.successors != null) {
            this.successors.remove(v);
        }
    }

    public List getSuccessors() {
        return this.successors;
    }

    public int inDegrees() {
        return this.incidentEdges == null ? 0 : this.incidentEdges.size();
    }

    public int outDegrees() {
        return this.emanatingEdges == null ? 0 : this.emanatingEdges.size();
    }

    public boolean equals(Object object) {
        if (object instanceof Vertex) {
            return this.weight == null ? super.equals(object) : this.weight.equals(((Vertex)object).weight);
        }
        return false;
    }

    public int hashCode() {
        return this.weight != null ? this.weight.hashCode() : super.hashCode();
    }
}

