/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.OutlineConsumer2;

public class OutlineConsumerAdapter
implements OutlineConsumer {
    final OutlineConsumer2 dest;
    protected boolean contourStarted;
    double startX;
    double startY;
    double currentX;
    double currentY;
    protected Matrix toEmMatrix = Matrix.IDENTITY_MATRIX;
    protected Matrix emToDeviceMatrix = Matrix.IDENTITY_MATRIX;
    protected Matrix compositeMatrix = Matrix.IDENTITY_MATRIX;

    public OutlineConsumerAdapter(OutlineConsumer2 outlineConsumer2) {
        this.dest = outlineConsumer2;
    }

    public void startOutline() {
        this.dest.startOutline();
        this.contourStarted = false;
    }

    public void setMatrix(Matrix matrix) {
        this.setMatrices(matrix, this.emToDeviceMatrix);
    }

    public void setEmToPixelMatrix(Matrix matrix) {
        this.setMatrices(this.toEmMatrix, matrix);
    }

    protected void setMatrices(Matrix matrix, Matrix matrix2) {
        this.toEmMatrix = matrix;
        this.emToDeviceMatrix = matrix2;
        this.compositeMatrix = matrix.isIdentity() ? matrix2 : (matrix2.isIdentity() ? matrix : matrix.multiply(matrix2));
    }

    public void moveto(double d, double d2) {
        if (this.contourStarted) {
            this.dest.line(this.compositeMatrix.applyToXYGetX(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetY(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetX(this.startX, this.startY), this.compositeMatrix.applyToXYGetY(this.startX, this.startY));
            this.dest.endContour();
            this.contourStarted = false;
        }
        this.currentX = d;
        this.currentY = d2;
    }

    public void lineto(double d, double d2) {
        if (!this.contourStarted) {
            this.dest.startContour();
            this.contourStarted = true;
            this.startX = this.currentX;
            this.startY = this.currentY;
        }
        this.dest.line(this.compositeMatrix.applyToXYGetX(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetY(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetX(d, d2), this.compositeMatrix.applyToXYGetY(d, d2));
        this.currentX = d;
        this.currentY = d2;
    }

    public void curveto(double d, double d2, double d3, double d4) {
        if (!this.contourStarted) {
            this.dest.startContour();
            this.contourStarted = true;
            this.startX = this.currentX;
            this.startY = this.currentY;
        }
        this.dest.quadraticCurve(this.compositeMatrix.applyToXYGetX(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetY(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetX(d, d2), this.compositeMatrix.applyToXYGetY(d, d2), this.compositeMatrix.applyToXYGetX(d3, d4), this.compositeMatrix.applyToXYGetY(d3, d4));
        this.currentX = d3;
        this.currentY = d4;
    }

    public void curveto(double d, double d2, double d3, double d4, double d5, double d6) {
        if (!this.contourStarted) {
            this.dest.startContour();
            this.contourStarted = true;
            this.startX = this.currentX;
            this.startY = this.currentY;
        }
        this.dest.cubicCurve(this.compositeMatrix.applyToXYGetX(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetY(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetX(d, d2), this.compositeMatrix.applyToXYGetY(d, d2), this.compositeMatrix.applyToXYGetX(d3, d4), this.compositeMatrix.applyToXYGetY(d3, d4), this.compositeMatrix.applyToXYGetX(d5, d6), this.compositeMatrix.applyToXYGetY(d5, d6));
        this.currentX = d5;
        this.currentY = d6;
    }

    public void endOutline() {
        if (this.contourStarted) {
            if (this.currentX != this.startX || this.currentY != this.startY) {
                this.dest.line(this.compositeMatrix.applyToXYGetX(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetY(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetX(this.startX, this.startY), this.compositeMatrix.applyToXYGetY(this.startX, this.startY));
            }
            this.dest.endContour();
        }
        this.dest.endOutline();
    }

    public void endchar() {
    }
}

