/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.events;

import flash.util.StringUtils;
import flex.webtier.server.j2ee.events.BaseOutputHandler;
import flex.webtier.server.j2ee.events.CompileEvent;
import flex.webtier.server.j2ee.events.SourceCodeLoader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;

public class XmlOutputHandler
extends BaseOutputHandler {
    private PrintWriter out;
    private String webRoot;

    public XmlOutputHandler(PrintWriter out, String mxmlFileName, String webRoot, Vector events, SourceCodeLoader sourceCodeLoader) {
        super(mxmlFileName, webRoot, events, sourceCodeLoader);
        this.out = out;
        this.webRoot = webRoot;
    }

    private String normalizePath(String path) {
        int i = 0;
        if (path == null || path.equals(this.webRoot)) {
            path = this.sourceFileName;
        }
        if (path.startsWith(this.webRoot)) {
            if (this.webRoot.endsWith("/") || this.webRoot.endsWith("\\")) {
                i = 1;
            }
            path = path.substring(this.webRoot.length() - i).replace('\\', '/');
        }
        return path;
    }

    private static String xmlTagName(int eventType) {
        if (eventType == 1) {
            return "error";
        }
        if (eventType == 2) {
            return "warning";
        }
        if (eventType == 3) {
            return "exception";
        }
        if (eventType == 0) {
            return "info";
        }
        return "unknown";
    }

    protected void outputEvents() {
        this.out.println("<messages>");
        for (int i = 0; i < this.events.size(); ++i) {
            CompileEvent ce = (CompileEvent)this.events.get(i);
            String tagName = XmlOutputHandler.xmlTagName(ce.eventType);
            this.out.println("<" + tagName + ">");
            if (ce.eventType == 3) {
                this.out.println("    <exceptionType>" + ce.exception + "</exceptionType>");
                if (ce.description != null) {
                    this.out.println("    <description>" + StringUtils.entitizeHtml((String)ce.description) + "</description>");
                }
                StringWriter stackTrace = new StringWriter();
                PrintWriter pw = new PrintWriter(stackTrace);
                ce.exception.printStackTrace(pw);
                this.out.println("<stackTrace>" + stackTrace + "</stackTrace>");
            } else {
                if (ce.code > 0) {
                    this.out.println("  <code>" + ce.code + "</code>");
                }
                this.out.println("  <path>" + this.normalizePath(ce.path) + "</path>");
                this.out.println("  <line>" + ce.line + "</line>");
                this.out.println("  <description>" + StringUtils.entitizeHtml((String)ce.description) + "</description>");
            }
            this.out.println("</" + tagName + ">");
        }
        this.out.println("</messages>");
    }
}

