/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee;

import java.io.UnsupportedEncodingException;

public final class URLDecoder {
    public static String decode(String s) {
        try {
            return URLDecoder.decode(s, "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("UTF8");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String decode(String s, String enc) throws UnsupportedEncodingException {
        if (!URLDecoder.needsDecoding(s)) {
            return s;
        }
        int length = s.length();
        byte[] bytes = new byte[length];
        s.getBytes(0, length, bytes, 0);
        int k = 0;
        length = bytes.length;
        for (int i = 0; i < length; ++i) {
            if (bytes[i] == 37) {
                while (bytes[i + 1] == 37) {
                    ++i;
                }
                if (i >= length - 2) throw new IllegalArgumentException(s);
                bytes[k] = URLDecoder.x2c(bytes, i);
                i += 2;
            } else {
                bytes[k] = bytes[i] == 43 ? 32 : bytes[i];
            }
            ++k;
        }
        return new String(bytes, 0, k, enc);
    }

    private static boolean needsDecoding(String s) {
        if (s == null) {
            return false;
        }
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c != '+' && c != '%') continue;
            return true;
        }
        return false;
    }

    private static byte x2c(byte[] b, int i) {
        byte b1 = b[i + 1];
        byte b2 = b[i + 2];
        if (b1 < 48 || b1 > 70 && b1 < 97 || b1 > 102 || b2 < 48 || b2 > 70 && b2 < 97 || b2 > 102) {
            throw new IllegalArgumentException("%" + (char)b1 + (char)b2);
        }
        int result = b1 >= 65 ? (b1 & 0xDF) - 65 + 10 : b1 - 48;
        result *= 16;
        return (byte)(result += b2 >= 65 ? (b2 & 0xDF) - 65 + 10 : b2 - 48);
    }
}

