/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.html;

import flex.webtier.server.j2ee.MxmlContext;
import flex.webtier.server.j2ee.URLEncoder;
import flex.webtier.server.j2ee.html.BaseSwfRenderer;
import flex.webtier.server.j2ee.html.JavascriptWriter;
import java.io.PrintWriter;

public class SwfRenderer
extends BaseSwfRenderer {
    public static int NO_SCRIPT = 0;
    public static int SCRIPT = 1;
    public static int EXTERNAL_SCRIPT = 2;

    public void renderEmbeddedSwf(MxmlContext context, PrintWriter output, int script) {
        if (script == SCRIPT) {
            this.renderObjectEmbedTags(context, output, true);
        } else if (script == NO_SCRIPT) {
            output.println("<noscript>");
            this.renderObjectEmbedTags(context, output, false);
            output.println("</noscript>");
        } else if (script == EXTERNAL_SCRIPT) {
            output.print("<script src=\"" + this.getObjectWebPath(context) + "\">");
            output.println("</script>");
        }
    }

    protected String getObjectWebPath(MxmlContext context) {
        StringBuffer uri = new StringBuffer(context.getObjectUri());
        if (uri.indexOf("?") != -1) {
            uri.append("&");
        } else {
            uri.append("?");
        }
        uri.append("objectWrapperJs=true&w=");
        uri.append(URLEncoder.encode(context.getWidth()));
        uri.append("&h=");
        uri.append(URLEncoder.encode(context.getHeight()));
        String fullUri = uri.toString().startsWith("/") ? context.getRequest().getContextPath() + uri.toString() : uri.toString();
        String encodedObjectUri = this.encodeSrcUrl(fullUri);
        return encodedObjectUri;
    }

    public void renderObjectEmbedTags(MxmlContext context, PrintWriter output, boolean isScript) {
        String pluginDownloadUrl = this.getPluginDownloadUrl(context.isSecureRequest());
        String activexDownloadUrl = this.getActivexDownloadUrl(context.isSecureRequest());
        String h = context.getHeight();
        String w = context.getWidth();
        String swfIdName = this.getSwfId(context);
        String swfWebPath = this.getSwfWebPath(context);
        if (isScript) {
            JavascriptWriter.renderBeginDocWrite(output);
        }
        output.print("<object id='" + swfIdName + "' classid='" + this.configuration.getClassid() + "' codebase='" + activexDownloadUrl + "' height='" + h + "' width='" + w + "'>");
        if (isScript) {
            JavascriptWriter.renderEndDocWrite(output);
        }
        output.println();
        this.renderParamTags(context, output, swfWebPath, isScript);
        if (isScript) {
            JavascriptWriter.renderBeginDocWrite(output);
        }
        output.print("<embed name='" + swfIdName + "' pluginspage='" + pluginDownloadUrl + "' src='" + swfWebPath + "' height='" + h + "' width='" + w + "' flashvars='" + this.getFlashVars(context, isScript) + "'/>");
        if (isScript) {
            JavascriptWriter.renderEndDocWrite(output);
        }
        output.println();
        if (isScript) {
            JavascriptWriter.renderBeginDocWrite(output);
        }
        output.print("</object>");
        if (isScript) {
            JavascriptWriter.renderEndDocWrite(output);
        }
        output.println();
    }

    private void renderParamTags(MxmlContext context, PrintWriter output, String swfWebPath, boolean isScript) {
        if (isScript) {
            JavascriptWriter.renderBeginDocWrite(output);
        }
        output.print("<param name='flashvars' value='" + this.getFlashVars(context, isScript) + "'/>");
        if (isScript) {
            JavascriptWriter.renderEndDocWrite(output);
        }
        output.println();
        if (isScript) {
            JavascriptWriter.renderBeginDocWrite(output);
        }
        output.print("<param name='src' value='" + swfWebPath + "'/>");
        if (isScript) {
            JavascriptWriter.renderEndDocWrite(output);
        }
        output.println();
    }
}

