/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.impl;

import com.adobe.agl.converters.UConverter;
import com.adobe.agl.impl.UConverterFromUnicodeArgs;
import com.adobe.agl.impl.UConverterToUnicodeArgs;
import com.adobe.agl.impl.UConverterUtility;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;

public final class UConverterExt {
    public static final int UCNV_EXT_INDEXES_LENGTH = 0;
    public static final int UCNV_EXT_TO_U_INDEX = 1;
    public static final int UCNV_EXT_TO_U_LENGTH = 2;
    public static final int UCNV_EXT_TO_U_UCHARS_INDEX = 3;
    public static final int UCNV_EXT_TO_U_UCHARS_LENGTH = 4;
    public static final int UCNV_EXT_FROM_U_UCHARS_INDEX = 5;
    public static final int UCNV_EXT_FROM_U_VALUES_INDEX = 6;
    public static final int UCNV_EXT_FROM_U_LENGTH = 7;
    public static final int UCNV_EXT_FROM_U_BYTES_INDEX = 8;
    public static final int UCNV_EXT_FROM_U_BYTES_LENGTH = 9;
    public static final int UCNV_EXT_FROM_U_STAGE_12_INDEX = 10;
    public static final int UCNV_EXT_FROM_U_STAGE_1_LENGTH = 11;
    public static final int UCNV_EXT_FROM_U_STAGE_12_LENGTH = 12;
    public static final int UCNV_EXT_FROM_U_STAGE_3_INDEX = 13;
    public static final int UCNV_EXT_FROM_U_STAGE_3_LENGTH = 14;
    public static final int UCNV_EXT_FROM_U_STAGE_3B_INDEX = 15;
    public static final int UCNV_EXT_FROM_U_STAGE_3B_LENGTH = 16;
    public static final int UCNV_EXT_COUNT_BYTES = 17;
    public static final int UCNV_EXT_COUNT_UCHARS = 18;
    public static final int UCNV_EXT_FLAGS = 19;
    public static final int UCNV_EXT_RESERVED_INDEX = 20;
    public static final int UCNV_EXT_SIZE = 31;
    public static final int UCNV_EXT_INDEXES_MIN_LENGTH = 32;
    public static final int UCNV_EXT_TO_U_BYTE_SHIFT = 24;
    public static final int UCNV_EXT_TO_U_VALUE_MASK = 0xFFFFFF;
    public static final int UCNV_EXT_TO_U_MIN_CODE_POINT = 0x1F0000;
    public static final int UCNV_EXT_TO_U_MAX_CODE_POINT = 0x2FFFFF;
    public static final int UCNV_EXT_TO_U_ROUNDTRIP_FLAG = 0x800000;
    public static final int UCNV_EXT_TO_U_INDEX_MASK = 262143;
    public static final int UCNV_EXT_TO_U_LENGTH_SHIFT = 18;
    public static final int UCNV_EXT_TO_U_LENGTH_OFFSET = 12;
    public static final int UCNV_EXT_MAX_UCHARS = 19;
    public static final int UCNV_EXT_STAGE_2_LEFT_SHIFT = 2;
    public static final int UCNV_EXT_STAGE_3_GRANULARITY = 4;
    public static final int UCNV_EXT_FROM_U_LENGTH_SHIFT = 24;
    public static final int UCNV_EXT_FROM_U_ROUNDTRIP_FLAG = Integer.MIN_VALUE;
    public static final int UCNV_EXT_FROM_U_RESERVED_MASK = 0x60000000;
    public static final int UCNV_EXT_FROM_U_DATA_MASK = 0xFFFFFF;
    public static final int UCNV_EXT_FROM_U_SUBCHAR1 = -2147483647;
    public static final int UCNV_EXT_FROM_U_MAX_DIRECT_LENGTH = 3;
    public static final int UCNV_EXT_MAX_BYTES = 31;

    public static Buffer UCNV_EXT_ARRAY(ByteBuffer indexes, int index, Class itemType) {
        int oldpos = indexes.position();
        indexes.position(indexes.getInt(index * 4));
        Buffer b = itemType == Integer.TYPE ? indexes.asIntBuffer() : (itemType == Short.TYPE ? indexes.asShortBuffer() : (itemType == Byte.TYPE ? indexes.slice() : (itemType == Character.TYPE ? indexes.asCharBuffer() : indexes.slice())));
        indexes.position(oldpos);
        return b;
    }

    public static int UCNV_GET_MAX_BYTES_PER_UCHAR(ByteBuffer indexes) {
        indexes.position(0);
        IntBuffer a = indexes.asIntBuffer();
        if (a.hasArray()) {
            int n = a.array()[17];
        } else {
            int n = a.get(17);
        }
        return indexes.getInt(68) & 0xFF;
    }

    public static final int UCNV_EXT_TO_U_GET_BYTE(int word) {
        return word >>> 24;
    }

    public static final int UCNV_EXT_TO_U_GET_VALUE(int word) {
        return word & 0xFFFFFF;
    }

    public static boolean UCNV_EXT_TO_U_IS_ROUNDTRIP(int value) {
        return (value & 0x800000) != 0;
    }

    public static final boolean UCNV_EXT_TO_U_IS_PARTIAL(int value) {
        return ((long)value & 0xFFFFFFFFL) < 0x1F0000L;
    }

    public static final int UCNV_EXT_TO_U_GET_PARTIAL_INDEX(int value) {
        return value;
    }

    public static final int UCNV_EXT_TO_U_MASK_ROUNDTRIP(int value) {
        return value & 0xFF7FFFFF;
    }

    public static final int UCNV_EXT_TO_U_MAKE_WORD(byte b, int value) {
        return (b & 0xFF) << 24 | value;
    }

    public static boolean UCNV_EXT_TO_U_IS_CODE_POINT(int value) {
        return ((long)value & 0xFFFFFFFFL) <= 0x2FFFFFL;
    }

    public static int UCNV_EXT_TO_U_GET_CODE_POINT(int value) {
        return (int)(((long)value & 0xFFFFFFFFL) - 0x1F0000L);
    }

    public static int UCNV_EXT_TO_U_GET_INDEX(int value) {
        return value & 0x3FFFF;
    }

    public static final int UCNV_EXT_TO_U_GET_LENGTH(int value) {
        return (value >>> 18) - 12;
    }

    public static final int UCNV_EXT_FROM_U(CharBuffer stage12, CharBuffer stage3, int s1Index, int c) {
        return stage3.get(stage3.position() + (stage12.get(stage12.position() + (stage12.get(stage12.position() + s1Index) + (c >>> 4 & 0x3F))) << 2) + (c & 0xF));
    }

    public static final boolean UCNV_EXT_FROM_U_IS_PARTIAL(int value) {
        return value >>> 24 == 0;
    }

    public static final int UCNV_EXT_FROM_U_GET_PARTIAL_INDEX(int value) {
        return value;
    }

    public static final boolean UCNV_EXT_FROM_U_IS_ROUNDTRIP(int value) {
        return (value & Integer.MIN_VALUE) != 0;
    }

    public static final int UCNV_EXT_FROM_U_MASK_ROUNDTRIP(int value) {
        return value & Integer.MAX_VALUE;
    }

    public static final int UCNV_EXT_FROM_U_GET_LENGTH(int value) {
        return value >>> 24 & 0x1F;
    }

    public static final int UCNV_EXT_FROM_U_GET_DATA(int value) {
        return value & 0xFFFFFF;
    }

    static int ucnv_extFindToU(IntBuffer toUSection, int length, short byt) {
        int i;
        int start = UConverterExt.UCNV_EXT_TO_U_GET_BYTE(toUSection.get(toUSection.position()));
        int limit = UConverterExt.UCNV_EXT_TO_U_GET_BYTE(toUSection.get(toUSection.position() + length - 1));
        if (byt < start || limit < byt) {
            return 0;
        }
        if (length == limit - start + 1) {
            return UConverterExt.UCNV_EXT_TO_U_GET_VALUE(toUSection.get(toUSection.position() + byt - start));
        }
        long word0 = (long)UConverterExt.UCNV_EXT_TO_U_MAKE_WORD((byte)byt, 0) & 0xFFFFFFFFL;
        long word = word0 | 0xFFFFFFL;
        start = 0;
        limit = length;
        while ((i = limit - start) > 1) {
            if (i <= 4) {
                if (word0 <= ((long)toUSection.get(toUSection.position() + start) & 0xFFFFFFFFL) || ++start < limit && word0 <= ((long)toUSection.get(toUSection.position() + start) & 0xFFFFFFFFL) || ++start < limit && word0 <= ((long)toUSection.get(toUSection.position() + start) & 0xFFFFFFFFL)) break;
                ++start;
                break;
            }
            i = (start + limit) / 2;
            if (word < ((long)toUSection.get(toUSection.position() + i) & 0xFFFFFFFFL)) {
                limit = i;
                continue;
            }
            start = i;
        }
        if (start < limit && byt == UConverterExt.UCNV_EXT_TO_U_GET_BYTE((int)(word = (long)toUSection.get(toUSection.position() + start) & 0xFFFFFFFFL))) {
            return UConverterExt.UCNV_EXT_TO_U_GET_VALUE((int)word);
        }
        return 0;
    }

    static boolean UCNV_EXT_TO_U_VERIFY_SISO_MATCH(byte sisoState, int match) {
        return sisoState < 0 || sisoState == 0 == (match == 1);
    }

    /*
     * WARNING - void declaration
     */
    static int ucnv_extMatchToU(ByteBuffer cx, byte sisoState, byte[] preArray, int preArrayBegin, int preLength, byte[] srcArray, int srcArrayBegin, int srcLength, int[] pMatchValue, boolean useFallback, boolean flush) {
        int matchLength;
        int matchValue;
        block14: {
            int value;
            int tmpint = cx.asIntBuffer().get(2);
            if (cx == null || cx.asIntBuffer().get(2) <= 0) {
                return 0;
            }
            IntBuffer toUTable = (IntBuffer)UConverterExt.UCNV_EXT_ARRAY(cx, 1, Integer.TYPE);
            int index = 0;
            matchValue = 0;
            matchLength = 0;
            int j = 0;
            int i = 0;
            if (sisoState == 0) {
                if (preLength > 1) {
                    return 0;
                }
                if (preLength == 1) {
                    srcLength = 0;
                } else if (srcLength > 1) {
                    srcLength = 1;
                }
                flush = true;
            }
            while (true) {
                void var20_21;
                short b;
                int oldpos = toUTable.position();
                IntBuffer toUSection = ((IntBuffer)toUTable.position(index)).slice();
                toUTable.position(oldpos);
                value = toUSection.get();
                int length = UConverterExt.UCNV_EXT_TO_U_GET_BYTE(value);
                value = UConverterExt.UCNV_EXT_TO_U_GET_VALUE(value);
                if (value != 0 && (UConverterExt.UCNV_EXT_TO_U_IS_ROUNDTRIP(value) || UConverter.TO_U_USE_FALLBACK(useFallback)) && UConverterExt.UCNV_EXT_TO_U_VERIFY_SISO_MATCH(sisoState, i + j)) {
                    matchValue = value;
                    matchLength = i + j;
                }
                if (i < preLength) {
                    b = (short)(preArray[preArrayBegin + i++] & 0xFF);
                } else {
                    if (j >= srcLength) {
                        if (!flush && (length = i + j) <= 31) {
                            return -length;
                        }
                        break block14;
                    }
                    b = (short)(srcArray[srcArrayBegin + j++] & 0xFF);
                }
                value = UConverterExt.ucnv_extFindToU(toUSection, length, (short)var20_21);
                if (value == 0) break block14;
                if (!UConverterExt.UCNV_EXT_TO_U_IS_PARTIAL(value)) break;
                index = UConverterExt.UCNV_EXT_TO_U_GET_PARTIAL_INDEX(value);
            }
            if ((UConverterExt.UCNV_EXT_TO_U_IS_ROUNDTRIP(value) || UConverter.TO_U_USE_FALLBACK(useFallback)) && UConverterExt.UCNV_EXT_TO_U_VERIFY_SISO_MATCH(sisoState, i + j)) {
                matchValue = value;
                matchLength = i + j;
            }
        }
        if (matchLength == 0) {
            return 0;
        }
        pMatchValue[0] = UConverterExt.UCNV_EXT_TO_U_MASK_ROUNDTRIP(matchValue);
        return matchLength;
    }

    static void ucnv_extWriteToU(UConverter cnv, ByteBuffer cx, int value, char[] targetArray, int[] targetArrayBegin, int targetLimit, int[] offsetsArray, int[] offsetsArrayBegin, int srcIndex, int[] pErrorCode) {
        if (UConverterExt.UCNV_EXT_TO_U_IS_CODE_POINT(value)) {
            cnv.ucnv_toUWriteCodePoint(UConverterExt.UCNV_EXT_TO_U_GET_CODE_POINT(value), targetArray, targetArrayBegin, targetLimit, offsetsArray, offsetsArrayBegin, srcIndex, pErrorCode);
        } else {
            char[] a = new char[UConverterExt.UCNV_EXT_TO_U_GET_LENGTH(value)];
            CharBuffer cb = (CharBuffer)UConverterExt.UCNV_EXT_ARRAY(cx, 3, Character.TYPE);
            cb.position(UConverterExt.UCNV_EXT_TO_U_GET_INDEX(value));
            cb.get(a, 0, a.length);
            UConverter.ucnv_toUWriteUChars(cnv, a, 0, a.length, targetArray, targetArrayBegin, targetLimit, offsetsArray, offsetsArrayBegin, srcIndex, pErrorCode);
        }
    }

    static int UCNV_SISO_STATE(UConverter cnv) {
        return cnv.sharedData.mbcs.outputType == 12 ? (byte)cnv.mode : (cnv.sharedData.mbcs.outputType == 219 ? (byte)1 : (byte)-1);
    }

    public static boolean ucnv_extInitialMatchToU(UConverter cnv, ByteBuffer cx, int firstLength, byte[] srcArray, int[] srcArrayBegin, int srcLimit, char[] targetArray, int[] targetArrayBegin, int targetLimit, int[] offsetsArray, int[] offsetsArrayBegin, int srcIndex, boolean flush, int[] pErrorCode) {
        int[] value = new int[1];
        int match = 0;
        match = UConverterExt.ucnv_extMatchToU(cx, (byte)UConverterExt.UCNV_SISO_STATE(cnv), cnv.toUBytesArray, cnv.toUBytesBegin, firstLength, srcArray, srcArrayBegin[0], srcLimit - srcArrayBegin[0], value, cnv.useFallback, flush);
        if (match > 0) {
            srcArrayBegin[0] = srcArrayBegin[0] + (match - firstLength);
            UConverterExt.ucnv_extWriteToU(cnv, cx, value[0], targetArray, targetArrayBegin, targetLimit, offsetsArray, offsetsArrayBegin, srcIndex, pErrorCode);
            return true;
        }
        if (match < 0) {
            int j;
            byte[] sArray = cnv.toUBytesArray;
            int sArrayIndex = cnv.toUBytesBegin;
            cnv.preToUFirstLength = (byte)firstLength;
            for (j = 0; j < firstLength; ++j) {
                cnv.preToUArray[j] = sArray[sArrayIndex++];
            }
            sArray = srcArray;
            sArrayIndex = srcArrayBegin[0];
            match = -match;
            while (j < match) {
                cnv.preToUArray[j] = sArray[sArrayIndex++];
                ++j;
            }
            srcArray = sArray;
            srcArrayBegin[0] = sArrayIndex;
            cnv.preToULength = (byte)match;
            return true;
        }
        return false;
    }

    public static final int ucnv_extSimpleMatchToU(ByteBuffer cx, byte[] sourceArray, int sourceArrayBegin, int length, boolean useFallback) {
        int[] value = new int[1];
        if (length <= 0) {
            return 65535;
        }
        int match = UConverterExt.ucnv_extMatchToU(cx, (byte)-1, sourceArray, sourceArrayBegin, length, null, 0, 0, value, useFallback, true);
        if (match == length && UConverterExt.UCNV_EXT_TO_U_IS_CODE_POINT(value[0])) {
            return UConverterExt.UCNV_EXT_TO_U_GET_CODE_POINT(value[0]);
        }
        return 65534;
    }

    public static void ucnv_extContinueMatchToU(UConverter cnv, UConverterToUnicodeArgs pArgs, int srcIndex, int[] pErrorCode) {
        int[] value = new int[1];
        int match = UConverterExt.ucnv_extMatchToU(cnv.sharedData.mbcs.extIndexes, (byte)UConverterExt.UCNV_SISO_STATE(cnv), cnv.preToUArray, cnv.preToUBegin, cnv.preToULength, pArgs.sourceArray, pArgs.sourceBegin, pArgs.sourceLimit - pArgs.sourceBegin, value, cnv.useFallback, pArgs.flush);
        if (match > 0) {
            if (match >= cnv.preToULength) {
                pArgs.sourceBegin += match - cnv.preToULength;
                cnv.preToULength = 0;
            } else {
                int length = cnv.preToULength - match;
                UConverterUtility.uprv_memmove(cnv.preToUArray, cnv.preToUBegin, cnv.preToUArray, cnv.preToUBegin + match, length);
                cnv.preToULength = (byte)(-length);
            }
            int[] offsetsBegin = new int[]{pArgs.offsetsBegin};
            int[] targetBegin = new int[]{pArgs.targetBegin};
            UConverterExt.ucnv_extWriteToU(cnv, cnv.sharedData.mbcs.extIndexes, value[0], pArgs.targetArray, targetBegin, pArgs.targetLimit, pArgs.offsetsArray, offsetsBegin, srcIndex, pErrorCode);
            pArgs.targetBegin = targetBegin[0];
            pArgs.offsetsBegin = offsetsBegin[0];
        } else if (match < 0) {
            byte[] sArray = pArgs.sourceArray;
            int sArrayIndex = pArgs.sourceBegin;
            match = -match;
            for (int j = cnv.preToULength; j < match; ++j) {
                cnv.preToUArray[j] = sArray[sArrayIndex++];
            }
            pArgs.sourceBegin = sArrayIndex;
            cnv.preToULength = (byte)match;
        } else {
            UConverterUtility.uprv_memcpy(cnv.toUBytesArray, cnv.toUBytesBegin, cnv.preToUArray, cnv.preToUBegin, (int)cnv.preToUFirstLength);
            cnv.toULength = cnv.preToUFirstLength;
            int length = cnv.preToULength - cnv.preToUFirstLength;
            if (length > 0) {
                UConverterUtility.uprv_memmove(cnv.preToUArray, cnv.preToUBegin, cnv.preToUArray, cnv.preToUBegin + cnv.preToUFirstLength, length);
            }
            cnv.preToULength = (byte)(-length);
            pErrorCode[0] = 10;
        }
    }

    static int ucnv_extFindFromU(CharBuffer fromUSection, int length, char u) {
        int i;
        int start = 0;
        int limit = length;
        while ((i = limit - start) > 1) {
            if (i <= 4) {
                if (u <= fromUSection.get(fromUSection.position() + start) || ++start < limit && u <= fromUSection.get(fromUSection.position() + start) || ++start < limit && u <= fromUSection.get(fromUSection.position() + start)) break;
                ++start;
                break;
            }
            i = (start + limit) / 2;
            if (u < fromUSection.get(fromUSection.position() + i)) {
                limit = i;
                continue;
            }
            start = i;
        }
        if (start < limit && u == fromUSection.get(fromUSection.position() + start)) {
            return start;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    static int ucnv_extMatchFromU(ByteBuffer cx, int firstCP, char[] preArray, int preArrayBegin, int preLength, char[] srcArray, int srcArrayBegin, int srcLength, int[] pMatchValue, boolean useFallback, boolean flush) {
        void var24_19;
        void var19_18;
        int matchLength;
        int matchValue;
        if (cx == null) {
            return 0;
        }
        int index = firstCP >>> 10;
        if (index >= cx.asIntBuffer().get(11)) {
            return 0;
        }
        CharBuffer stage12 = (CharBuffer)UConverterExt.UCNV_EXT_ARRAY(cx, 10, Character.TYPE);
        CharBuffer stage3 = (CharBuffer)UConverterExt.UCNV_EXT_ARRAY(cx, 13, Character.TYPE);
        index = UConverterExt.UCNV_EXT_FROM_U(stage12, stage3, index, firstCP);
        IntBuffer stage3b = (IntBuffer)UConverterExt.UCNV_EXT_ARRAY(cx, 15, Integer.TYPE);
        int value = stage3b.get(stage3b.position() + index);
        if (value == 0) {
            return 0;
        }
        if (UConverterExt.UCNV_EXT_TO_U_IS_PARTIAL(value)) {
            block17: {
                index = UConverterExt.UCNV_EXT_FROM_U_GET_PARTIAL_INDEX(value);
                CharBuffer fromUTableUChars = (CharBuffer)UConverterExt.UCNV_EXT_ARRAY(cx, 5, Character.TYPE);
                IntBuffer fromUTableValues = (IntBuffer)UConverterExt.UCNV_EXT_ARRAY(cx, 6, Integer.TYPE);
                matchValue = 0;
                matchLength = 0;
                int j = 0;
                int i = 0;
                while (true) {
                    void var25_25;
                    char c;
                    int oldpos = fromUTableUChars.position();
                    CharBuffer fromUSectionUChars = ((CharBuffer)fromUTableUChars.position(index)).slice();
                    fromUTableUChars.position(oldpos);
                    oldpos = fromUTableValues.position();
                    IntBuffer fromUSectionValues = ((IntBuffer)fromUTableValues.position(index)).slice();
                    fromUTableValues.position(oldpos);
                    int length = fromUSectionUChars.get();
                    value = fromUSectionValues.get();
                    if (value != 0 && (UConverterExt.UCNV_EXT_FROM_U_IS_ROUNDTRIP(value) || UConverter.FROM_U_USE_FALLBACK(useFallback, firstCP))) {
                        matchValue = value;
                        matchLength = 2 + i + j;
                    }
                    if (i < preLength) {
                        c = preArray[preArrayBegin + i++];
                    } else {
                        if (j >= srcLength) {
                            if (!flush && (length = i + j) <= 19) {
                                return -(2 + length);
                            }
                            break block17;
                        }
                        c = srcArray[srcArrayBegin + j++];
                    }
                    index = UConverterExt.ucnv_extFindFromU(fromUSectionUChars, length, (char)var25_25);
                    if (index < 0) break block17;
                    value = fromUSectionValues.get(fromUSectionValues.position() + index);
                    if (!UConverterExt.UCNV_EXT_FROM_U_IS_PARTIAL(value)) break;
                    index = UConverterExt.UCNV_EXT_FROM_U_GET_PARTIAL_INDEX(value);
                }
                if (UConverterExt.UCNV_EXT_FROM_U_IS_ROUNDTRIP(value) || UConverter.FROM_U_USE_FALLBACK(useFallback, firstCP)) {
                    matchValue = value;
                    matchLength = 2 + i + j;
                }
            }
            if (matchLength == 0) {
                return 0;
            }
        } else if (UConverterExt.UCNV_EXT_FROM_U_IS_ROUNDTRIP(value) || UConverter.FROM_U_USE_FALLBACK(useFallback, firstCP)) {
            matchValue = value;
            matchLength = 2;
        } else {
            return 0;
        }
        if ((var19_18 & 0x60000000) != 0) {
            return 0;
        }
        if (var19_18 == -2147483647) {
            return 1;
        }
        pMatchValue[0] = UConverterExt.UCNV_EXT_FROM_U_MASK_ROUNDTRIP((int)var19_18);
        return (int)var24_19;
    }

    static void ucnv_extWriteFromU(UConverter cnv, ByteBuffer cx, int value, byte[] targetArray, int[] targetArrayBegin, int targetLimit, int[] offsetsArray, int[] offsetsArrayBegin, int srcIndex, int[] pErrorCode) {
        int resultArrayIndex;
        byte[] resultArray;
        byte[] bufferArray = new byte[32];
        int bufferArrayIndex = 0;
        int length = UConverterExt.UCNV_EXT_FROM_U_GET_LENGTH(value);
        value = UConverterExt.UCNV_EXT_FROM_U_GET_DATA(value);
        if (length <= 3) {
            int p = bufferArrayIndex + 1;
            switch (length) {
                case 3: {
                    bufferArray[p++] = (byte)(value >>> 16);
                }
                case 2: {
                    bufferArray[p++] = (byte)(value >>> 8);
                }
                case 1: {
                    bufferArray[p++] = (byte)value;
                }
            }
            resultArray = bufferArray;
            resultArrayIndex = bufferArrayIndex + 1;
        } else {
            byte[] slice = new byte[length];
            ByteBuffer bb = (ByteBuffer)UConverterExt.UCNV_EXT_ARRAY(cx, 8, Byte.TYPE);
            bb.position(value);
            bb.get(slice, 0, slice.length);
            resultArray = slice;
            resultArrayIndex = 0;
        }
        int prevLength = (int)cnv.fromUnicodeStatus;
        if (prevLength != 0) {
            int shiftByte;
            if (prevLength > 1 && length == 1) {
                shiftByte = 15;
                cnv.fromUnicodeStatus = 1L;
            } else if (prevLength == 1 && length > 1) {
                shiftByte = 14;
                cnv.fromUnicodeStatus = 2L;
            } else {
                shiftByte = 0;
            }
            if (shiftByte != 0) {
                bufferArray[0] = shiftByte;
                if (resultArray != bufferArray || resultArrayIndex != bufferArrayIndex + 1) {
                    UConverterUtility.uprv_memcpy(bufferArray, bufferArrayIndex + 1, resultArray, resultArrayIndex, length);
                }
                resultArray = bufferArray;
                resultArrayIndex = bufferArrayIndex;
                ++length;
            }
        }
        UConverter.ucnv_fromUWriteBytes(cnv, resultArray, resultArrayIndex, length, targetArray, targetArrayBegin, targetLimit, offsetsArray, offsetsArrayBegin, srcIndex, pErrorCode);
    }

    public static boolean ucnv_extInitialMatchFromU(UConverter cnv, ByteBuffer cx, int cp, char[] srcArray, int[] srcArrayBegin, int srcLimit, byte[] targetArray, int[] targetArrayBegin, int targetLimit, int[] offsetsArray, int[] offsetsArrayBegin, int srcIndex, boolean flush, int[] pErrorCode) {
        int[] value = new int[1];
        int match = UConverterExt.ucnv_extMatchFromU(cx, cp, null, 0, 0, srcArray, srcArrayBegin[0], srcLimit - srcArrayBegin[0], value, cnv.useFallback, flush);
        if (match >= 2 && (UConverterExt.UCNV_EXT_FROM_U_GET_LENGTH(value[0]) != 1 || cnv.sharedData.mbcs.outputType != 219)) {
            srcArrayBegin[0] = srcArrayBegin[0] + (match - 2);
            UConverterExt.ucnv_extWriteFromU(cnv, cx, value[0], targetArray, targetArrayBegin, targetLimit, offsetsArray, offsetsArrayBegin, srcIndex, pErrorCode);
            return true;
        }
        if (match < 0) {
            cnv.preFromUFirstCP = cp;
            char[] sArray = srcArray;
            int sArrayIndex = srcArrayBegin[0];
            match = -match - 2;
            for (int j = 0; j < match; ++j) {
                cnv.preFromUArray[j] = sArray[sArrayIndex++];
            }
            srcArrayBegin[0] = sArrayIndex;
            cnv.preFromULength = (byte)match;
            return true;
        }
        if (match == 1) {
            cnv.useSubChar1 = true;
            return false;
        }
        return false;
    }

    int ucnv_extSimpleMatchFromU(ByteBuffer cx, int cp, int[] pValue, boolean useFallback) {
        int[] value = new int[1];
        int match = UConverterExt.ucnv_extMatchFromU(cx, cp, null, 0, 0, null, 0, 0, value, useFallback, true);
        if (match >= 2) {
            int length = UConverterExt.UCNV_EXT_FROM_U_GET_LENGTH(value[0]);
            value[0] = UConverterExt.UCNV_EXT_FROM_U_GET_DATA(value[0]);
            if (length <= 3) {
                pValue[0] = value[0];
                return length;
            }
        }
        return 0;
    }

    public static void ucnv_extContinueMatchFromU(UConverter cnv, UConverterFromUnicodeArgs pArgs, int srcIndex, int[] pErrorCode) {
        int[] value = new int[1];
        int match = UConverterExt.ucnv_extMatchFromU(cnv.sharedData.mbcs.extIndexes, cnv.preFromUFirstCP, cnv.preFromUArray, cnv.preFromUBegin, cnv.preFromULength, pArgs.sourceArray, pArgs.sourceBegin, pArgs.sourceLimit - pArgs.sourceBegin, value, cnv.useFallback, pArgs.flush);
        if (match >= 2) {
            if ((match -= 2) >= cnv.preFromULength) {
                pArgs.sourceBegin += match - cnv.preFromULength;
                cnv.preFromULength = 0;
            } else {
                int length = cnv.preFromULength - match;
                UConverterUtility.uprv_memmove(cnv.preFromUArray, cnv.preFromUBegin, cnv.preFromUArray, cnv.preFromUBegin + match, length);
                cnv.preFromULength = (byte)(-length);
            }
            cnv.preFromUFirstCP = -1;
            int[] targetBegin = new int[]{pArgs.targetBegin};
            int[] offsetsBegin = new int[]{pArgs.offsetsBegin};
            UConverterExt.ucnv_extWriteFromU(cnv, cnv.sharedData.mbcs.extIndexes, value[0], pArgs.targetArray, targetBegin, pArgs.targetLimit, pArgs.offsetsArray, offsetsBegin, srcIndex, pErrorCode);
            pArgs.targetBegin = targetBegin[0];
            pArgs.offsetsBegin = offsetsBegin[0];
        } else if (match < 0) {
            char[] sArray = pArgs.sourceArray;
            int sArrayIndex = pArgs.sourceBegin;
            match = -match - 2;
            for (int j = cnv.preFromULength; j < match; ++j) {
                cnv.preFromUArray[j] = sArray[sArrayIndex++];
            }
            pArgs.sourceArray = sArray;
            pArgs.sourceBegin = sArrayIndex;
            cnv.preFromULength = (byte)match;
        } else {
            if (match == 1) {
                cnv.useSubChar1 = true;
            }
            cnv.fromUChar32 = cnv.preFromUFirstCP;
            cnv.preFromUFirstCP = -1;
            cnv.preFromULength = -cnv.preFromULength;
            pErrorCode[0] = 10;
        }
    }
}

