/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.impl;

import com.adobe.agl.impl.CharTrie;
import com.adobe.agl.impl.ICUBinary;
import com.adobe.agl.impl.UCharacterProperty;
import com.adobe.agl.util.VersionInfo;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

final class UCharacterPropertyReader
implements ICUBinary.Authenticate {
    private static final int INDEX_SIZE_ = 16;
    private DataInputStream m_dataInputStream_;
    private int m_propertyOffset_;
    private int m_exceptionOffset_;
    private int m_caseOffset_;
    private int m_additionalOffset_;
    private int m_additionalVectorsOffset_;
    private int m_additionalColumnsCount_;
    private int m_reservedOffset_;
    private byte[] m_unicodeVersion_;
    private static final byte[] DATA_FORMAT_ID_ = new byte[]{85, 80, 114, 111};
    private static final byte[] DATA_FORMAT_VERSION_ = new byte[]{3, 1, 5, 2};

    public boolean isDataVersionAcceptable(byte[] version) {
        return version[0] == DATA_FORMAT_VERSION_[0] && version[2] == DATA_FORMAT_VERSION_[2] && version[3] == DATA_FORMAT_VERSION_[3];
    }

    protected UCharacterPropertyReader(InputStream inputStream) throws IOException {
        this.m_unicodeVersion_ = ICUBinary.readHeader(inputStream, DATA_FORMAT_ID_, this);
        this.m_dataInputStream_ = new DataInputStream(inputStream);
    }

    protected void read(UCharacterProperty ucharppty) throws IOException {
        int i;
        int count = 16;
        this.m_propertyOffset_ = this.m_dataInputStream_.readInt();
        --count;
        this.m_exceptionOffset_ = this.m_dataInputStream_.readInt();
        --count;
        this.m_caseOffset_ = this.m_dataInputStream_.readInt();
        --count;
        this.m_additionalOffset_ = this.m_dataInputStream_.readInt();
        --count;
        this.m_additionalVectorsOffset_ = this.m_dataInputStream_.readInt();
        --count;
        this.m_additionalColumnsCount_ = this.m_dataInputStream_.readInt();
        --count;
        this.m_reservedOffset_ = this.m_dataInputStream_.readInt();
        --count;
        this.m_dataInputStream_.skipBytes(12);
        count -= 3;
        ucharppty.m_maxBlockScriptValue_ = this.m_dataInputStream_.readInt();
        --count;
        ucharppty.m_maxJTGValue_ = this.m_dataInputStream_.readInt();
        this.m_dataInputStream_.skipBytes(--count << 2);
        ucharppty.m_trie_ = new CharTrie(this.m_dataInputStream_, ucharppty);
        int size = this.m_exceptionOffset_ - this.m_propertyOffset_;
        ucharppty.m_property_ = new int[size];
        for (i = 0; i < size; ++i) {
            ucharppty.m_property_[i] = this.m_dataInputStream_.readInt();
        }
        size = this.m_caseOffset_ - this.m_exceptionOffset_;
        ucharppty.m_exception_ = new int[size];
        for (i = 0; i < size; ++i) {
            ucharppty.m_exception_[i] = this.m_dataInputStream_.readInt();
        }
        size = this.m_additionalOffset_ - this.m_caseOffset_ << 1;
        ucharppty.m_case_ = new char[size];
        for (i = 0; i < size; ++i) {
            ucharppty.m_case_[i] = this.m_dataInputStream_.readChar();
        }
        ucharppty.m_additionalTrie_ = new CharTrie(this.m_dataInputStream_, ucharppty);
        size = this.m_reservedOffset_ - this.m_additionalVectorsOffset_;
        ucharppty.m_additionalVectors_ = new int[size];
        for (i = 0; i < size; ++i) {
            ucharppty.m_additionalVectors_[i] = this.m_dataInputStream_.readInt();
        }
        this.m_dataInputStream_.close();
        ucharppty.m_additionalColumnsCount_ = this.m_additionalColumnsCount_;
        ucharppty.m_unicodeVersion_ = VersionInfo.getInstance(this.m_unicodeVersion_[0], this.m_unicodeVersion_[1], this.m_unicodeVersion_[2], this.m_unicodeVersion_[3]);
    }
}

