/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.wrappers;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ATGHttpServletRequest
extends HttpServletRequestWrapper {
    private static HeaderDateFormat dateFormat = new HeaderDateFormat("EE, dd MMM yyyy HH:mm:ss z");

    public ATGHttpServletRequest(HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
    }

    public Map getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration enumer = this.getParameterNames();
        while (enumer.hasMoreElements()) {
            String str = (String)enumer.nextElement();
            map.put(str, this.getParameterValues(str));
        }
        return map;
    }

    public long getDateHeader(String header) {
        return dateFormat.parseDate(this.getHeader(header));
    }

    static final class HeaderDateFormat {
        public static final String HTTP_FORMAT = "EE, dd MMM yyyy HH:mm:ss z";
        public static final String COOKIE_FORMAT = "EEE, dd-MMM-yyyy HH:mm:ss z";
        private static final int CAPACITY = 8;
        private final SimpleDateFormat formatter;
        private final String[] lastDate;
        private final Date date;
        private final FieldPosition pos;
        private final long[] lastTime;
        private final int length;

        HeaderDateFormat(String format) {
            this.formatter = new SimpleDateFormat(format, Locale.US);
            this.length = 2 * format.length();
            this.formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.date = new Date();
            this.pos = new FieldPosition(0);
            this.lastDate = new String[8];
            this.lastTime = new long[8];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String formatDate(long time) {
            long qtime = time / 1000L;
            int i = (int)(qtime & 7L);
            SimpleDateFormat simpleDateFormat = this.formatter;
            synchronized (simpleDateFormat) {
                if (qtime == this.lastTime[i]) {
                    return this.lastDate[i];
                }
                this.lastTime[i] = qtime;
                this.date.setTime(time);
                this.lastDate[i] = this.formatter.format(this.date, new StringBuffer(this.length), this.pos).toString();
                return this.lastDate[i];
            }
        }

        public long parseDate(String text) {
            if (text == null) {
                return -1L;
            }
            SimpleDateFormat simpleDateFormat = this.formatter;
            synchronized (simpleDateFormat) {
                try {
                    return this.formatter.parse(text).getTime();
                }
                catch (ParseException ex) {
                    throw new IllegalArgumentException(ex.getMessage());
                }
            }
        }
    }
}

