import com.we_lab_doc.spacecard.model.*
import com.we_lab_doc.spacecard.utils.*
import net.sf.json.*

class DataTrayTests extends SpaceCardModelTestCase {
	void testBeanPutGet() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)
		def jd = UserDataTray.create(sv, 'bean', "1.0")
		def a= new A()
		a.a = "hoge"
		a.b = 1
		jd.put(a)
		assertTrue "1", ModelUtils.flush(jd)
		assertTrue "2", jd.objClass == a.class.name
		assertTrue "3", jd.type == DataTray.BeanTYPE
	}
	void testJSONObjectPutGet() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)
		def jsonObj = new JSONObject()
		def jd = UserDataTray.create(sv, 'jsonObj', "1.0")
		jd.put(jsonObj)
		assertTrue "1", ModelUtils.flush(jd)
		assertTrue "2", jd.objClass == JSONObject.class.name
		assertTrue "3", jd.type == DataTray.JSONObjectTYPE		
	}
	void testJSONArrayPutGet() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)		
		def jsonAry = new JSONArray()
		def jd = UserDataTray.create(sv,  'jsonArray', "1.0")
		jd.put(jsonAry)
		assertTrue "1", ModelUtils.flush(jd)
		assertTrue "2", jd.objClass == JSONArray.class.name
		assertTrue "3", jd.type == DataTray.JSONArrayTYPE		
	}
	void testListPutGet() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)		
		def list = new ArrayList()
		list.add(new String("hoge"))
		def jd = UserDataTray.create(sv,  'list', "1.0")		
		jd.put(list)
		assertTrue "1", ModelUtils.flush(jd)
		assertTrue "2", jd.objClass == String.class.name
		assertTrue "3", jd.type == DataTray.ListTYPE		
	}
	void testCollectionPutGet() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)		
		def col = new HashSet()
		col.add(new String("hoge"))
		def jd = UserDataTray.create(sv, 'col', "1.0")		
		jd.put(col)
		assertTrue "1", ModelUtils.flush(jd)
		assertTrue "2", jd.objClass == String.class.name
		assertTrue "3", jd.type == DataTray.CollectionTYPE		
	}
	void testObjArrayPutGet() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)
		def objArray = ["hoge", "hoge"] as String[]
		def jd = UserDataTray.create(sv, 'objArray', "1.0")		
		jd.put(objArray)
		assertTrue "1", ModelUtils.flush(jd)
		assertTrue "2", jd.objClass == String.class.name
		assertTrue "3", jd.type == DataTray.ArrayTYPE		
	}	
	
}

class A {
	String a
	int    b
}