/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.semantics;

import macromedia.asc.semantics.Builder;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.util.Context;

public class TypeInfo {
    private boolean is_nullable;
    private boolean is_default;
    private boolean annotate_names = false;
    private TypeValue type;
    private ObjectValue prototype;
    private QName name;

    public TypeInfo(TypeValue typeValue) {
        this.type = typeValue;
        this.is_nullable = true;
    }

    public TypeInfo(TypeValue typeValue, boolean bl, boolean bl2) {
        this.type = typeValue;
        this.is_nullable = bl;
        this.is_default = bl2;
        if (typeValue != null) {
            this.prototype = typeValue.prototype;
        }
    }

    public void clearInstance() {
        this.prototype = null;
        this.name = null;
    }

    public boolean isNullable() {
        return this.is_nullable;
    }

    public TypeValue getTypeValue() {
        return this.type;
    }

    public void setIsNullable(boolean bl) {
        this.is_nullable = bl;
    }

    public int getTypeId() {
        return this.type.getTypeId();
    }

    public boolean includes(Context context, TypeInfo typeInfo) {
        boolean bl = false;
        bl = context.dialect(11) && !this.is_nullable && typeInfo.is_nullable ? false : this.type.includes(context, typeInfo.type);
        return bl;
    }

    public QName getName() {
        if (this.name == null) {
            this.name = this.type.name;
        }
        return this.name;
    }

    public QName getName(Context context) {
        if (this.name == null) {
            this.name = this.type.name;
            if (context.dialect(11) && !this.is_default) {
                this.name = new QName(this.name.ns, this.name.name + (this.is_nullable ? "?" : "!"));
            }
        }
        return this.name;
    }

    public Builder getBuilder() {
        return this.type.builder;
    }

    public ObjectValue getPrototype() {
        if (this.prototype == null) {
            this.prototype = this.type != null ? this.type.prototype : null;
        }
        return this.prototype;
    }

    public boolean isInterface() {
        return this.type.isInterface();
    }

    public void setPrototype(ObjectValue objectValue) {
        this.prototype = objectValue;
    }
}

