/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.AWTPolylineProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PointsHandler;
import org.apache.batik.parser.PointsParser;
import org.w3c.dom.Element;
import org.w3c.dom.events.MutationEvent;

public class SVGPolylineElementBridge
extends SVGDecoratedShapeElementBridge {
    protected static final Shape DEFAULT_SHAPE = new GeneralPath();

    public String getLocalName() {
        return "polyline";
    }

    public Bridge getInstance() {
        return new SVGPolylineElementBridge();
    }

    protected void buildShape(BridgeContext ctx, Element e, ShapeNode shapeNode) {
        String s = e.getAttributeNS(null, "points");
        if (s.length() != 0) {
            AWTPolylineProducer app = new AWTPolylineProducer();
            app.setWindingRule(CSSUtilities.convertFillRule(e));
            try {
                PointsParser pp = new PointsParser();
                pp.setPointsHandler((PointsHandler)app);
                pp.parse(s);
            }
            catch (ParseException ex) {
                BridgeException bex = new BridgeException(e, "attribute.malformed", new Object[]{"points"});
                bex.setGraphicsNode((GraphicsNode)shapeNode);
                throw bex;
            }
            finally {
                shapeNode.setShape(app.getShape());
            }
        }
    }

    public void handleDOMAttrModifiedEvent(MutationEvent evt) {
        String attrName = evt.getAttrName();
        if (attrName.equals("points")) {
            if (evt.getNewValue().length() == 0) {
                ((ShapeNode)this.node).setShape(DEFAULT_SHAPE);
            } else {
                this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            }
            this.handleGeometryChanged();
        } else {
            super.handleDOMAttrModifiedEvent(evt);
        }
    }

    protected void handleCSSPropertyChanged(int property) {
        switch (property) {
            case 17: {
                this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
                this.handleGeometryChanged();
                break;
            }
            default: {
                super.handleCSSPropertyChanged(property);
            }
        }
    }
}

