/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.math;

import com.adobe.agl.text.DecimalFormat;

public final class F2Dot14 {
    public static final int ZERO = 0;
    public static final int ONE = 16384;
    public static final int ONE_SIXTEENTH = 1024;
    private static final DecimalFormat df = new DecimalFormat("0.###");

    private static int clamp(long l) {
        if (l > 32767L) {
            return Short.MAX_VALUE;
        }
        if (l < -32768L) {
            return Short.MIN_VALUE;
        }
        return (int)l;
    }

    public static int multiply(int n, int n2) {
        return F2Dot14.clamp(((long)n * (long)n2 >> 13) + 1L >> 1);
    }

    public static int square(int n) {
        return F2Dot14.multiply(n, n);
    }

    public static int fromDouble(double d) {
        return (int)(d * 16384.0);
    }

    public static double toDouble(int n) {
        return (double)n / 16384.0;
    }

    public static String toString(int n) {
        return df.format(F2Dot14.toDouble(n));
    }
}

