/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontException;
import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.FontFactory;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.pdffont.PDFSimpleFont;
import com.adobe.fontengine.font.type1.MetricFile;
import com.adobe.fontengine.font.type1.Type1Font;
import com.adobe.fontengine.fontmanagement.DirectoryWalker;
import com.adobe.fontengine.fontmanagement.MemoryFont;
import com.adobe.fontengine.fontmanagement.PDFSimpleFontValuesAccessor;
import com.adobe.fontengine.fontmanagement.StreamFont;
import com.adobe.fontengine.fontmanagement.URLFont;
import com.adobe.fontengine.fontmanagement.postscript.PSNameFontDatabase;
import com.adobe.fontengine.fontmanagement.postscript.PSNameResolver;
import com.adobe.fontengine.inlineformatting.css20.FamilyNameNormalizer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public final class FontLoader {
    private static final int kType1Font = 1;
    private static final int kOpenTypeFont = 2;
    private static final int kCFFFont = 3;
    private static final int kPFM = 4;
    private static final int kAFM = 5;
    private static final int maxBytesNeeded;
    private static final int t1BN;
    private static final int otBN;
    private static final int cffBN;
    private static final int afmBN;
    private static final int pfmBN;

    public static PSNameResolver getPSNameResolverInstance() {
        return new PSNameFontDatabase();
    }

    public static PSNameResolver getPSNameResolverInstance(FamilyNameNormalizer familyNameNormalizer) {
        return new PSNameFontDatabase(familyNameNormalizer);
    }

    public static PSNameResolver getPSNameResolverInstance(PSNameResolver pSNameResolver) {
        if (pSNameResolver instanceof PSNameFontDatabase) {
            return new PSNameFontDatabase((PSNameFontDatabase)pSNameResolver);
        }
        return null;
    }

    private static int determineFileType(FontInputStream fontInputStream) throws IOException {
        int n = -1;
        byte[] byArray = new byte[maxBytesNeeded];
        int n2 = fontInputStream.read(byArray);
        if (n2 >= otBN && FontFactory.isOpenType(byArray)) {
            n = 2;
        } else if (n2 >= t1BN && com.adobe.fontengine.font.type1.FontFactory.isType1(byArray)) {
            n = 1;
        } else if (n2 >= pfmBN && com.adobe.fontengine.font.type1.FontFactory.isPFM(byArray)) {
            n = 4;
        } else if (n2 >= afmBN && com.adobe.fontengine.font.type1.FontFactory.isAFM(byArray)) {
            n = 5;
        } else if (n2 >= cffBN && com.adobe.fontengine.font.cff.FontFactory.isCFF(byArray)) {
            n = 3;
        }
        if (n2 > 0) {
            fontInputStream.unread(byArray, 0, n2);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadFont(URL uRL, List list, List list2, List list3, boolean bl) throws IOException, InvalidFontException, UnsupportedFontException {
        FontInputStream fontInputStream = null;
        try {
            fontInputStream = new FontInputStream(uRL.openStream());
            switch (FontLoader.determineFileType(fontInputStream)) {
                case 1: {
                    Type1Font[] type1FontArray = com.adobe.fontengine.font.type1.FontFactory.load(fontInputStream, uRL);
                    if (type1FontArray.length != 1) {
                        return;
                    }
                    URLFont uRLFont = new URLFont(uRL, 0, type1FontArray[0]);
                    list.add(new T1AlignmentHolder(uRLFont, new FontNameAlignmentData(type1FontArray[0].getPostscriptName())));
                    if (bl) {
                        list3.add(type1FontArray[0]);
                        return;
                    }
                    list3.add(uRLFont);
                    return;
                }
                case 2: {
                    OpenTypeFont[] openTypeFontArray = FontFactory.load(fontInputStream);
                    int n = 0;
                    while (n < openTypeFontArray.length) {
                        if (bl) {
                            list3.add(openTypeFontArray[n]);
                        } else {
                            list3.add(new URLFont(uRL, n, openTypeFontArray[n]));
                        }
                        ++n;
                    }
                    return;
                }
                case 3: {
                    return;
                }
                case 4: {
                    MetricFile metricFile = com.adobe.fontengine.font.type1.FontFactory.loadPFM(fontInputStream, uRL);
                    if (metricFile == null) return;
                    list2.add(new MetricFileAlignmentHolder(uRL, new FontNameAlignmentData(metricFile.getFontName()), 4));
                    return;
                }
                case 5: {
                    MetricFile metricFile = com.adobe.fontengine.font.type1.FontFactory.loadAFM(fontInputStream, uRL);
                    if (metricFile == null) return;
                    list2.add(new MetricFileAlignmentHolder(uRL, new FontNameAlignmentData(metricFile.getFontName()), 5));
                    return;
                }
            }
            return;
        }
        finally {
            if (fontInputStream != null) {
                fontInputStream.close();
            }
        }
    }

    public Font[] load(URL uRL) throws FontLoadingException, InvalidFontException, UnsupportedFontException {
        try {
            FontInputStream fontInputStream = new FontInputStream(uRL.openStream());
            switch (FontLoader.determineFileType(fontInputStream)) {
                case 2: {
                    OpenTypeFont[] openTypeFontArray = FontFactory.load(fontInputStream);
                    Font[] fontArray = new Font[openTypeFontArray.length];
                    for (int i = 0; i < openTypeFontArray.length; ++i) {
                        fontArray[i] = new URLFont(uRL, i, openTypeFontArray[i]);
                    }
                    return fontArray;
                }
                case 1: {
                    Font[] fontArray = new Font[]{new URLFont(uRL, 0)};
                    return fontArray;
                }
            }
            return new Font[0];
        }
        catch (IOException iOException) {
            throw new FontLoadingException(iOException);
        }
    }

    public Font[] load(URL[] uRLArray, List list) {
        ArrayList arrayList;
        block8: {
            arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            for (int i = 0; i < uRLArray.length; ++i) {
                try {
                    FontLoader.loadFont(uRLArray[i], arrayList2, arrayList3, arrayList, false);
                    continue;
                }
                catch (InvalidFontException invalidFontException) {
                    if (list == null) continue;
                    list.add(invalidFontException);
                    continue;
                }
                catch (UnsupportedFontException unsupportedFontException) {
                    if (list == null) continue;
                    list.add(unsupportedFontException);
                    continue;
                }
                catch (IOException iOException) {
                    if (list == null) continue;
                    list.add(new FontLoadingException(iOException));
                }
            }
            try {
                FontLoader.alignMetricFilesWithOutlines(arrayList3, arrayList2);
            }
            catch (FontEngineException fontEngineException) {
                if (list == null) break block8;
                list.add(fontEngineException);
            }
        }
        if (arrayList.isEmpty()) {
            return new Font[0];
        }
        Font[] fontArray = new Font[arrayList.size()];
        arrayList.toArray(fontArray);
        return fontArray;
    }

    public Font[] load(URL[] uRLArray, List list, List list2) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        for (int i = 0; i < uRLArray.length; ++i) {
            try {
                FontLoader.loadFont(uRLArray[i], arrayList2, arrayList3, arrayList, false);
                continue;
            }
            catch (FontException fontException) {
                if (list != null) {
                    list.add(fontException);
                }
                if (list2 == null) continue;
                list2.add(uRLArray[i]);
                continue;
            }
            catch (IOException iOException) {
                if (list != null) {
                    list.add(new FontLoadingException(iOException));
                }
                if (list2 == null) continue;
                list2.add(uRLArray[i]);
            }
        }
        FontLoader.alignMetricFilesWithOutlines(arrayList3, arrayList2, list, list2);
        if (arrayList.isEmpty()) {
            return new Font[0];
        }
        Font[] fontArray = new Font[arrayList.size()];
        arrayList.toArray(fontArray);
        return fontArray;
    }

    public Font load(InputStream inputStream, int n, boolean bl) throws FontLoadingException {
        try {
            FontInputStream fontInputStream = new FontInputStream(inputStream);
            switch (FontLoader.determineFileType(fontInputStream)) {
                case 1: 
                case 2: 
                case 3: {
                    return new StreamFont(fontInputStream, n, bl);
                }
            }
            return null;
        }
        catch (IOException iOException) {
            throw new FontLoadingException(iOException);
        }
        catch (InvalidFontException invalidFontException) {
            throw new FontLoadingException(invalidFontException);
        }
        catch (UnsupportedFontException unsupportedFontException) {
            throw new FontLoadingException(unsupportedFontException);
        }
    }

    public Font[] load(File file, boolean bl, List list) {
        Font[] fontArray;
        ArrayList arrayList;
        block7: {
            File file2;
            DirectoryWalker directoryWalker = new DirectoryWalker(file, bl);
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            arrayList = new ArrayList();
            while ((file2 = directoryWalker.getNextFile()) != null) {
                try {
                    fontArray = file2.toURI().toURL();
                    FontLoader.loadFont((URL)fontArray, arrayList2, arrayList3, arrayList, false);
                }
                catch (FontEngineException fontEngineException) {
                    if (list == null) continue;
                    list.add(fontEngineException);
                }
                catch (IOException iOException) {
                    if (list == null) continue;
                    list.add(new FontLoadingException(iOException));
                }
            }
            try {
                FontLoader.alignMetricFilesWithOutlines(arrayList3, arrayList2);
            }
            catch (FontEngineException fontEngineException) {
                if (list == null) break block7;
                list.add(fontEngineException);
            }
        }
        if (arrayList.size() == 0) {
            return new URLFont[0];
        }
        fontArray = new URLFont[arrayList.size()];
        arrayList.toArray(fontArray);
        return fontArray;
    }

    public Font[] load(File file, boolean bl, List list, List list2) {
        Font[] fontArray;
        File file2;
        DirectoryWalker directoryWalker = new DirectoryWalker(file, bl);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        while ((file2 = directoryWalker.getNextFile()) != null) {
            fontArray = null;
            try {
                fontArray = file2.toURI().toURL();
                FontLoader.loadFont((URL)fontArray, arrayList, arrayList2, arrayList3, false);
            }
            catch (FontEngineException fontEngineException) {
                if (list != null) {
                    list.add(fontEngineException);
                }
                if (list2 == null) continue;
                list2.add(fontArray);
            }
            catch (IOException iOException) {
                if (list != null) {
                    list.add(new FontLoadingException(iOException));
                }
                if (list2 == null) continue;
                list2.add(fontArray);
            }
        }
        FontLoader.alignMetricFilesWithOutlines(arrayList2, arrayList, list, list2);
        if (arrayList3.size() == 0) {
            return new URLFont[0];
        }
        fontArray = new URLFont[arrayList3.size()];
        arrayList3.toArray(fontArray);
        return fontArray;
    }

    static FontData[] fromStream(FontInputStream fontInputStream, int n) throws IOException, InvalidFontException, UnsupportedFontException {
        switch (FontLoader.determineFileType(fontInputStream)) {
            case 2: {
                return FontFactory.load(fontInputStream);
            }
            case 3: {
                FontByteArray fontByteArray = new FontByteArray(fontInputStream, n);
                return com.adobe.fontengine.font.cff.FontFactory.load(fontByteArray);
            }
            case 1: {
                return com.adobe.fontengine.font.type1.FontFactory.load(fontInputStream, null);
            }
        }
        return new FontData[0];
    }

    private static void alignMetricFilesWithOutlines(List list, List list2) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        for (int i = 0; i < list.size(); ++i) {
            MetricFileAlignmentHolder metricFileAlignmentHolder = (MetricFileAlignmentHolder)list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                MetricFile metricFile;
                T1AlignmentHolder t1AlignmentHolder;
                block6: {
                    t1AlignmentHolder = (T1AlignmentHolder)list2.get(j);
                    if (!metricFileAlignmentHolder.data.dataAligns(t1AlignmentHolder.data)) continue;
                    try {
                        FontInputStream fontInputStream = new FontInputStream(metricFileAlignmentHolder.metricFileURL.openStream());
                        if (metricFileAlignmentHolder.metricFileType == 4) {
                            metricFile = com.adobe.fontengine.font.type1.FontFactory.loadPFM(fontInputStream, metricFileAlignmentHolder.metricFileURL);
                            break block6;
                        }
                        if (metricFileAlignmentHolder.metricFileType == 5) {
                            metricFile = com.adobe.fontengine.font.type1.FontFactory.loadAFM(fontInputStream, metricFileAlignmentHolder.metricFileURL);
                            break block6;
                        }
                        throw new FontLoadingException("unexpected metric file type");
                    }
                    catch (IOException iOException) {
                        throw new FontLoadingException(iOException);
                    }
                }
                t1AlignmentHolder.font.setMetricURL(metricFileAlignmentHolder.metricFileURL, metricFile);
            }
        }
    }

    private static void alignMetricFilesWithOutlines(List list, List list2, List list3, List list4) {
        for (int i = 0; i < list.size(); ++i) {
            MetricFileAlignmentHolder metricFileAlignmentHolder = (MetricFileAlignmentHolder)list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                T1AlignmentHolder t1AlignmentHolder = (T1AlignmentHolder)list2.get(j);
                if (!metricFileAlignmentHolder.data.dataAligns(t1AlignmentHolder.data)) continue;
                try {
                    MetricFile metricFile;
                    FontInputStream fontInputStream = new FontInputStream(metricFileAlignmentHolder.metricFileURL.openStream());
                    if (metricFileAlignmentHolder.metricFileType == 4) {
                        metricFile = com.adobe.fontengine.font.type1.FontFactory.loadPFM(fontInputStream, metricFileAlignmentHolder.metricFileURL);
                    } else if (metricFileAlignmentHolder.metricFileType == 5) {
                        metricFile = com.adobe.fontengine.font.type1.FontFactory.loadAFM(fontInputStream, metricFileAlignmentHolder.metricFileURL);
                    } else {
                        throw new FontLoadingException("unexpected metric file type");
                    }
                    t1AlignmentHolder.font.setMetricURL(metricFileAlignmentHolder.metricFileURL, metricFile);
                    continue;
                }
                catch (IOException iOException) {
                    if (list3 != null) {
                        list3.add(new FontLoadingException(iOException));
                    }
                    if (list4 == null) continue;
                    list4.add(t1AlignmentHolder.font.outlineFileURL);
                    continue;
                }
                catch (FontException fontException) {
                    if (list3 != null) {
                        list3.add(fontException);
                    }
                    if (list4 == null) continue;
                    list4.add(t1AlignmentHolder.font.outlineFileURL);
                }
            }
        }
    }

    static FontData[] fromURL(URL uRL, URL uRL2) throws InvalidFontException, UnsupportedFontException, FontLoadingException, IOException {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        FontLoader.loadFont(uRL, arrayList2, arrayList3, arrayList, true);
        if (uRL2 != null) {
            FontLoader.loadFont(uRL2, arrayList2, arrayList3, arrayList, true);
        }
        FontLoader.alignMetricFilesWithOutlines(arrayList3, arrayList2);
        if (arrayList.isEmpty()) {
            return new FontData[0];
        }
        FontData[] fontDataArray = new FontData[arrayList.size()];
        arrayList.toArray(fontDataArray);
        return fontDataArray;
    }

    public Font load(PDFSimpleFontValuesAccessor pDFSimpleFontValuesAccessor) throws InvalidFontException, UnsupportedFontException {
        return new MemoryFont(new PDFSimpleFont(pDFSimpleFontValuesAccessor));
    }

    static {
        t1BN = com.adobe.fontengine.font.type1.FontFactory.getNumBytesNeededToIdentify();
        otBN = FontFactory.getNumBytesNeededToIdentify();
        cffBN = com.adobe.fontengine.font.cff.FontFactory.getNumBytesNeededToIdentify();
        afmBN = com.adobe.fontengine.font.type1.FontFactory.getNumBytesNeededToIdentifyAFM();
        pfmBN = com.adobe.fontengine.font.type1.FontFactory.getNumBytesNeededToIdentifyPFM();
        int n = pfmBN;
        if (n < otBN) {
            n = otBN;
        }
        if (n < cffBN) {
            n = cffBN;
        }
        if (n < t1BN) {
            n = t1BN;
        }
        if (n < afmBN) {
            n = afmBN;
        }
        maxBytesNeeded = n;
    }

    private static class MetricFileAlignmentHolder {
        final URL metricFileURL;
        final MetricFileAlignmentData data;
        final int metricFileType;

        MetricFileAlignmentHolder(URL uRL, MetricFileAlignmentData metricFileAlignmentData, int n) {
            this.metricFileURL = uRL;
            this.data = metricFileAlignmentData;
            this.metricFileType = n;
        }
    }

    private static class T1AlignmentHolder {
        final URLFont font;
        final MetricFileAlignmentData data;

        T1AlignmentHolder(URLFont uRLFont, MetricFileAlignmentData metricFileAlignmentData) {
            this.font = uRLFont;
            this.data = metricFileAlignmentData;
        }
    }

    private static class FontNameAlignmentData
    implements MetricFileAlignmentData {
        private final String fontName;

        FontNameAlignmentData(String string) {
            this.fontName = string;
        }

        public boolean dataAligns(MetricFileAlignmentData metricFileAlignmentData) {
            return metricFileAlignmentData instanceof FontNameAlignmentData && ((FontNameAlignmentData)metricFileAlignmentData).fontName.equals(this.fontName);
        }
    }

    static interface MetricFileAlignmentData {
        public boolean dataAligns(MetricFileAlignmentData var1);
    }
}

