/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Gdef;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;

public abstract class LayoutTable
extends Table {
    protected LayoutTable(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        super(fontByteArray);
    }

    protected boolean lookupFlagCovers(int n, Gdef gdef, int n2) throws InvalidFontException {
        int n3;
        if (n2 == -1) {
            return false;
        }
        if ((n & 0xE) != 0) {
            if (gdef == null) {
                throw new InvalidFontException("lookupflag value requires a GDEF table, which is absent");
            }
            n3 = gdef.getGlyphClass(n2);
            if ((n & 2) != 0 && n3 == 1 || (n & 4) != 0 && n3 == 2 || (n & 8) != 0 && n3 == 3) {
                return true;
            }
        }
        if ((n & 0xFF00) != 0) {
            if (gdef == null) {
                throw new InvalidFontException("lookupflag value requires a GDEF table, which is absent");
            }
            if (gdef.getGlyphClass(n2) == 3 && (n & 0xFF00) >> 8 != (n3 = gdef.getMarkAttachClass(n2))) {
                return true;
            }
        }
        return false;
    }

    protected int getCoverageIndex(int n, int n2) throws InvalidFontException {
        if (n == -1) {
            return -1;
        }
        int n3 = this.data.getuint16(n2);
        switch (n3) {
            case 1: {
                int n4 = 0;
                int n5 = this.data.getuint16(n2 + 2) - 1;
                while (n4 <= n5) {
                    int n6 = (n4 + n5) / 2;
                    int n7 = this.data.getuint16(n2 + 4 + 2 * n6);
                    if (n < n7) {
                        n5 = n6 - 1;
                        continue;
                    }
                    if (n7 < n) {
                        n4 = n6 + 1;
                        continue;
                    }
                    return n6;
                }
                return -1;
            }
            case 2: {
                int n8 = 0;
                int n9 = this.data.getuint16(n2 + 2) - 1;
                while (n8 <= n9) {
                    int n10 = (n8 + n9) / 2;
                    int n11 = this.data.getuint16(n2 + 4 + 6 * n10);
                    int n12 = this.data.getuint16(n2 + 4 + 6 * n10 + 2);
                    if (n < n11) {
                        n9 = n10 - 1;
                        continue;
                    }
                    if (n12 < n) {
                        n8 = n10 + 1;
                        continue;
                    }
                    return this.data.getuint16(n2 + 4 + 6 * n10 + 4) + (n - n11);
                }
                return -1;
            }
        }
        throw new InvalidFontException("invalid coverage format (" + n3 + ")");
    }

    protected int getClassIndex(int n, int n2) throws InvalidFontException {
        if (n == -1) {
            return -1;
        }
        int n3 = this.data.getuint16(n2);
        switch (n3) {
            case 1: {
                int n4 = this.data.getuint16(n2 + 2);
                int n5 = this.data.getuint16(n2 + 4);
                if (n4 <= n && n < n4 + n5) {
                    return this.data.getuint16(n2 + 6 + (n - n4) * 2);
                }
                return 0;
            }
            case 2: {
                int n6 = this.data.getuint16(n2 + 2);
                int n7 = 0;
                int n8 = n6 - 1;
                while (n7 <= n8) {
                    int n9 = (n7 + n8) / 2;
                    int n10 = this.data.getuint16(n2 + 4 + n9 * 6);
                    int n11 = this.data.getuint16(n2 + 4 + n9 * 6 + 2);
                    if (n < n10) {
                        n8 = n9 - 1;
                        continue;
                    }
                    if (n11 < n) {
                        n7 = n9 + 1;
                        continue;
                    }
                    return this.data.getuint16(n2 + 4 + n9 * 6 + 4);
                }
                return 0;
            }
        }
        throw new InvalidFontException("invalid classdef format (" + n3 + ")");
    }
}

