/*
 * Decompiled with CFR 0.152.
 */
package flex.data.adapters;

import flex.data.ChangeObject;
import flex.data.DataService;
import flex.data.messages.DataErrorMessage;
import flex.data.messages.DataMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ChangeObjectImpl
implements ChangeObject {
    private static final long serialVersionUID = 3908346300899660363L;
    private Object objectId;
    private Object previousVersion;
    private Object currentVersion;
    private Object serverVersion;
    private String[] changes;
    private Map changedValues;
    private int operation;
    private transient DataMessage message;
    private int status;
    private String failureDescription;
    static final int STATUS_UNPROCESSED = 0;
    static final int STATUS_OK = 1;
    static final int STATUS_FAIL = 2;
    static final int STATUS_CONFLICT_OBJECT = 3;
    static final int STATUS_CONFLICT_PROPERTY = 4;

    public ChangeObjectImpl(DataMessage message) {
        this.operation = message.getOperation();
        this.message = message;
        this.status = 0;
    }

    public Object getObjectId() {
        return this.objectId;
    }

    public void setObjectId(Object id) {
        this.objectId = id;
    }

    public Object getPreviousVersion() {
        return this.previousVersion;
    }

    public void setPreviousVersion(Object o) {
        this.previousVersion = o;
    }

    public Object getNewVersion() {
        return this.currentVersion;
    }

    public void setNewVersion(Object o) {
        this.currentVersion = o;
        this.changedValues = null;
    }

    public boolean isCreate() {
        return this.operation == 0 || this.operation == 11;
    }

    public boolean isUpdate() {
        return this.operation == 3;
    }

    public boolean isDelete() {
        return this.operation == 4;
    }

    public void setChanges(Object[] changes) {
        if (changes != null && !(changes instanceof String[])) {
            String[] nchanges = new String[changes.length];
            for (int i = 0; i < changes.length; ++i) {
                nchanges[i] = (String)changes[i];
            }
            this.changes = nchanges;
        } else {
            this.changes = (String[])changes;
        }
        this.changedValues = null;
    }

    public Object[] getChanges() {
        return this.changes;
    }

    public String[] getChangedPropertyNames() {
        return this.changes;
    }

    public void addChangedPropertyName(String propertyName) {
        if (!this.isUpdate()) {
            throw new IllegalArgumentException("the addChangedPropertyName only is valid for update operations");
        }
        if (this.changes == null) {
            return;
        }
        for (int i = 0; i < this.changes.length; ++i) {
            if (!this.changes[i].equals(propertyName)) continue;
            return;
        }
        String[] nchanges = new String[this.changes.length + 1];
        for (int i = 0; i < this.changes.length; ++i) {
            nchanges[i] = this.changes[i];
        }
        nchanges[this.changes.length] = propertyName;
        this.changes = nchanges;
        this.changedValues = null;
        if (this.message != null) {
            DataService.setUpdateBody((DataMessage)this.message, (int)0, (Object)nchanges);
        }
    }

    public Map getChangedValues() {
        if (this.changedValues == null) {
            if (this.changes == null || this.currentVersion == null) {
                return null;
            }
            this.changedValues = new HashMap();
            for (int i = 0; i < this.changes.length; ++i) {
                String prop = this.changes[i];
                this.changedValues.put(prop, DataService.getPropertyOnClientObject((Object)this.currentVersion, (String)prop));
            }
        }
        return Collections.unmodifiableMap(this.changedValues);
    }

    public Object getPreviousValue(String propertyName) {
        return DataService.getPropertyOnClientObject((Object)this.previousVersion, (String)propertyName);
    }

    public DataMessage getMessage() {
        return this.message;
    }

    public void processed() {
        this.status = 1;
    }

    public void fail() {
        this.status = 2;
    }

    public void fail(String description) {
        this.fail();
        this.failureDescription = description;
    }

    public void conflict(Object serverVersion) {
        this.conflict(serverVersion, false);
    }

    public void conflict(Object serverVersion, boolean conflictOnProperty) {
        this.serverVersion = serverVersion;
        this.status = conflictOnProperty ? 4 : 3;
    }

    public ErrorMessage createErrorMessage() {
        ErrorMessage msg = null;
        if (this.status == 4 || this.status == 3) {
            DataErrorMessage dmsg = new DataErrorMessage();
            dmsg.cause = this.message;
            dmsg.faultString = this.failureDescription;
            dmsg.serverObject = this.serverVersion;
            List conflictingPropertyNames = this.getConflictingPropertyNames(this.serverVersion, this.status == 4);
            dmsg.propertyNames = conflictingPropertyNames.toArray();
            msg = dmsg;
        } else if (this.status == 0) {
            msg = new ErrorMessage();
            msg.faultString = "Not processed";
        } else if (this.status != 1) {
            msg = new ErrorMessage();
            msg.faultString = this.failureDescription;
        }
        msg.setCorrelationId(this.message.getMessageId());
        msg.setDestination(this.message.getDestination());
        return msg;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ChangeObject: ");
        sb.append("   operation=" + DataMessage.operationToString((int)this.operation));
        sb.append(StringUtils.NEWLINE);
        sb.append("   objectId=" + this.getObjectId());
        sb.append(StringUtils.NEWLINE);
        sb.append("   previousObject=" + this.getPreviousVersion());
        sb.append(StringUtils.NEWLINE);
        sb.append("   newVersion=" + this.getNewVersion());
        sb.append(StringUtils.NEWLINE);
        sb.append("   changedValues=" + this.getChangedValues());
        return sb.toString();
    }

    public List getConflictingPropertyNames(Object serverVersion, boolean checkOnlyChangingProps) {
        ArrayList<String> conflictingPropertyNames = new ArrayList<String>();
        if (checkOnlyChangingProps) {
            if (this.changes == null) {
                return conflictingPropertyNames;
            }
            if (serverVersion == null) {
                for (int i = 0; i < this.changes.length; ++i) {
                    conflictingPropertyNames.add(this.changes[i]);
                }
            } else {
                for (int i = 0; i < this.changes.length; ++i) {
                    String propName = this.changes[i];
                    Object clientOldValue = this.getPreviousValue(propName);
                    if (serverVersion == null) continue;
                    try {
                        Object serverValue = DataService.getPropertyOnClientObject((Object)serverVersion, (String)propName);
                        if ((clientOldValue != null || serverValue == null) && (clientOldValue == null || clientOldValue.equals(serverValue))) continue;
                        conflictingPropertyNames.add(propName);
                        continue;
                    }
                    catch (Exception e) {
                        conflictingPropertyNames.add(propName);
                    }
                }
            }
        } else if (serverVersion == null) {
            conflictingPropertyNames.addAll(this.getOldValuesCollection());
        } else {
            Iterator iter = this.getOldValuesCollection().iterator();
            while (iter.hasNext()) {
                String propName = (String)iter.next();
                Object clientOldValue = this.getPreviousValue(propName);
                try {
                    Object serverValue = DataService.getPropertyOnClientObject((Object)serverVersion, (String)propName);
                    if ((clientOldValue != null || serverValue == null) && (clientOldValue == null || clientOldValue.equals(serverValue))) continue;
                    conflictingPropertyNames.add(propName);
                }
                catch (Exception e) {
                    conflictingPropertyNames.add(propName);
                }
            }
        }
        return conflictingPropertyNames;
    }

    public void copyFrom(ChangeObjectImpl from) {
        this.setObjectId(from.getObjectId());
        this.setPreviousVersion(from.getPreviousVersion());
        this.setNewVersion(from.getNewVersion());
        this.setServerVersion(from.getServerVersion());
        this.setChanges(from.getChanges());
        this.setStatus(from.getStatus());
        this.setFailureDescription(from.getFailureDescription());
    }

    void setFailureDescription(String fd) {
        this.failureDescription = fd;
    }

    String getFailureDescription() {
        return this.failureDescription;
    }

    int getOperation() {
        return this.operation;
    }

    public Object getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(Object o) {
        this.serverVersion = o;
    }

    int getStatus() {
        return this.status;
    }

    void setStatus(int i) {
        this.status = i;
    }

    Collection getOldValuesCollection() {
        return DataService.getPropertiesOnClientObject((Object)this.previousVersion);
    }
}

