/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.SWFFontDescription;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontLoader;
import flash.fonts.CachedFontFace;
import flash.fonts.CachedFontManager;
import flash.fonts.FSType;
import flash.fonts.FontFace;
import flash.fonts.FontManager;
import flash.fonts.FontSet;
import flash.fonts.JREFontManager;
import flash.swf.builder.types.ShapeBuilder;
import flash.swf.builder.types.ShapeIterator;
import flash.swf.types.GlyphEntry;
import flash.swf.types.Shape;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;

public class AFEFontManager
extends CachedFontManager {
    FontLoader loader = new FontLoader();
    private JREFontManager jreManager;
    private Map initializeMap;

    public static URL processLocation(Object location) {
        if (location != null) {
            if (location instanceof URL) {
                return (URL)location;
            }
            File f = new File(location.toString());
            if (f.exists()) {
                try {
                    return f.toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public void initialize(Map map) {
        super.initialize(map);
        this.initializeMap = map;
    }

    public FontFace getEntryFromSystem(String familyName, int style, boolean useTwips) {
        FontManager manager = this.parent;
        if (manager == null) {
            if (this.jreManager == null) {
                this.jreManager = new JREFontManager();
                this.jreManager.initialize(this.initializeMap);
            }
            manager = this.jreManager;
        }
        return manager.getEntryFromSystem(familyName, style, useTwips);
    }

    protected FontSet createSetForSystemFont(String family, int style, boolean useTwips) {
        FontManager manager = this.parent;
        if (manager == null || !(manager instanceof CachedFontManager)) {
            if (this.jreManager == null) {
                this.jreManager = new JREFontManager();
            }
            manager = this.jreManager;
        }
        return ((CachedFontManager)manager).createSetForSystemFont(family, style, useTwips);
    }

    public FontFace getEntryFromLocation(URL location, int style, boolean useTwips) {
        FontFace entry = null;
        String locationKey = location != null ? location.toExternalForm() : null;
        Object fam = this.getFontFileCache().get((Object)locationKey);
        if (fam == null) {
            fam = this.createFontFromLocation(location, style, useTwips);
        }
        if (fam != null) {
            String family = fam.toString();
            FontSet fontSet = (FontSet)this.getFontCache().get((Object)family);
            if (fontSet != null) {
                entry = fontSet.get(style);
            }
            if (locationKey != null && !locationKey.toLowerCase().endsWith(".ttc")) {
                this.getFontFileCache().put((Object)locationKey, (Object)family);
            }
        } else if (this.parent != null) {
            return this.parent.getEntryFromLocation(location, style, useTwips);
        }
        return entry;
    }

    protected String createFontFromLocation(Object location, int requestedStyle, boolean useTwips) {
        String family = null;
        URL url = AFEFontManager.processLocation(location);
        if (url != null) {
            try {
                Font[] fonts = this.loader.load(url);
                if (fonts != null) {
                    SWFFontDescription potentialMatch = null;
                    for (int i = 0; i < fonts.length; ++i) {
                        int impliedStyle;
                        String subFamily;
                        Font font = fonts[i];
                        SWFFontDescription desc = font.getSWFFontDescription();
                        int fontStyle = AFEFontFace.getStyle(desc);
                        if (fontStyle == requestedStyle) {
                            family = this.createAFEFontFace(url, requestedStyle, desc, useTwips);
                            break;
                        }
                        if (potentialMatch != null || (subFamily = desc.getSubFamily()) == null || (impliedStyle = CachedFontFace.guessStyleFromSubFamilyName((String)subFamily)) != requestedStyle) continue;
                        potentialMatch = desc;
                    }
                    if (family == null && potentialMatch != null) {
                        family = this.createAFEFontFace(url, requestedStyle, potentialMatch, useTwips);
                    }
                }
            }
            catch (AFEFMFontException l) {
                throw l;
            }
            catch (Throwable t) {
                throw new RuntimeException("Unexpected exception encountered while reading font file '" + url + "'", t);
            }
        }
        return family;
    }

    private String createAFEFontFace(URL url, int requestedStyle, SWFFontDescription desc, boolean useTwips) {
        AFEFontFace fontFace = AFEFontFace.newInstance(this.maxGlyphsPerFace, desc, url, useTwips);
        fontFace.style = requestedStyle;
        String family = fontFace.getFamily();
        FontSet fontSet = (FontSet)this.getFontCache().get((Object)family);
        if (fontSet == null) {
            fontSet = new FontSet((int)this.maxFacesPerFont);
            this.getFontCache().put((Object)family, (Object)fontSet);
        }
        fontSet.put(fontFace.style, (FontFace)fontFace);
        return family;
    }

    public static class AFEFMFontException
    extends RuntimeException {
        static final long serialVersionUID = -1L;

        public AFEFMFontException(URL location, Exception e) {
            super("The font " + location + " is not usable.", e);
        }
    }

    public static class BatikFailsException
    extends RuntimeException {
        static final long serialVersionUID = -1L;

        public BatikFailsException(double value) {
            super("Font fails with batik: " + value);
        }
    }

    static class AFE2SWFOutlineAdaptor
    implements OutlineConsumer,
    ShapeIterator {
        private Matrix scale;
        private Matrix initialMatrix;
        private ArrayList segments = new ArrayList();
        private int index = 0;
        private double scaledStartX;
        private double scaledStartY;
        private boolean shapeStarted = false;
        private double x1;
        private double y1;
        private boolean variableQuadApproximation;
        private final boolean throwWhenBatikFails;

        AFE2SWFOutlineAdaptor(char ccode, SWFFontDescription desc, int scaleFactor, boolean reverseWindingOrder, boolean variableQuads, boolean throwOnCasesBatikCantHandle) throws UnsupportedFontException, InvalidFontException {
            this.throwWhenBatikFails = throwOnCasesBatikCantHandle;
            this.initialMatrix = new Matrix((double)scaleFactor, 0.0, 0.0, (double)(-scaleFactor), 0.0, 0.0);
            this.variableQuadApproximation = variableQuads;
            desc.getOutline(ccode, (OutlineConsumer)this);
            if (reverseWindingOrder) {
                this.segments = AFE2SWFOutlineAdaptor.reversePoints(this.segments);
            }
        }

        private static ArrayList reversePoints(ArrayList segments) {
            int i;
            if (segments.size() == 0) {
                return segments;
            }
            ArrayList<double[]> newSegments = new ArrayList<double[]>(segments.size());
            ArrayList<Integer> segmentEnds = new ArrayList<Integer>();
            int indexIntoContour = 0;
            for (i = 0; i < segments.size(); ++i) {
                double[] segment = (double[])segments.get(i);
                double[] newSegment = new double[segment.length];
                System.arraycopy(segment, 0, newSegment, 0, segment.length);
                if (segment[0] == 0.0) {
                    newSegments.add(newSegment);
                    indexIntoContour = i + 1;
                    if (i <= 0) continue;
                    segmentEnds.add(new Integer(i - 1));
                    continue;
                }
                newSegments.add(indexIntoContour, newSegment);
            }
            segmentEnds.add(new Integer(i - 1));
            int contour = 0;
            int k = 1;
            i = 0;
            double[] segment = (double[])segments.get(i);
            indexIntoContour = 0;
            while (i < segments.size() - 1) {
                if (segment[0] == 0.0) {
                    indexIntoContour = (Integer)segmentEnds.get(contour);
                    ++contour;
                }
                double[] otherSegment = (double[])newSegments.get(indexIntoContour);
                int j = otherSegment.length - 2;
                while (j > 0) {
                    otherSegment[j] = segment[k];
                    otherSegment[j + 1] = segment[k + 1];
                    if (k == segment.length - 2) {
                        if (i < segments.size() - 1) {
                            segment = (double[])segments.get(++i);
                        }
                        k = -1;
                    }
                    j -= 2;
                    k += 2;
                }
                --indexIntoContour;
            }
            return newSegments;
        }

        private void addSegment(double x, double y, int operator) {
            double[] segment = new double[]{operator, x, y};
            this.segments.add(segment);
        }

        private void addQuadratic(double x, double y, double x2, double y2) {
            double[] segment = new double[]{2.0, x, y, x2, y2};
            this.segments.add(segment);
        }

        private void close() {
            this.addSegment(this.scaledStartX, this.scaledStartY, 1);
            this.shapeStarted = false;
        }

        private void approximateCubicBezierATM(double x2, double y2, double x3, double y3, double x4, double y4) {
            double ax = -this.x1 + 3.0 * x2 - 3.0 * x3 + x4;
            double ay = -this.y1 + 3.0 * y2 - 3.0 * y3 + y4;
            double bx = 3.0 * this.x1 - 6.0 * x2 + 3.0 * x3;
            double by = 3.0 * this.y1 - 6.0 * y2 + 3.0 * y3;
            double cx = -3.0 * this.x1 + 3.0 * x2;
            double cy = -3.0 * this.y1 + 3.0 * y2;
            double dx = this.x1;
            double dy = this.y1;
            double absA = Math.ceil(Math.max(Math.abs(ax), Math.abs(ay)));
            int nQuads = 0;
            while (absA > (double)(10 * nQuads * nQuads * nQuads)) {
                ++nQuads;
            }
            double deltaT = 1.0 / (double)nQuads;
            double slopex0 = cx;
            double slopey0 = cy;
            for (int i = 1; i <= nQuads; ++i) {
                double t = (double)i * deltaT;
                double endX = ((ax * t + bx) * t + cx) * t + dx;
                double endY = ((ay * t + by) * t + cy) * t + dy;
                double endSlopeX = (3.0 * ax * t + 2.0 * bx) * t + cx;
                double endSlopeY = (3.0 * ay * t + 2.0 * by) * t + cy;
                this.addQuadratic((this.x1 + endX) / 2.0 + (slopex0 - endSlopeX) / (double)(4 * nQuads), (this.y1 + endY) / 2.0 + (slopey0 - endSlopeY) / (double)(4 * nQuads), endX, endY);
                this.x1 = endX;
                this.y1 = endY;
                slopex0 = endSlopeX;
                slopey0 = endSlopeY;
            }
        }

        private void approximateCubicBezierFlex(double P0x, double P0y, double P1x, double P1y, double P2x, double P2y, double P3x, double P3y) {
            double PAx = AFE2SWFOutlineAdaptor.getPointOnSegment(P0x, P1x, 0.75);
            double PAy = AFE2SWFOutlineAdaptor.getPointOnSegment(P0y, P1y, 0.75);
            double PBx = AFE2SWFOutlineAdaptor.getPointOnSegment(P3x, P2x, 0.75);
            double PBy = AFE2SWFOutlineAdaptor.getPointOnSegment(P3y, P2y, 0.75);
            double dx = (P3x - P0x) / 16.0;
            double dy = (P3y - P0y) / 16.0;
            double c1x = AFE2SWFOutlineAdaptor.getPointOnSegment(P0x, P1x, 0.375);
            double c1y = AFE2SWFOutlineAdaptor.getPointOnSegment(P0y, P1y, 0.375);
            double c2x = AFE2SWFOutlineAdaptor.getPointOnSegment(PAx, PBx, 0.375);
            double c2y = AFE2SWFOutlineAdaptor.getPointOnSegment(PAy, PBy, 0.375);
            c2x -= dx;
            c2y -= dy;
            double c3x = AFE2SWFOutlineAdaptor.getPointOnSegment(PBx, PAx, 0.375);
            double c3y = AFE2SWFOutlineAdaptor.getPointOnSegment(PBy, PAy, 0.375);
            c3x += dx;
            c3y += dy;
            double c4x = AFE2SWFOutlineAdaptor.getPointOnSegment(P3x, P2x, 0.375);
            double c4y = AFE2SWFOutlineAdaptor.getPointOnSegment(P3y, P2y, 0.375);
            double a1x = (c1x + c2x) / 2.0;
            double a1y = (c1y + c2y) / 2.0;
            double a2x = (PAx + PBx) / 2.0;
            double a2y = (PAy + PBy) / 2.0;
            double a3x = (c3x + c4x) / 2.0;
            double a3y = (c3y + c4y) / 2.0;
            this.addQuadratic(c1x, c1y, a1x, a1y);
            this.addQuadratic(c2x, c2y, a2x, a2y);
            this.addQuadratic(c3x, c3y, a3x, a3y);
            this.addQuadratic(c4x, c4y, P3x, P3y);
            this.x1 = P3x;
            this.y1 = P3y;
        }

        private static double getPointOnSegment(double P0, double P1, double ratio) {
            return P0 + (P1 - P0) * ratio;
        }

        public void curveto(double x2, double y2, double x3, double y3, double x4, double y4) {
            if (!this.shapeStarted) {
                this.addSegment(this.scaledStartX, this.scaledStartY, 0);
                this.shapeStarted = true;
            }
            double scaledX2 = this.scale.applyToXYGetX(x2, y2);
            double scaledY2 = this.scale.applyToXYGetY(x2, y2);
            double scaledX3 = this.scale.applyToXYGetX(x3, y3);
            double scaledY3 = this.scale.applyToXYGetY(x3, y3);
            double scaledX4 = this.scale.applyToXYGetX(x4, y4);
            double scaledY4 = this.scale.applyToXYGetY(x4, y4);
            if (this.variableQuadApproximation) {
                this.approximateCubicBezierATM(scaledX2, scaledY2, scaledX3, scaledY3, scaledX4, scaledY4);
            } else {
                this.approximateCubicBezierFlex(this.x1, this.y1, scaledX2, scaledY2, scaledX3, scaledY3, scaledX4, scaledY4);
            }
        }

        public void curveto(double x2, double y2, double x3, double y3) {
            if (!this.shapeStarted) {
                this.addSegment(this.scaledStartX, this.scaledStartY, 0);
                this.shapeStarted = true;
            }
            this.checkRange(x2, y2);
            this.checkRange(x3, y3);
            double scaledX2 = this.scale.applyToXYGetX(x2, y2);
            double scaledY2 = this.scale.applyToXYGetY(x2, y2);
            double scaledX3 = this.scale.applyToXYGetX(x3, y3);
            double scaledY3 = this.scale.applyToXYGetY(x3, y3);
            this.addQuadratic(scaledX2, scaledY2, scaledX3, scaledY3);
        }

        public void endchar() {
        }

        private void checkRange(double x, double y) {
            if (this.throwWhenBatikFails) {
                if (Math.abs(x) > 32767.0) {
                    throw new BatikFailsException(x);
                }
                if (Math.abs(y) > 32767.0) {
                    throw new BatikFailsException(y);
                }
            }
        }

        public void lineto(double x2, double y2) {
            if (!this.shapeStarted) {
                this.addSegment(this.scaledStartX, this.scaledStartY, 0);
                this.shapeStarted = true;
            }
            this.checkRange(x2, y2);
            double scaledX2 = this.scale.applyToXYGetX(x2, y2);
            double scaledY2 = this.scale.applyToXYGetY(x2, y2);
            this.addSegment(scaledX2, scaledY2, 1);
            this.x1 = scaledX2;
            this.y1 = scaledY2;
        }

        public void moveto(double x2, double y2) {
            if (this.shapeStarted) {
                this.close();
            }
            this.checkRange(x2, y2);
            double scaledX2 = this.scale.applyToXYGetX(x2, y2);
            double scaledY2 = this.scale.applyToXYGetY(x2, y2);
            this.scaledStartX = scaledX2;
            this.scaledStartY = scaledY2;
            this.x1 = scaledX2;
            this.y1 = scaledY2;
        }

        public void setMatrix(Matrix newMatrix) {
            this.scale = newMatrix.multiply(this.initialMatrix);
        }

        public short currentSegment(double[] coords) {
            double[] segment = (double[])this.segments.get(this.index);
            coords[0] = segment[1];
            coords[1] = segment[2];
            switch ((int)segment[0]) {
                case 2: {
                    coords[2] = segment[3];
                    coords[3] = segment[4];
                    break;
                }
                case 3: {
                    coords[2] = segment[3];
                    coords[3] = segment[4];
                    coords[4] = segment[5];
                    coords[5] = segment[6];
                }
            }
            return (short)segment[0];
        }

        public boolean isDone() {
            return this.index >= this.segments.size();
        }

        public void next() {
            ++this.index;
        }
    }

    public static class AFEFontFace
    extends CachedFontFace {
        private SWFFontDescription fontDescription;
        private URL fontPath;
        private short ascent;
        private short descent;
        private short lineGap;
        private double emScale;

        private AFEFontFace(short maxGlyphsPerFace, SWFFontDescription desc, URL fontPath, boolean useTwips, String trademark, String copyright) throws InvalidFontException, UnsupportedFontException {
            super((int)maxGlyphsPerFace, 0, AFEFontFace.toFSType(desc.getPermissions()), copyright, trademark, useTwips);
            this.init(fontPath, desc);
        }

        public static AFEFontFace newInstance(short maxGlyphsPerFace, SWFFontDescription font, URL fontPath, boolean useTwips) {
            try {
                String copyright;
                String trademark = font.getTrademark();
                if (trademark == null) {
                    trademark = new String();
                }
                if ((copyright = font.getCopyright()) == null) {
                    copyright = new String();
                }
                return new AFEFontFace(maxGlyphsPerFace, font, fontPath, useTwips, trademark, copyright);
            }
            catch (FontEngineException e) {
                throw new AFEFMFontException(fontPath, (Exception)((Object)e));
            }
        }

        private static int getStyle(SWFFontDescription desc) throws InvalidFontException, UnsupportedFontException {
            int style = 0;
            if (desc.isBold()) {
                ++style;
            }
            if (desc.isItalic()) {
                style += 2;
            }
            return style;
        }

        private static FSType toFSType(Permission perms) {
            boolean HARDCODED_WRONG_FSTYPE_VALUE = false;
            if (perms == Permission.EDITABLE) {
                return new FSType(0, "Editable embedding", false, true, false, false);
            }
            if (perms == Permission.INSTALLABLE) {
                return new FSType(0, "Installable embedding", true, false, false, false);
            }
            if (perms == Permission.PREVIEW_AND_PRINT) {
                return new FSType(0, "Preview and Print embedding", false, false, true, false);
            }
            return new FSType(0, "No embedding allowed", false, false, false, true);
        }

        private void init(URL fp, SWFFontDescription desc) throws InvalidFontException, UnsupportedFontException {
            this.fontPath = fp;
            this.fontDescription = desc;
            this.style = AFEFontFace.getStyle(desc);
            this.getScaledMetrics();
        }

        private void getScaledMetrics() throws InvalidFontException, UnsupportedFontException {
            this.emScale = 1024.0 / this.fontDescription.getEmScale();
            this.ascent = (short)Math.rint(this.fontDescription.getAscent() * this.emScale * (double)(this.useTwips ? 20 : 1));
            this.descent = (short)Math.rint(this.fontDescription.getDescent() * this.emScale * (double)(this.useTwips ? 20 : 1));
            this.lineGap = (short)Math.rint(this.fontDescription.getLineGap() * this.emScale * (double)(this.useTwips ? 20 : 1));
        }

        public boolean canDisplay(char c) {
            try {
                return this.fontDescription.canDisplay(c);
            }
            catch (FontEngineException e) {
                throw new AFEFMFontException(this.fontPath, (Exception)((Object)e));
            }
        }

        public GlyphEntry getGlyphEntry(char c) {
            return (GlyphEntry)this.glyphCache.get((int)c);
        }

        protected GlyphEntry createGlyphEntry(char c) {
            return this.createGlyphEntry(c, c);
        }

        public GlyphEntry createGlyphEntry(char c, char referenceChar) {
            try {
                return this.createGlyphEntry(c, referenceChar, false, true, false);
            }
            catch (InvalidGlyphException e) {
                throw new AFEFMFontException(this.fontPath, (Exception)((Object)e));
            }
        }

        public GlyphEntry createGlyphEntry(char c, char referenceChar, boolean reverseWindingOrder, boolean variableQuads, boolean failWhenBatikFails) throws InvalidGlyphException {
            try {
                AFE2SWFOutlineAdaptor outlineAdaptor = new AFE2SWFOutlineAdaptor(referenceChar, this.fontDescription, 1024, reverseWindingOrder, variableQuads, failWhenBatikFails);
                Shape s = this.getShapeFromGlyph(outlineAdaptor);
                GlyphEntry ge = new GlyphEntry();
                ge.advance = (int)((double)this.getAdvance(referenceChar) * this.emScale * (double)(this.useTwips ? 20 : 1));
                ge.character = c;
                ge.shape = s;
                ge.bounds = null;
                return ge;
            }
            catch (InvalidGlyphException e) {
                throw e;
            }
            catch (FontEngineException e) {
                throw new AFEFMFontException(this.fontPath, (Exception)((Object)e));
            }
        }

        private Shape getShapeFromGlyph(AFE2SWFOutlineAdaptor outline) {
            ShapeBuilder shape = new ShapeBuilder(this.useTwips);
            shape.setCurrentLineStyle(0);
            shape.setCurrentFillStyle1(1);
            shape.setUseFillStyle1(true);
            shape.processShape((ShapeIterator)outline);
            return shape.build();
        }

        public int getFirstChar() {
            try {
                return this.fontDescription.getFirstChar();
            }
            catch (FontEngineException e) {
                throw new AFEFMFontException(this.fontPath, (Exception)((Object)e));
            }
        }

        public int getAscent() {
            return this.ascent;
        }

        public int getDescent() {
            return this.descent;
        }

        public String getFamily() {
            try {
                return this.fontDescription.getFamily();
            }
            catch (FontEngineException e) {
                throw new AFEFMFontException(this.fontPath, (Exception)((Object)e));
            }
        }

        public int getLineGap() {
            return this.lineGap;
        }

        public int getNumGlyphs() {
            try {
                return this.fontDescription.getNumGlyphs();
            }
            catch (FontEngineException e) {
                throw new AFEFMFontException(this.fontPath, (Exception)((Object)e));
            }
        }

        public double getEmScale() {
            return this.emScale;
        }

        public String getPostscriptName() {
            try {
                String psName = this.fontDescription.getPostscriptName();
                if (psName == null) {
                    psName = new String();
                }
                return psName;
            }
            catch (FontEngineException e) {
                throw new AFEFMFontException(this.fontPath, (Exception)((Object)e));
            }
        }

        public int getAdvance(char c) {
            try {
                return (int)Math.rint(this.fontDescription.getHorizontalAdvance(c));
            }
            catch (FontEngineException e) {
                throw new AFEFMFontException(this.fontPath, (Exception)((Object)e));
            }
        }

        public int getMissingGlyphCode() {
            return 0;
        }

        public double getPointSize() {
            return 1.0;
        }

        public SWFFontDescription getDescription() {
            return this.fontDescription;
        }
    }
}

