import com.we_lab_doc.spacecard.model.*
import com.we_lab_doc.spacecard.utils.*

class CrossLinkTests extends SpaceCardModelTestCase {
	
    void testCreateDelete() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)
		assertNotNull sv
		def svc = Organization.getSupervisorCommunity()
		assertNotNull svc
		def p1 = Project.create(
				[
				 title:"hoge1",
				 creator:sv
				]
				,svc)
		def p2 = Project.create(
				[
				 title:"hoge2",
				 creator:sv					 
				]
				,svc)
		ModelUtils.flush([p1,p2])

		def link = CrossLink.create("hoge")
		link.bind(p1,p2)
		assertNotNull "1", link
		assertTrue "2", ModelUtils.flush([link])
		assertTrue "3-1", ModelUtils.containsUsingId(link.owners, p1)
		assertTrue "3-2", ModelUtils.containsUsingId(link.owners, p2)			
		assertTrue "4-1", ModelUtils.containsUsingId(link.targets, p1)
		assertTrue "4-2", ModelUtils.containsUsingId(link.targets, p2)
		assertTrue "4-3", link.getTarget(p1)?.id == p2.id
		assertTrue "4-4", link.getTarget(p2)?.id == p1.id					
		assertTrue "5: ${p1.links}", ModelUtils.containsUsingId(p1.links, link)
		assertTrue "6: ${p1.counterLinks}", ModelUtils.containsUsingId(p1.counterLinks, link)
		assertTrue "7: ${p2.counterLinks}", ModelUtils.containsUsingId(p2.counterLinks, link)			

		assertTrue "8", link.remove()
		assertTrue "9",  p1.links == null || p1.links.size() == 0
		assertTrue "10", p1.counterLinks == null || p1.counterLinks.size() == 0
		assertTrue "11", p2.counterLinks == null || p2.counterLinks.size() == 0
		
		assertTrue "12", Link.list().size() == 0
    }
}
