/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.we_lab_doc.spacecard.utils
 
import org.apache.log4j.Logger 
import java.io.*
import java.util.*

/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: February 25, 2008
 */ 
class MimeTypesUtils {
	private MimeTypesUtils() {}
	
	static log = Logger.getLogger("grails.app.utils.MimeTypesUtils")
	static def mimeTypes = [:]
	//////////////////////////////////////////////////
	static def getMimeTypes() {
		return mimeTypes
	}
	static def initialize(String mimeTypesPath) {
        InputStream is = null
		boolean rs = true
        try {
    		log.info "mime.types file : ${mimeTypesPath}"        	
            is = new BufferedInputStream(new FileInputStream(mimeTypesPath))
            rs = create(is)
            log.debug(mimeTypes)
        } catch (Exception e) {
        	log.error(e)
        	rs = false
        }
        if (is != null) {
        	try {
        		is.close()
        	} catch (IOException e) {
        		log.error(e)
        		rs = false
        	}
        }		 
        return rs		
	}
	static def initialize(javax.servlet.ServletContext servletContext) {
		assert servletContext
		def realPath = servletContext.getRealPath("/WEB-INF/mime.types")
		return initialize(realPath)
	}
	////////////////////////////////////////////////
	private static def create(is) {
		assert is
        BufferedReader reader = null
        boolean rs = true
        try {
            reader = new BufferedReader(new InputStreamReader(is))
            String line
            while ((line = reader.readLine()) != null) {
                def l = line.trim()
                if (l.length() == 0 || l.charAt(0) == '#') {
                    continue
                }
                def t = new StringTokenizer(line, " \t\r\n", false)
                if (t.countTokens() == 0) {
                    continue
                }
                def value = t.nextToken().toLowerCase()
                while (t.hasMoreTokens()) {
                    def key = t.nextToken().toLowerCase()
                    if (!mimeTypes.containsKey(key)) {
                        mimeTypes.put(key, value)
                    }
                }
            }
        } catch (IOException e) { 
        	log.error(e)
        	rs = false
        }
        if (reader != null) {
        	try {
        		reader.close()
        	} catch (IOException e) {
        		rs = false
            }
        }
        return rs
	}
}