/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import com.we_lab_doc.spacecard.model.AttachedFileManager
import com.we_lab_doc.spacecard.model.abstracts.AttachedFile
import com.we_lab_doc.spacecard.model.exception.ForwardingException
import com.we_lab_doc.spacecard.bean.annotation.SpaceCardCustomBean

/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: March 19, 2008
 * 
 */
@SpaceCardCustomBean 
class ByteArrayAttachedFileManager implements AttachedFileManager {
	 void upload(AttachedFile attachedFile, InputStream inputStream)  throws ForwardingException {
		 setMaterial(attachedFile, inputStream)
	 }
	 void disposeIfNeeds(AttachedFile attachedFile){
		 /* noop */
	 }
	 private void setMaterial(AttachedFile attachedFile, InputStream inputStream ) throws ForwardingException {
		 assert inputStream != null
		 try {
			 def asize = inputStream.available()
			 attachedFile.byteArray = new byte[asize]
			 def rsize = inputStream.read(attachedFile.byteArray)
			 inputStream.close()
			 assert(rsize == asize)
		} catch(e){
			throw new ForwardingException("ByteArrayAttachedFileManager#setMaterilas: attachedFile = ${attachedFile}", e)
		}
	}	 
}