/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.OutlineConsumer2;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.TTInterpreter;
import com.adobe.fontengine.font.opentype.TTOutline;
import com.adobe.fontengine.font.opentype.TTPoint;
import com.adobe.fontengine.font.opentype.TTSimpleOutline;
import com.adobe.fontengine.math.F26Dot6;
import com.adobe.fontengine.math.F26Dot6Vector;
import java.util.ArrayList;

public final class TTCompositeOutline
extends TTOutline {
    private TTComponent[] components;
    public TTSimpleOutline merged;
    private OTByteArray instructions;
    private int instructionsOffset;
    private int instructionsLength;
    private boolean isScaled = false;
    private boolean isInstructed = false;
    private int currentUnitsPerEm = -1;
    private Matrix currentEm2px = null;
    private int scanType;
    boolean isMerged = false;

    public TTCompositeOutline(ArrayList arrayList, int n, int n2, int n3, int n4, OTByteArray oTByteArray, int n5, int n6) throws InvalidFontException {
        this.components = arrayList.toArray(new TTComponent[0]);
        this.instructions = oTByteArray;
        this.instructionsOffset = n5;
        this.instructionsLength = n6;
        this.merged = new TTSimpleOutline();
        this.merged.unscaledCoordinatesAreInvalid = true;
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < this.components.length; ++i) {
            n7 += this.components[i].outline.getNumContours();
            n8 += this.components[i].outline.getNumOutlinePoints();
        }
        this.merged.contourEndPoints = new int[n7];
        this.merged.points = new TTPoint[n8 + 4];
        this.merged.points[n8 + 0] = new TTPoint(n, 0, false);
        this.merged.points[n8 + 1] = new TTPoint(n2, 0, false);
        this.merged.points[n8 + 2] = new TTPoint(0, n3, false);
        this.merged.points[n8 + 3] = new TTPoint(0, n4, false);
    }

    TTPoint getPoint(int n) throws InvalidGlyphException {
        return this.merged.getPoint(n);
    }

    int getNumOutlinePoints() throws InvalidGlyphException {
        return this.merged.getNumOutlinePoints();
    }

    int getNumContours() {
        return this.merged.getNumContours();
    }

    int getContourNextPoint(int n, int n2) throws InvalidGlyphException {
        return this.merged.getContourNextPoint(n, n2);
    }

    int getContourFirstPoint(int n) throws InvalidGlyphException {
        return this.merged.getContourFirstPoint(n);
    }

    int getContourLastPoint(int n) throws InvalidGlyphException {
        return this.merged.getContourLastPoint(n);
    }

    public TTSimpleOutline getMerged() {
        this.mergeComponents();
        return this.merged;
    }

    public void scale(int n, Matrix matrix) {
        int n2;
        int n3;
        if (this.isScaled && this.currentUnitsPerEm == n && matrix.equals(this.currentEm2px)) {
            return;
        }
        for (n3 = 0; n3 < this.components.length; ++n3) {
            this.components[n3].scale(n, matrix);
        }
        for (n2 = n3 = this.merged.points.length - 4; n2 < n3 + 4; ++n2) {
            this.merged.points[n2].scale(n, matrix);
        }
        n2 = F26Dot6.roundHalfUp(F26Dot6.fromDouble(matrix.applyToXYGetX((double)(this.merged.points[n3 + 1].unscaled.x - this.merged.points[n3].unscaled.x) / (double)n, 0.0)));
        this.merged.points[n3 + 1].hinted.x = this.merged.points[n3].hinted.x + n2;
        this.merged.points[n3 + 2].hinted.y = F26Dot6.round(this.merged.points[n3 + 2].hinted.y);
        int n4 = F26Dot6.roundHalfUp(F26Dot6.fromDouble(matrix.applyToXYGetY(0.0, (double)(this.merged.points[n3 + 3].unscaled.y - this.merged.points[n3 + 2].unscaled.y) / (double)n)));
        this.merged.points[n3 + 3].hinted.y = this.merged.points[n3 + 2].hinted.y + n4;
        this.isScaled = true;
        this.currentUnitsPerEm = n;
        this.currentEm2px = matrix;
        this.isInstructed = false;
    }

    public int getScanType() {
        return this.scanType;
    }

    public void instruct(TTInterpreter tTInterpreter) throws InvalidGlyphException, UnsupportedFontException {
        int n;
        if (this.isInstructed) {
            return;
        }
        for (n = 0; n < this.components.length; ++n) {
            this.components[n].instruct(tTInterpreter);
        }
        this.isMerged = false;
        this.mergeComponents();
        n = F26Dot6.roundHalfUp(this.merged.points[this.merged.points.length - 4].unhinted.x);
        this.shiftPoints(n - this.merged.points[this.merged.points.length - 4].unhinted.x, 0, 0, this.merged.points.length);
        if (this.instructions != null) {
            tTInterpreter.runGlyf(this.merged, this.instructions, this.instructionsOffset, this.instructionsOffset + this.instructionsLength);
            this.scanType = tTInterpreter.getScanType();
        } else {
            this.scanType = 0;
        }
        this.isInstructed = true;
    }

    protected void mergeComponents() {
        if (this.isMerged) {
            return;
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.components.length; ++i) {
            int n3;
            TTSimpleOutline tTSimpleOutline = this.components[i].outline.getMerged();
            for (n3 = 0; n3 < tTSimpleOutline.contourEndPoints.length; ++n3) {
                this.merged.contourEndPoints[n] = tTSimpleOutline.contourEndPoints[n3] + n2;
                ++n;
            }
            for (n3 = 0; n3 < tTSimpleOutline.points.length - 4; ++n3) {
                this.merged.points[n2] = (TTPoint)tTSimpleOutline.points[n3].clone();
                this.merged.points[n2].hinted.x = F26Dot6.multiplyByF2Dot14(tTSimpleOutline.points[n3].hinted.x, this.components[i].a) + F26Dot6.multiplyByF2Dot14(tTSimpleOutline.points[n3].hinted.y, this.components[i].b);
                this.merged.points[n2].hinted.y = F26Dot6.multiplyByF2Dot14(tTSimpleOutline.points[n3].hinted.x, this.components[i].c) + F26Dot6.multiplyByF2Dot14(tTSimpleOutline.points[n3].hinted.y, this.components[i].d);
                this.merged.points[n2].hinted.x += this.components[i].offset.x;
                this.merged.points[n2].hinted.y += this.components[i].offset.y;
                this.merged.points[n2].unhinted.x = this.merged.points[n2].hinted.x;
                this.merged.points[n2].unhinted.y = this.merged.points[n2].hinted.y;
                this.merged.points[n2].original.x = F26Dot6.multiplyByF2Dot14(tTSimpleOutline.points[n3].original.x, this.components[i].a) + F26Dot6.multiplyByF2Dot14(tTSimpleOutline.points[n3].original.y, this.components[i].b);
                this.merged.points[n2].original.y = F26Dot6.multiplyByF2Dot14(tTSimpleOutline.points[n3].original.x, this.components[i].c) + F26Dot6.multiplyByF2Dot14(tTSimpleOutline.points[n3].original.y, this.components[i].d);
                this.merged.points[n2].original.x += this.components[i].offset.x;
                this.merged.points[n2].original.y += this.components[i].offset.y;
                ++n2;
            }
        }
        this.isMerged = true;
    }

    public void toConsumer(OutlineConsumer outlineConsumer) throws InvalidFontException {
        this.mergeComponents();
        this.merged.toConsumer(outlineConsumer);
    }

    public void toConsumer2(OutlineConsumer2 outlineConsumer2) throws InvalidFontException {
        this.mergeComponents();
        this.merged.toConsumer2(outlineConsumer2);
    }

    public void translate() {
        int n = F26Dot6.roundHalfUp(this.merged.points[this.merged.points.length - 4].hinted.x);
        int n2 = F26Dot6.roundHalfUp(this.merged.points[this.merged.points.length - 4].hinted.y);
        this.shiftPoints(-n, -n2, 0, this.merged.points.length);
    }

    private void shiftPoints(int n, int n2, int n3, int n4) {
        for (int i = n3; i < n4; ++i) {
            this.merged.points[i].hinted.x += n;
            this.merged.points[i].hinted.y += n2;
        }
    }

    public static final class TTComponent {
        public TTOutline outline;
        public int argument1;
        public int argument2;
        public boolean alignByPosition;
        public boolean roundXYToGrid;
        public boolean useThisMetrics;
        public boolean scaledOffsets;
        public boolean unscaledOffset;
        public F26Dot6Vector offset;
        public int a;
        public int b;
        public int c;
        public int d;

        public void scale(int n, Matrix matrix) {
            if (this.alignByPosition) {
                int n2 = F26Dot6.fromDouble(matrix.applyToXYGetX((double)this.argument1 / (double)n, 0.0));
                int n3 = F26Dot6.fromDouble(matrix.applyToXYGetY(0.0, (double)this.argument2 / (double)n));
                if (this.roundXYToGrid) {
                    n2 = F26Dot6.roundHalfUp(n2);
                    n3 = F26Dot6.roundHalfUp(n3);
                }
                this.offset = new F26Dot6Vector(n2, n3);
            }
            this.outline.scale(n, matrix);
        }

        public void instruct(TTInterpreter tTInterpreter) throws InvalidGlyphException, UnsupportedFontException {
            this.outline.instruct(tTInterpreter);
        }
    }
}

