/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.ProxyRandomAccessFile;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import junit.framework.TestCase;

public abstract class ByteWriterTestsBase
extends TestCase {
    private static final long DEFAULT_TESTFILE_LENGTH = 666666L;
    private RandomAccessFile raf = null;
    private static final int LINEAR_MAX_BUFFER_SIZE = 730000;
    private static final int backStepIteration = 4;
    private static final double backStepAmount = 2.5;

    protected void setUp() throws Exception {
        super.setUp();
        long testFileLength = Long.getLong("com.adobe.internal.rideau.io.TestFileLength", 666666L);
        this.raf = new ProxyRandomAccessFile(testFileLength);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.raf.close();
    }

    protected abstract ByteWriter createByteWriter(long var1) throws IOException;

    public final void testLinearSingleByteWrite() throws Exception {
        System.out.print("\tLinear Single Byte Write Test - ");
        ByteWriter byteWriter = this.createByteWriter(this.raf.length());
        this.raf.seek(0L);
        for (long i = 0L; i < this.raf.length(); ++i) {
            byteWriter.write(i, this.raf.read());
        }
        ByteWriterTestsBase.assertTrue((this.raf.length() == byteWriter.length() ? 1 : 0) != 0);
        byteWriter.flush();
        ByteWriter byteReader = byteWriter;
        this.compareByteWriterAgainstRAF(byteReader, this.raf);
        byteReader.close();
        byteWriter.close();
        System.out.println("Completed");
    }

    public final void testNonLinearSingleByteWrite() throws Exception {
        System.out.print("\tNon-Linear Single Byte Write Test - ");
        ByteWriter byteWriter = this.createByteWriter(this.raf.length());
        int numberOfPasses = 5;
        for (int offset = 0; offset < numberOfPasses; ++offset) {
            for (long i = (long)offset; i < this.raf.length(); i += (long)numberOfPasses) {
                this.raf.seek(i);
                byteWriter.write(i, this.raf.read());
                ByteWriterTestsBase.assertTrue((byteWriter.length() >= i ? 1 : 0) != 0);
            }
        }
        ByteWriterTestsBase.assertTrue((this.raf.length() == byteWriter.length() ? 1 : 0) != 0);
        byteWriter.flush();
        ByteWriter byteReader = byteWriter;
        this.compareByteWriterAgainstRAF(byteReader, this.raf);
        byteReader.close();
        byteWriter.close();
        System.out.println("Completed");
    }

    public final void testLinearMultiByteWrite() throws Exception {
        System.out.print("\tLinear Mulitbyte Write Test - ");
        for (int bufferSize = 7; bufferSize < 730000; bufferSize *= 7) {
            int bytesRead;
            ByteWriter byteWriter = this.createByteWriter(this.raf.length());
            long position = 0L;
            byte[] buffer = new byte[bufferSize];
            this.raf.seek(0L);
            while ((bytesRead = this.raf.read(buffer, 0, bufferSize)) != -1) {
                byteWriter.write(position, buffer, 0, bytesRead);
                position += (long)bytesRead;
            }
            byteWriter.flush();
            ByteWriter byteReader = byteWriter;
            this.compareByteWriterAgainstRAF(byteReader, this.raf);
            byteReader.close();
            byteWriter.close();
        }
        System.out.println("Completed");
    }

    public final void testBackSteppingLinearMultiByteWrite() throws Exception {
        System.out.print("\tBack Stepping Linear Mulitbyte Write Test - ");
        for (int bufferSize = 7; bufferSize < 730000; bufferSize *= 7) {
            int bytesRead;
            ByteWriter byteWriter = this.createByteWriter(this.raf.length());
            long position = 0L;
            byte[] buffer = new byte[bufferSize];
            this.raf.seek(0L);
            int iteration = 0;
            while ((bytesRead = this.raf.read(buffer, 0, bufferSize)) != -1) {
                byteWriter.write(position, buffer, 0, bytesRead);
                if (++iteration % 4 == 0) {
                    position = (long)((double)position - (double)bufferSize * 2.5);
                    this.raf.seek(position);
                    continue;
                }
                position += (long)bytesRead;
            }
            byteWriter.flush();
            ByteWriter byteReader = byteWriter;
            this.compareByteWriterAgainstRAF(byteReader, this.raf);
            byteReader.close();
            byteWriter.close();
        }
        System.out.println("Completed");
    }

    public final void testNonLinearMultiByteWrite() throws Exception {
        System.out.print("\tLinear Mulitbyte Write Test - ");
        for (int bufferStep = 1; bufferStep < 6; bufferStep += 2) {
            int bytesRead;
            ByteWriter byteWriter = this.createByteWriter(this.raf.length());
            long position = 0L;
            int bufferSize = (int)(Math.pow(bufferStep, 5.0) * 7.0);
            byte[] buffer = new byte[bufferSize];
            this.raf.seek(0L);
            while ((bytesRead = this.raf.read(buffer, 0, bufferSize)) != -1) {
                byteWriter.write(position, buffer, 0, bytesRead);
                position += (long)bytesRead;
            }
            this.compareByteWriterAgainstRAF(byteWriter, this.raf);
            byteWriter.close();
        }
        System.out.println("Completed");
    }

    public final void testReadAndWrite() throws Exception {
        int bytesRead;
        System.out.print("\tRead and Write Test - ");
        int bufferSize = 4097;
        long position = 0L;
        long lastPosition = 0L;
        ByteWriter byteWriter = this.createByteWriter(this.raf.length());
        byte[] buffer = new byte[bufferSize];
        int passCount = -1;
        while ((bytesRead = this.raf.read(buffer, 0, bufferSize)) != -1) {
            for (long readPosition = 123L; readPosition < lastPosition; readPosition += 111L) {
                ByteWriterTestsBase.assertTrue((byteWriter.read(readPosition) == passCount ? 1 : 0) != 0);
            }
            ++passCount;
            byteWriter.write(position, buffer, 0, bytesRead);
            lastPosition = position;
            position += (long)bytesRead;
            for (long secondWritePosition = 123L; secondWritePosition < position; secondWritePosition += 111L) {
                byteWriter.write(secondWritePosition, passCount);
            }
        }
        System.out.println("Completed");
    }

    public final void testNonLinearMultiByteReadWrite() throws Exception {
        System.out.print("\tNon-Linear Multibyte Write Test - ");
        ByteWriter byteReader = null;
        ByteWriter byteWriter = null;
        int bufferSize = 1;
        for (long rafBuffer = 128L; rafBuffer <= this.raf.length(); rafBuffer *= 2L) {
            bufferSize = 1;
            while ((long)bufferSize < rafBuffer) {
                int bytesRead;
                byteWriter = this.createByteWriter(this.raf.length());
                int position = 0;
                byte[] buffer = new byte[bufferSize];
                this.raf.seek(0L);
                while ((bytesRead = this.raf.read(buffer, 0, bufferSize)) != -1) {
                    byteWriter.write(position, buffer, 0, bytesRead);
                    position += bytesRead;
                }
                bufferSize = (int)((long)bufferSize + rafBuffer);
            }
            byteReader = byteWriter;
            this.raf.seek(0L);
            Random rand = new Random();
            int n = (int)rafBuffer - 1;
            int bytesToRead = rand.nextInt(n);
            for (int i = 0; i < bytesToRead; ++i) {
                int byteFromRAF = this.raf.read();
                if ((byteReader.read(i) & 0xFF) != (byteFromRAF & 0xFF)) {
                    System.out.println("testLinearMultiByteWrite = i = " + i);
                    System.out.println(" byteReader.read(i) " + byteReader.read(i) + " byteFromRAF " + byteFromRAF);
                }
                ByteWriterTestsBase.assertTrue(((byteReader.read(i) & 0xFF) == (byteFromRAF & 0xFF) ? 1 : 0) != 0);
            }
            byteReader.close();
            byteWriter.close();
        }
        System.out.println("Completed");
    }

    private final void compareByteWriterAgainstRAF(ByteReader byteReader, RandomAccessFile raf) throws IOException {
        int bufferSize = 12345;
        raf.seek(0L);
        int bytesRead = 0;
        long position = 0L;
        byte[] rafBuffer = new byte[bufferSize];
        byte[] brBuffer = new byte[bufferSize];
        ByteWriterTestsBase.assertTrue((raf.length() == byteReader.length() ? 1 : 0) != 0);
        while ((bytesRead = byteReader.read(position, brBuffer, 0, bufferSize)) != -1) {
            raf.read(rafBuffer, 0, bufferSize);
            for (int i = 0; i < Math.min(brBuffer.length, bytesRead); ++i) {
                ByteWriterTestsBase.assertTrue((brBuffer[i] == rafBuffer[i] ? 1 : 0) != 0);
            }
            position += (long)bytesRead;
        }
    }
}

