/*
 * Decompiled with CFR 0.152.
 */
package flex.bootstrap;

import flex.webtier.util.J2EEUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;

public class BootstrapClassLoader
extends URLClassLoader {
    private String[] deferToSuper;
    private String[] exceptionList;
    private Map classCache = new HashMap();
    private static BootstrapClassLoader instance;
    private static String BOOTSTRAP_PROPERTIES_FILENAME;
    private static int references;

    public static synchronized ClassLoader getClassLoader() {
        return instance;
    }

    public static synchronized ClassLoader getClassLoader(ServletContext context) {
        if (instance == null) {
            J2EEUtil.setServerInfo(context.getServerInfo());
            Properties props = BootstrapClassLoader.getBootstrapProperties(context);
            String classpath = context.getInitParameter("flex.class.path");
            if (classpath == null) {
                throw new RuntimeException("init-parameter 'flex.class.path' was not found");
            }
            StringTokenizer st = new StringTokenizer(classpath, ",");
            ArrayList<URL> cpList = new ArrayList<URL>();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                String path = J2EEUtil.getRealPath(token, context);
                File file = null;
                if (path == null && J2EEUtil.getRealPath("/", context) == null) {
                    System.err.println("BootstrapClassLoader: the application server doesn't return a valid path for ServletContext.getRealPath(); try expanding the war file before deploying.");
                    continue;
                }
                if (path == null) {
                    file = new File(token);
                } else {
                    file = new File(path);
                    if (!file.exists()) {
                        file = new File(token);
                    }
                }
                if (file.exists()) {
                    try {
                        file = file.getCanonicalFile();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (file.isDirectory()) {
                        File[] libFiles = file.listFiles();
                        for (int i = 0; i < libFiles.length; ++i) {
                            String fileName = libFiles[i].toString();
                            if (!fileName.endsWith(".jar") && !fileName.endsWith(".zip")) continue;
                            try {
                                cpList.add(libFiles[i].toURL());
                                continue;
                            }
                            catch (MalformedURLException murl) {
                                murl.printStackTrace();
                            }
                        }
                    }
                    try {
                        cpList.add(file.toURL());
                    }
                    catch (MalformedURLException murl) {
                        murl.printStackTrace();
                    }
                    continue;
                }
                System.err.println("BootstrapClassLoader: ignoring " + token);
            }
            URL[] classpathURLs = new URL[cpList.size()];
            cpList.toArray(classpathURLs);
            String[] deferToSuper = null;
            String[] exceptionList = null;
            if (props.getProperty("loadByAppServer") != null) {
                deferToSuper = BootstrapClassLoader.split(props.getProperty("loadByAppServer"), ",");
            }
            if (props.getProperty("exceptions") != null) {
                exceptionList = BootstrapClassLoader.split(props.getProperty("exceptions"), ",");
            }
            instance = new BootstrapClassLoader(classpathURLs, BootstrapClassLoader.class.getClassLoader(), deferToSuper, exceptionList);
        }
        return instance;
    }

    private static String[] split(String line, String sep) {
        if (sep == null) {
            sep = ",";
        }
        StringTokenizer st = new StringTokenizer(line, sep, false);
        int number = st.countTokens();
        ArrayList<String> L = new ArrayList<String>(number);
        for (int i = 0; i < number; ++i) {
            L.add(i, st.nextToken().trim());
        }
        return L.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Properties getBootstrapProperties(ServletContext context) {
        Properties props;
        block25: {
            InputStream propsFileStream;
            String propFileName;
            block24: {
                block23: {
                    propFileName = BOOTSTRAP_PROPERTIES_FILENAME;
                    props = null;
                    propsFileStream = null;
                    propsFileStream = BootstrapClassLoader.class.getClassLoader().getResourceAsStream(propFileName);
                    if (propsFileStream == null) break block23;
                    props = new Properties();
                    props.load(propsFileStream);
                }
                Object var6_4 = null;
                try {
                    if (propsFileStream != null) {
                        propsFileStream.close();
                    }
                    break block24;
                }
                catch (IOException ioe) {}
                break block24;
                {
                    catch (Exception e) {
                        Object var6_5 = null;
                        try {
                            if (propsFileStream != null) {
                                propsFileStream.close();
                            }
                            break block24;
                        }
                        catch (IOException ioe) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    try {
                        if (propsFileStream != null) {
                            propsFileStream.close();
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (props == null) {
                props = new Properties();
                String appServerName = BootstrapClassLoader.getAppServerName(context.getServerInfo());
                propFileName = appServerName + ".properties";
                propsFileStream = BootstrapClassLoader.class.getClassLoader().getResourceAsStream(propFileName);
                props.load(propsFileStream);
                Object var9_14 = null;
                try {
                    if (propsFileStream != null) {
                        propsFileStream.close();
                    }
                    break block25;
                }
                catch (IOException ioe) {}
                break block25;
                {
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Properties file not found: " + propFileName);
                        Object var9_15 = null;
                        try {
                            if (propsFileStream != null) {
                                propsFileStream.close();
                            }
                            break block25;
                        }
                        catch (IOException ioe) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var9_16 = null;
                    try {
                        if (propsFileStream != null) {
                            propsFileStream.close();
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return props;
    }

    private static String getAppServerName(String serverinfo) {
        String appServerName = serverinfo.indexOf("JRun") != -1 ? "jrun" : (serverinfo.indexOf("WebSphere") != -1 ? "websphere" : (serverinfo.indexOf("WebLogic") != -1 ? "weblogic" : (serverinfo.indexOf("Interstage") != -1 ? "interstage" : (serverinfo.indexOf("Hitachi") != -1 ? "hitachi" : (serverinfo.indexOf("Tomcat/5") != -1 && serverinfo.indexOf("Tomcat/5.0") == -1 ? "tomcat55" : "default")))));
        return appServerName;
    }

    BootstrapClassLoader(URL[] classpath, ClassLoader parent, String[] deferToSuper, String[] exceptionList) {
        super(classpath, parent);
        this.deferToSuper = deferToSuper;
        this.exceptionList = exceptionList;
    }

    private boolean isStrInList(String name, String[] list) {
        boolean retValue = false;
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (!name.startsWith(list[i])) continue;
                retValue = true;
                break;
            }
        }
        return retValue;
    }

    private boolean delegateToSuper(String name) {
        return this.isStrInList(name, this.deferToSuper) && !this.isStrInList(name, this.exceptionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        c = (Class<?>)this.classCache.get(name);
        if (c == null) {
            BootstrapClassLoader bootstrapClassLoader = this;
            synchronized (bootstrapClassLoader) {
                c = (Class)this.classCache.get(name);
                if (c == null) {
                    if (this.delegateToSuper(name)) {
                        try {
                            c = super.loadClass(name, resolve);
                        }
                        catch (ClassNotFoundException cnfe) {
                            c = this.findClass(name);
                        }
                    } else {
                        try {
                            c = this.findClass(name);
                        }
                        catch (ClassNotFoundException e) {
                            c = super.loadClass(name, false);
                        }
                    }
                    if (c == null) {
                        throw new ClassNotFoundException();
                    }
                }
                this.classCache.put(name, c);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public URL getResource(String name) {
        URL url = null;
        if (url == null) {
            url = this.findResource(name);
        }
        if (url == null) {
            url = this.getParent().getResource(name);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Class clazz = BootstrapClassLoader.class;
        synchronized (clazz) {
            if (--references == 0) {
                this.deferToSuper = null;
                this.exceptionList = null;
                this.classCache = null;
                instance = null;
            }
        }
    }

    public static synchronized void incrementReferences() {
        ++references;
    }

    static {
        BOOTSTRAP_PROPERTIES_FILENAME = "flex-bootstrap.properties";
    }
}

