/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.util;

import flash.util.FileUtils;
import flash.util.Trace;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class PathResolver {
    protected String appPath;
    protected String localPath;
    protected String rootPath;
    private static ThreadLocal threadLocal;
    private static String flexDir;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PathResolver() {
    }

    public PathResolver(String rootPath) {
        this.rootPath = FileUtils.canonicalPath((String)rootPath);
        File rootPathFile = new File(this.rootPath);
        if (!$assertionsDisabled && !rootPathFile.exists()) {
            throw new AssertionError();
        }
    }

    public static final void setThreadLocalPathResolver(PathResolver pathResolver) {
        threadLocal.set(pathResolver);
    }

    public static final PathResolver getThreadLocalPathResolver() {
        return (PathResolver)threadLocal.get();
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public File resolveFile(String path, boolean useLocalPath) {
        File file = null;
        if (Trace.pathResolver) {
            Trace.trace((String)("Looking for " + path + " : " + useLocalPath + " : " + this.rootPath + " : " + this.localPath));
        }
        if (path != null) {
            try {
                file = new File(path);
            }
            catch (Error nf) {
                // empty catch block
            }
            if (file != null && file.exists() && file.isAbsolute()) {
                try {
                    file = FileUtils.getCanonicalFile((File)file);
                }
                catch (IOException ioe) {
                    if (Trace.error || Trace.pathResolver) {
                        ioe.printStackTrace();
                    }
                    file = null;
                }
                if (Trace.pathResolver) {
                    Trace.trace((String)("Base file exists: " + file));
                }
            }
            if (file == null || !file.exists() || !file.isAbsolute()) {
                if (!((file = this.deduceFile(path, file, useLocalPath)) == null || file.exists() && file.isAbsolute())) {
                    file = null;
                    if (Trace.pathResolver) {
                        Trace.trace((String)"File does not exist");
                    }
                } else if (Trace.pathResolver) {
                    Trace.trace((String)("Resolved file: " + file));
                }
            }
        }
        return file;
    }

    protected File deduceFile(String path, File file, boolean useLocalPath) {
        if (this.rootPath != null && (path.startsWith("/") || path.startsWith(File.separator))) {
            try {
                file = new File(this.rootPath + path);
            }
            catch (Error nf) {
                // empty catch block
            }
            if (Trace.pathResolver) {
                Trace.trace((String)("Attempting to resolve from root path " + this.rootPath));
            }
        } else {
            if (this.appPath != null) {
                try {
                    file = new File(this.appPath + File.separator + path);
                }
                catch (Error nf) {
                    // empty catch block
                }
                if (Trace.pathResolver) {
                    Trace.trace((String)("Attempting to resolve from app path " + this.appPath));
                }
            }
            if (useLocalPath && (file == null || !file.exists()) && this.localPath != null) {
                file = new File(this.localPath + File.separator + path);
                if (Trace.pathResolver) {
                    Trace.trace((String)("Attempting to resolve from local path " + this.localPath));
                }
            }
        }
        return file;
    }

    public String reverseResolve(String contextRoot, String path) {
        File resolved = this.resolveFile(path, true);
        if (resolved == null) {
            return null;
        }
        String resolvedpath = resolved.getAbsolutePath();
        if (resolvedpath.startsWith(this.rootPath)) {
            String truncated = resolvedpath.substring(this.rootPath.length());
            truncated = truncated.replace(File.separatorChar, '/');
            return FileUtils.addPathComponents((String)contextRoot, (String)truncated, (char)'/');
        }
        return null;
    }

    public Object resolveLocation(String uri) {
        Serializable location;
        block2: {
            location = null;
            try {
                location = new URL(uri);
            }
            catch (MalformedURLException malformedURLException) {
                File file = this.resolveFile(uri, true);
                if (file == null || !file.exists()) break block2;
                location = file;
            }
        }
        return location;
    }

    public void setAppPath(String appPath) {
        this.appPath = appPath;
        this.localPath = appPath;
    }

    public String getAppPath() {
        return this.appPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public String getFlexReadPath() {
        File result = System.getProperty("flex.dir") != null ? this.resolveFile(System.getProperty("flex.dir"), false) : (System.getProperty("flex.platform.CLR") != null ? this.resolveFile("/bin/flex", false) : (flexDir != null ? this.resolveFile(flexDir, false) : this.resolveFile("/WEB-INF/flex", false)));
        return result == null ? null : FileUtils.canonicalPath((File)result);
    }

    public static void setFlexDir(String flexDirName) {
        flexDir = flexDirName;
    }

    public String getFlexWritePath() {
        File result = System.getProperty("flex.dir") != null ? this.resolveFile(System.getProperty("flex.dir"), false) : (System.getProperty("flex.platform.CLR") != null ? this.resolveFile(this.rootPath, false) : (flexDir != null ? this.resolveFile(flexDir, false) : this.resolveFile("/WEB-INF/flex", false)));
        return result == null ? null : FileUtils.canonicalPath((File)result);
    }

    static {
        $assertionsDisabled = !PathResolver.class.desiredAssertionStatus();
        threadLocal = new ThreadLocal();
    }
}

