/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import org.apache.batik.util.XMLConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLSupport
implements XMLConstants {
    protected XMLSupport() {
    }

    public static String getXMLLang(Element element) {
        Attr attr = element.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "lang");
        if (attr != null) {
            return attr.getNodeValue();
        }
        Node node = element.getParentNode();
        while (node != null) {
            if (node.getNodeType() == 1 && (attr = ((Element)node).getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "lang")) != null) {
                return attr.getNodeValue();
            }
            node = node.getParentNode();
        }
        return "en";
    }

    public static String getXMLSpace(Element element) {
        Attr attr = element.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "space");
        if (attr != null) {
            return attr.getNodeValue();
        }
        Node node = element.getParentNode();
        while (node != null) {
            if (node.getNodeType() == 1 && (attr = ((Element)node).getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "space")) != null) {
                return attr.getNodeValue();
            }
            node = node.getParentNode();
        }
        return "default";
    }

    public static String defaultXMLSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\n': 
                case '\r': {
                    bl = false;
                    break;
                }
                case '\t': 
                case ' ': {
                    if (bl) break;
                    stringBuffer.append(' ');
                    bl = true;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                    bl = false;
                }
            }
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    public static String preserveXMLSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    stringBuffer.append(' ');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

