/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.builder.Builder;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.AnonymousObjectGraph;
import flex2.compiler.mxml.rep.Array;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.Primitive;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.IntegerPool;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AnonymousObjectGraphBuilder
extends Builder {
    AnonymousObjectGraph graph;

    AnonymousObjectGraphBuilder(CompilationUnit unit, TypeTable typeTable, Configuration configuration, MxmlDocument document) {
        super(unit, typeTable, configuration, document);
    }

    private Object processNode(Node node) {
        if (node.getChildCount() == 1 && node.getChildAt(0) instanceof CDATANode) {
            CDATANode cdata = (CDATANode)node.getChildAt(0);
            if (cdata.image.length() > 0) {
                boolean isPrimitive;
                Object value = this.textParser.parseValue(cdata.image, this.typeTable.objectType, 0, cdata.beginLine, NameFormatter.toDot(this.graph.getType().getName()));
                if (value instanceof BindingExpression) {
                    if (this.hasAttributeInitializers(node)) {
                        this.log(cdata, (CompilerMessage)new HasAttributeInitializers());
                        return null;
                    }
                    return value;
                }
                boolean bl = isPrimitive = value instanceof String || value instanceof Number || value instanceof Boolean;
                if (node.getAttributeCount() > 0 && isPrimitive) {
                    Primitive p = new Primitive(this.document, AnonymousObjectGraphBuilder.getPrimitiveType(this.typeTable, value), value, cdata.beginLine);
                    Iterator i = node.getAttributeNames();
                    while (i.hasNext()) {
                        QName propName = (QName)i.next();
                        p.setProperty(propName.getLocalPart(), node.getAttribute(propName), node.getLineNumber(propName));
                    }
                    value = p;
                }
                return value;
            }
            return null;
        }
        Model model = new Model(this.document, this.graph.getType(), node.beginLine);
        model.setId(node.getLocalPart(), false);
        model.setIsAnonymous(true);
        this.processAttributes(node, model);
        this.processChildren(node, model);
        return model;
    }

    protected void processChildren(Node node, Model parent) {
        String localPart;
        String namespaceURI;
        Node child;
        int i;
        Map arrays = this.createArrays(parent, this.countChildren(node));
        int count = node.getChildCount();
        for (i = 0; i < count; ++i) {
            child = (Node)node.getChildAt(i);
            if (child instanceof CDATANode) {
                this.log(child, (CompilerMessage)new IgnoringCDATA(child.image));
                continue;
            }
            namespaceURI = child.getNamespace();
            localPart = child.getLocalPart();
            if ("Object".equals(localPart) && namespaceURI.length() == 0) {
                this.log(child, (CompilerMessage)new ObjectTag());
                continue;
            }
            Object value = this.processNode(child);
            if (value == null) continue;
            if (arrays.containsKey(localPart)) {
                Array arrayVal = (Array)arrays.get(localPart);
                if (value instanceof BindingExpression) {
                    BindingExpression bexpr = (BindingExpression)value;
                    bexpr.setDestination(arrayVal);
                    bexpr.setDestinationProperty(arrayVal.size());
                    bexpr.setDestinationLValue(Integer.toString(arrayVal.size()));
                } else if (value instanceof Model) {
                    Model valueModel = (Model)value;
                    valueModel.setParent(arrayVal);
                    valueModel.setParentIndex(arrayVal.size());
                }
                arrayVal.addEntry(value, child.beginLine);
                continue;
            }
            if (value instanceof BindingExpression) {
                BindingExpression bexpr = (BindingExpression)value;
                bexpr.setDestination(parent);
                bexpr.setDestinationProperty(localPart);
                bexpr.setDestinationLValue(localPart);
            } else if (value instanceof Model) {
                Model valueModel = (Model)value;
                valueModel.setParent(parent);
            }
            parent.setProperty(localPart, value, child.beginLine);
        }
        count = node.getChildCount();
        for (i = 0; i < count; ++i) {
            child = (Node)node.getChildAt(i);
            if (child instanceof CDATANode) continue;
            namespaceURI = child.getNamespace();
            localPart = child.getLocalPart();
            if ("Object".equals(localPart) && namespaceURI.length() == 0 || !arrays.containsKey(localPart)) continue;
            Array arrayVal = (Array)arrays.get(localPart);
            parent.setProperty(localPart, arrayVal);
        }
    }

    private void processAttributes(Node node, Model model) {
        Iterator i = node.getAttributeNames();
        while (i != null && i.hasNext()) {
            QName qname = (QName)i.next();
            String text = (String)node.getAttribute(qname);
            String localPart = qname.getLocalPart();
            int line = node.getLineNumber(qname);
            this.processDynamicPropertyText(localPart, text, Builder.TextOrigin.FROM_ATTRIBUTE, line, model);
        }
    }

    private Map countChildren(Node node) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        Iterator i = node.getAttributeNames();
        while (i != null && i.hasNext()) {
            QName qname = (QName)i.next();
            String namespaceURI = qname.getNamespace();
            String localPart = qname.getLocalPart();
            if ("Object".equals(localPart) && namespaceURI.length() == 0) continue;
            if (!counts.containsKey(localPart)) {
                counts.put(localPart, IntegerPool.getNumber(1));
                continue;
            }
            int count = (Integer)counts.get(localPart) + 1;
            counts.put(localPart, IntegerPool.getNumber(count));
        }
        int count = node.getChildCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Node child = (Node)node.getChildAt(i2);
            if (child instanceof CDATANode) continue;
            String namespaceURI = child.getNamespace();
            String localPart = child.getLocalPart();
            if ("Object".equals(localPart) && namespaceURI.length() == 0) continue;
            if (!counts.containsKey(localPart)) {
                counts.put(localPart, IntegerPool.getNumber(1));
                continue;
            }
            int num = (Integer)counts.get(localPart) + 1;
            counts.put(localPart, IntegerPool.getNumber(num));
        }
        return counts;
    }

    private Map createArrays(Model parent, Map counts) {
        HashMap<String, Array> arrays = new HashMap<String, Array>();
        Iterator i = counts.keySet().iterator();
        while (i.hasNext()) {
            String localPart = (String)i.next();
            if ((Integer)counts.get(localPart) <= 1) continue;
            Array a = new Array(this.document, this.typeTable.objectType, parent, parent.getXmlLineNumber());
            a.setId(localPart, false);
            a.setIsAnonymous(true);
            if (parent.hasProperty(localPart)) {
                a.addEntry(parent.getProperty(localPart), parent.getXmlLineNumber());
            }
            arrays.put(localPart, a);
        }
        return arrays;
    }

    private static Type getPrimitiveType(TypeTable typeTable, Object o) {
        return o instanceof Boolean ? typeTable.booleanType : (o instanceof Number ? typeTable.numberType : typeTable.stringType);
    }

    public static class ObjectTag
    extends CompilerMessage.CompilerError {
    }

    public static class IgnoringCDATA
    extends CompilerMessage.CompilerWarning {
        public String image;

        public IgnoringCDATA(String image) {
            this.image = image;
        }
    }

    public static class HasAttributeInitializers
    extends CompilerMessage.CompilerError {
    }
}

