/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.binding;

import flex2.compiler.as3.binding.InterfaceInfo;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.QName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

abstract class Info {
    private Set imports;
    private Map qualifiedImports;
    private List interfaceNames;
    private List interfaceMultiNames;
    private List interfaceInfoList;
    private List functions;
    private List getters;
    private List setters;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Info() {
        this.addImport("");
    }

    public void addFunction(QName functionName) {
        if (!$assertionsDisabled && functionName == null) {
            throw new AssertionError();
        }
        if (this.functions == null) {
            this.functions = new ArrayList();
        }
        this.functions.add(functionName);
    }

    public void addGetter(QName getterName) {
        if (!$assertionsDisabled && getterName == null) {
            throw new AssertionError();
        }
        if (this.getters == null) {
            this.getters = new ArrayList();
        }
        this.getters.add(getterName);
    }

    void addImport(String importName) {
        if (!$assertionsDisabled && importName == null) {
            throw new AssertionError();
        }
        if (this.imports == null) {
            this.imports = new TreeSet();
        }
        this.imports.add(importName);
    }

    public void addInterfaceMultiName(String[] namespaces, String interfaceName) {
        if (!($assertionsDisabled || namespaces != null && interfaceName != null)) {
            throw new AssertionError();
        }
        if (this.interfaceMultiNames == null) {
            this.interfaceMultiNames = new ArrayList();
        }
        this.interfaceMultiNames.add(new MultiName(namespaces, interfaceName));
    }

    public void addInterfaceMultiName(String namespace, String interfaceName) {
        if (!($assertionsDisabled || namespace != null && interfaceName != null)) {
            throw new AssertionError();
        }
        if (this.interfaceMultiNames == null) {
            this.interfaceMultiNames = new ArrayList();
        }
        this.interfaceMultiNames.add(new MultiName(namespace, interfaceName));
    }

    void addInterfaceName(String interfaceName) {
        if (!$assertionsDisabled && interfaceName == null) {
            throw new AssertionError();
        }
        if (this.interfaceNames == null) {
            this.interfaceNames = new ArrayList();
        }
        this.interfaceNames.add(interfaceName);
    }

    public void addInterfaceInfo(InterfaceInfo interfaceInfo) {
        if (!$assertionsDisabled && interfaceInfo == null) {
            throw new AssertionError();
        }
        if (this.interfaceInfoList == null) {
            this.interfaceInfoList = new ArrayList();
        }
        this.interfaceInfoList.add(interfaceInfo);
    }

    void addQualifiedImport(String localPart, String namespace) {
        if (!($assertionsDisabled || localPart != null && localPart.length() > 0 && namespace != null)) {
            throw new AssertionError();
        }
        if (this.qualifiedImports == null) {
            this.qualifiedImports = new TreeMap();
        }
        this.qualifiedImports.put(localPart, namespace);
    }

    public void addSetter(QName setterName) {
        if (this.setters == null) {
            this.setters = new ArrayList();
        }
        this.setters.add(setterName);
    }

    boolean definesFunction(String functionName) {
        boolean result = false;
        if (this.functions != null) {
            Iterator iterator = this.functions.iterator();
            while (iterator.hasNext()) {
                QName qName = (QName)iterator.next();
                if (!functionName.equals(qName.getLocalPart())) continue;
                result = true;
            }
        }
        return result;
    }

    boolean definesGetter(String getterName) {
        boolean result = false;
        if (this.getters != null) {
            Iterator iterator = this.getters.iterator();
            while (iterator.hasNext()) {
                QName qName = (QName)iterator.next();
                if (!getterName.equals(qName.getLocalPart())) continue;
                result = true;
            }
        }
        return result;
    }

    boolean definesSetter(String setterName) {
        boolean result = false;
        if (this.setters != null) {
            Iterator iterator = this.setters.iterator();
            while (iterator.hasNext()) {
                QName qName = (QName)iterator.next();
                if (!setterName.equals(qName.getLocalPart())) continue;
                result = true;
            }
        }
        return result;
    }

    public List getFunctionNames() {
        return this.functions;
    }

    List getInterfaceMultiNames() {
        if (this.interfaceMultiNames == null) {
            this.interfaceMultiNames = new ArrayList();
            if (this.interfaceNames != null) {
                Iterator iterator = this.interfaceNames.iterator();
                while (iterator.hasNext()) {
                    String interfaceName = (String)iterator.next();
                    MultiName interfaceMultiName = this.getMultiName(interfaceName);
                    this.interfaceMultiNames.add(interfaceMultiName);
                }
            }
        }
        return this.interfaceMultiNames;
    }

    public MultiName getMultiName(String name) {
        MultiName result;
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError((Object)"Info.getMultiName called on null");
        }
        int lastIndex = name.lastIndexOf(":");
        if (lastIndex < 0) {
            lastIndex = name.lastIndexOf(".");
        }
        if (lastIndex > 0) {
            result = new MultiName(new String[]{name.substring(0, lastIndex)}, name.substring(lastIndex + 1));
        } else if (this.qualifiedImports != null && this.qualifiedImports.containsKey(name)) {
            result = new MultiName(new String[]{(String)this.qualifiedImports.get(name)}, name);
        } else if (this.imports != null) {
            String[] namespaces = new String[this.imports.size()];
            this.imports.toArray(namespaces);
            result = new MultiName(namespaces, name);
        } else {
            result = new MultiName(name);
        }
        return result;
    }

    boolean implementsInterface(String namespace, String interfaceName) {
        boolean result = false;
        if (!($assertionsDisabled || this.interfaceMultiNames == null && this.interfaceInfoList == null || this.interfaceMultiNames != null && this.interfaceInfoList != null && this.interfaceInfoList.size() == this.interfaceMultiNames.size())) {
            throw new AssertionError((Object)("Info.implementsInterface: interfaceInfoList = " + this.interfaceInfoList + ", interfaceMultiNames = " + this.interfaceMultiNames));
        }
        if (this.interfaceInfoList != null) {
            Iterator iterator = this.interfaceInfoList.iterator();
            while (iterator.hasNext()) {
                InterfaceInfo interfaceInfo = (InterfaceInfo)iterator.next();
                if (interfaceInfo.getInterfaceName().equals(namespace + ":" + interfaceName)) {
                    result = true;
                    continue;
                }
                if (interfaceInfo.extendsInterface(namespace, interfaceName)) {
                    result = true;
                    continue;
                }
                if (!interfaceInfo.implementsInterface(namespace, interfaceName)) continue;
                result = true;
            }
        }
        return result;
    }

    static {
        $assertionsDisabled = !Info.class.desiredAssertionStatus();
    }
}

