/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ProxyRandomAccessFile
extends RandomAccessFile {
    private static final int lowData = 1;
    private static final int dataRange = 255;
    private static final String dummyFileName = "logs/output/com/adobe/internal/io/dummyFile";
    private static final File dummyFile = new File("logs/output/com/adobe/internal/io/dummyFile");
    private static final int EOF = -1;
    protected long length;
    protected long position = 0L;

    public ProxyRandomAccessFile(long length) throws FileNotFoundException {
        super(dummyFile, "r");
        this.length = length;
    }

    public void close() throws IOException {
        super.close();
    }

    public long getFilePointer() throws IOException {
        return super.getFilePointer();
    }

    public long length() throws IOException {
        return this.length;
    }

    public int read() throws IOException {
        if (this.position < 0L || this.position >= this.length) {
            return -1;
        }
        return (int)(this.position++ % 255L + 1L);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.position < 0L || this.position >= this.length) {
            return -1;
        }
        long bytesToRead = Math.min((long)len, this.length - this.position);
        int i = off;
        while ((long)i < bytesToRead) {
            b[i] = (byte)(this.position % 255L + 1L);
            ++this.position;
            ++i;
        }
        return (int)bytesToRead;
    }

    public void seek(long pos) throws IOException {
        this.position = pos;
    }

    public void setLength(long newLength) throws IOException {
        this.length = newLength;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        long expected = this.position % 255L + 1L;
        if ((long)(b & 0xFF) != expected && b != 0) {
            throw new IOException("Number written was not the expected number: position = " + this.position + ", number = " + b + ", expected = " + expected);
        }
        ++this.position;
        this.length = Math.max(this.length, this.position);
    }

    static {
        try {
            dummyFile.getParentFile().mkdirs();
            dummyFile.createNewFile();
            dummyFile.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

