/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.AbstractSVGAnimatedLength;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.svg.SVGExternalResourcesRequiredSupport;
import org.apache.batik.dom.svg.SVGStylableElement;
import org.apache.batik.dom.svg.SVGTestsSupport;
import org.apache.batik.dom.svg.SVGTextContentSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedEnumeration;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGStringList;

public abstract class SVGOMTextContentElement
extends SVGStylableElement {
    protected static final String[] LENGTH_ADJUST_VALUES = new String[]{"", "spacing", "spacingAndGlyphs"};

    protected SVGOMTextContentElement() {
    }

    protected SVGOMTextContentElement(String prefix, AbstractDocument owner) {
        super(prefix, owner);
    }

    public SVGAnimatedLength getTextLength() {
        SVGAnimatedLength result = (SVGAnimatedLength)this.getLiveAttributeValue(null, "textLength");
        if (result == null) {
            result = new AbstractSVGAnimatedLength(this, null, "textLength", 2){
                boolean usedDefault;

                protected String getDefaultValue() {
                    this.usedDefault = true;
                    return "" + SVGOMTextContentElement.this.getComputedTextLength();
                }

                public SVGLength getBaseVal() {
                    if (this.baseVal == null) {
                        this.baseVal = new SVGTextLength(this.direction);
                    }
                    return this.baseVal;
                }

                class SVGTextLength
                extends AbstractSVGAnimatedLength.BaseSVGLength {
                    public SVGTextLength(short direction) {
                        super(direction);
                    }

                    protected void revalidate() {
                        usedDefault = false;
                        super.revalidate();
                        if (usedDefault) {
                            this.valid = false;
                        }
                    }
                }
            };
            this.putLiveAttributeValue(null, "textLength", (LiveAttributeValue)result);
        }
        return result;
    }

    public SVGAnimatedEnumeration getLengthAdjust() {
        return this.getAnimatedEnumerationAttribute(null, "lengthAdjust", LENGTH_ADJUST_VALUES, (short)1);
    }

    public int getNumberOfChars() {
        return SVGTextContentSupport.getNumberOfChars((Element)((Object)this));
    }

    public float getComputedTextLength() {
        return SVGTextContentSupport.getComputedTextLength((Element)((Object)this));
    }

    public float getSubStringLength(int charnum, int nchars) throws DOMException {
        return SVGTextContentSupport.getSubStringLength((Element)((Object)this), charnum, nchars);
    }

    public SVGPoint getStartPositionOfChar(int charnum) throws DOMException {
        return SVGTextContentSupport.getStartPositionOfChar((Element)((Object)this), charnum);
    }

    public SVGPoint getEndPositionOfChar(int charnum) throws DOMException {
        return SVGTextContentSupport.getEndPositionOfChar((Element)((Object)this), charnum);
    }

    public SVGRect getExtentOfChar(int charnum) throws DOMException {
        return SVGTextContentSupport.getExtentOfChar((Element)((Object)this), charnum);
    }

    public float getRotationOfChar(int charnum) throws DOMException {
        return SVGTextContentSupport.getRotationOfChar((Element)((Object)this), charnum);
    }

    public int getCharNumAtPosition(SVGPoint point) {
        return SVGTextContentSupport.getCharNumAtPosition((Element)((Object)this), point.getX(), point.getY());
    }

    public void selectSubString(int charnum, int nchars) throws DOMException {
        SVGTextContentSupport.selectSubString((Element)((Object)this), charnum, nchars);
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        return SVGExternalResourcesRequiredSupport.getExternalResourcesRequired(this);
    }

    public String getXMLlang() {
        return XMLSupport.getXMLLang((Element)((Object)this));
    }

    public void setXMLlang(String lang) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", lang);
    }

    public String getXMLspace() {
        return XMLSupport.getXMLSpace((Element)((Object)this));
    }

    public void setXMLspace(String space) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", space);
    }

    public SVGStringList getRequiredFeatures() {
        return SVGTestsSupport.getRequiredFeatures((Element)((Object)this));
    }

    public SVGStringList getRequiredExtensions() {
        return SVGTestsSupport.getRequiredExtensions((Element)((Object)this));
    }

    public SVGStringList getSystemLanguage() {
        return SVGTestsSupport.getSystemLanguage((Element)((Object)this));
    }

    public boolean hasExtension(String extension) {
        return SVGTestsSupport.hasExtension((Element)((Object)this), extension);
    }
}

