/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.jsp;

import flex.webtier.server.j2ee.BrowserCacheFilter;
import flex.webtier.server.j2ee.CompileAgent;
import flex.webtier.server.j2ee.MxmlContext;
import flex.webtier.server.j2ee.MxmlFilter;
import flex.webtier.server.j2ee.RecompileFilter;
import flex.webtier.server.j2ee.SwfRenderFilter;
import flex.webtier.server.j2ee.SwfRequestHandler;
import flex.webtier.server.j2ee.SwfServlet;
import flex.webtier.server.j2ee.cache.CacheKeyUtils;
import flex.webtier.server.j2ee.events.SourceCodeLoader;
import flex.webtier.server.j2ee.jsp.JspCompileFilter;
import flex.webtier.server.j2ee.jsp.JspSourceCodeLoader;
import flex.webtier.server.j2ee.jsp.SourceCache;
import flex.webtier.server.j2ee.jsp.SourceCacheEntry;
import flex.webtier.services.ServiceFactory;
import flex.webtier.services.extensions.ExtensionManager;
import flex.webtier.util.Trace;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JspSwfRequestHandler
implements SwfRequestHandler {
    private CompileAgent compileAgent;
    private MxmlFilter jspCompileChain;
    private boolean logCompilerErrors;
    private String mxmlExt;
    private String swdExt;
    private String swfExt;

    public JspSwfRequestHandler() {
        this.initializeExtensions();
        this.jspCompileChain = this.createJspCompileChain();
        this.logCompilerErrors = ServiceFactory.getConfigurator().getServerConfiguration().getDebuggingConfiguration().logCompilerErrors();
        this.compileAgent = new CompileAgent();
    }

    private void initializeExtensions() {
        ExtensionManager extensionManager = ServiceFactory.getExtensionManager();
        this.mxmlExt = extensionManager.getMxmlExt();
        this.swdExt = extensionManager.getSwdExt();
        this.swfExt = extensionManager.getSwfExt();
    }

    private MxmlFilter createJspCompileChain() {
        RecompileFilter recompileFilter = new RecompileFilter();
        BrowserCacheFilter browserCacheFilter = new BrowserCacheFilter();
        JspCompileFilter compileFilter = new JspCompileFilter(this.swfExt);
        SwfRenderFilter swfRenderFilter = new SwfRenderFilter(this.swfExt, this.swdExt);
        recompileFilter.setNext((MxmlFilter)browserCacheFilter);
        browserCacheFilter.setNext((MxmlFilter)compileFilter);
        compileFilter.setNext((MxmlFilter)swfRenderFilter);
        return recompileFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws IOException {
        MxmlContext context = new MxmlContext();
        context.setRequest(request);
        context.setResponse(response);
        context.setServletContext(servletContext);
        context.setPageTitle(request.getServletPath());
        String uri = request.getServletPath();
        String dependencyKey = CacheKeyUtils.generateJspCacheKey((HttpServletRequest)request, (String)SourceCache.uriToKey(uri));
        SourceCache sourceCache = SourceCache.getInstance(servletContext);
        SourceCacheEntry sourceEntry = sourceCache.getEntry(dependencyKey);
        if (sourceEntry != null) {
            String jspFilename = sourceEntry.realPath;
            String parentDir = new File(jspFilename).getParent();
            context.setAppPath(parentDir + File.separator + "jsp" + sourceEntry.sourceHash + this.mxmlExt);
            context.setParentDir(parentDir);
            this.compileAgent.setupMxmlContextKeys(servletContext, context, request);
            context.setSourceCodeLoader((SourceCodeLoader)new JspSourceCodeLoader(sourceEntry.sourceCode));
            try {
                ServiceFactory.setThreadLocalLicense((String)((String)request.getAttribute("flexbuilder3")));
                if (!ServiceFactory.getLicenseService().isMxmlCompileEnabled()) {
                    response.sendError(481, "The current license does not support this feature.");
                    ServiceFactory.getLogger().logError("The current license does not support this feature. request=" + request.getServletPath());
                    return;
                }
                this.compileAgent.setupCompileEventLogger(context, request);
                this.jspCompileChain.invoke(context);
            }
            catch (FileNotFoundException fnfe) {
                response.sendError(404);
                if (this.logCompilerErrors) {
                    ServiceFactory.getLogger().logError(fnfe.getMessage(), (Throwable)fnfe);
                }
            }
            catch (Throwable t) {
                if (Trace.error) {
                    t.printStackTrace();
                }
                SwfServlet.sendNotAvailableResponse((HttpServletResponse)response, (String)"Unknown error", (String)("Unknown error " + request.getServletPath() + ": " + t.getMessage()), (Throwable)t);
            }
            finally {
                ServiceFactory.setThreadLocalLicense(null);
            }
        }
    }
}

