/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.math;

import com.adobe.agl.text.DecimalFormat;

public class F16Dot16 {
    public static final int ZERO = 0;
    public static final int ONE = 65536;
    public static final int ONE_HALF = 32768;
    private static final DecimalFormat df = new DecimalFormat("0.###");

    private static int clamp(long l) {
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }

    public static int truncate(int n) {
        return n & 0xFFFF0000;
    }

    public static int multiply(int n, int n2) {
        return F16Dot16.clamp((long)n * (long)n2 >> 16);
    }

    public static int square(int n) {
        return F16Dot16.multiply(n, n);
    }

    public static int multiplyByF2Dot14(int n, int n2) {
        return F16Dot16.clamp(((long)n * (long)n2 >> 13) + 1L >> 1);
    }

    public static int multiplyDivide(int n, int n2, int n3) {
        long l = (long)n * (long)n2;
        long l2 = n3;
        boolean bl = false;
        if (l < 0L) {
            l = -l;
            boolean bl2 = bl = !bl;
        }
        if (l2 < 0L) {
            l2 = -l2;
            bl = !bl;
        }
        long l3 = (l + l2 / 2L) / l2;
        if (bl) {
            return F16Dot16.clamp(-l3);
        }
        return F16Dot16.clamp(l3);
    }

    public static int divide(int n, int n2) {
        return F16Dot16.clamp(((long)n << 16) / (long)n2);
    }

    public static int round(int n) {
        return F16Dot16.truncate(n + 32768);
    }

    public static double toDouble(int n) {
        return (double)n / 65536.0;
    }

    public static int fromDouble(double d) {
        return (int)(d * 65536.0);
    }

    public static int fromInt(int n) {
        return n << 16;
    }

    public static String toString(int n) {
        return df.format(F16Dot16.toDouble(n));
    }
}

