/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.config;

import flash.localization.LocalizationManager;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CommandLineConfigurator {
    public static final String SOURCE_COMMAND_LINE = "command line";
    public static final String source = "command line";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void parse(ConfigurationBuffer buffer, String defaultvar, String[] args) throws ConfigurationException {
        if (!$assertionsDisabled && defaultvar != null && !buffer.isValidVar(defaultvar)) {
            throw new AssertionError((Object)("coding error: config must provide default var " + defaultvar));
        }
        Map aliases = CommandLineConfigurator.getAliases(buffer);
        boolean START = true;
        int ARGS = 2;
        int EXEC = 3;
        int DONE = 4;
        int i = 0;
        int iStart = 0;
        int iEnd = 0;
        String var = null;
        int varArgCount = -2;
        LinkedList<String> argList = new LinkedList<String>();
        HashSet<String> vars = new HashSet<String>();
        boolean append = false;
        boolean dash = true;
        int mode = 1;
        block6: while (mode != 4) {
            switch (mode) {
                case 1: {
                    String rest;
                    int equals;
                    iStart = i;
                    if (args.length == i) {
                        mode = 4;
                        break;
                    }
                    mode = 2;
                    varArgCount = -2;
                    if (args[i].equals("--")) {
                        dash = false;
                        if (defaultvar != null) {
                            var = defaultvar;
                        } else {
                            mode = 1;
                        }
                        ++i;
                        break;
                    }
                    if (dash && args[i].startsWith("+")) {
                        String token = null;
                        int c = args[i].length() > 1 && args[i].charAt(1) == '+' ? 2 : 1;
                        equals = args[i].indexOf(61);
                        rest = null;
                        if (equals != -1) {
                            rest = args[i].substring(equals + 1);
                            token = args[i++].substring(c, equals);
                        } else {
                            token = args[i++].substring(c);
                        }
                        if (equals != -1) {
                            iEnd = i;
                            buffer.setToken(token, rest);
                            buffer.addPosition(token, iStart, iEnd);
                        } else {
                            if (i == args.length) {
                                throw new ConfigurationException.Token("InsufficientArgs", token, var, "command line", -1);
                            }
                            rest = args[i++];
                            iEnd = i;
                            buffer.setToken(token, rest);
                            buffer.addPosition(token, iStart, iEnd);
                        }
                        mode = 1;
                        break;
                    }
                    if (dash && CommandLineConfigurator.isAnArgument(args[i])) {
                        int c = args[i].length() > 1 && args[i].charAt(1) == '-' ? 2 : 1;
                        int plusequals = args[i].indexOf("+=");
                        equals = args[i].indexOf(61);
                        rest = null;
                        if (plusequals != -1) {
                            rest = args[i].substring(plusequals + 2);
                            var = args[i++].substring(c, plusequals);
                            append = true;
                        } else if (equals != -1) {
                            rest = args[i].substring(equals + 1);
                            var = args[i++].substring(c, equals);
                        } else {
                            var = args[i++].substring(c);
                        }
                        if (aliases.containsKey(var)) {
                            var = (String)aliases.get(var);
                        }
                        if (!buffer.isValidVar(var)) {
                            throw new ConfigurationException.UnknownVariable(var, "command line", -1);
                        }
                        if (equals == -1) continue block6;
                        if (rest == null || rest.length() == 0) {
                            iEnd = i;
                            buffer.clearVar(var, "command line", -1);
                            buffer.addPosition(var, iStart, iEnd);
                            mode = 1;
                            break;
                        }
                        String seps = null;
                        seps = buffer.getInfo(var).isPath() ? "[," + File.pathSeparatorChar + "]" : ",";
                        String[] tokens = rest.split(seps);
                        argList.addAll(Arrays.asList(tokens));
                        varArgCount = buffer.getVarArgCount(var);
                        mode = 3;
                        break;
                    }
                    if (defaultvar != null) {
                        var = defaultvar;
                        break;
                    }
                    throw new ConfigurationException.UnexpectedDefaults(null, null, -1);
                }
                case 2: {
                    if (varArgCount == -2) {
                        if (CommandLineConfigurator.isBoolean(buffer, var)) {
                            varArgCount = 0;
                            mode = 3;
                            break;
                        }
                        varArgCount = buffer.getVarArgCount(var);
                    }
                    if (!$assertionsDisabled && varArgCount < -1) {
                        throw new AssertionError();
                    }
                    if (args.length == i) {
                        mode = 3;
                        break;
                    }
                    boolean greedy = buffer.getInfo(var).isGreedy();
                    if (!greedy && dash && CommandLineConfigurator.isAnArgument(args[i])) {
                        if (varArgCount == -1) {
                            mode = 3;
                            break;
                        }
                        throw new ConfigurationException.IncorrectArgumentCount(varArgCount, argList.size(), var, "command line", -1);
                    }
                    if (!(varArgCount != -1 || greedy || defaultvar == null || defaultvar.equals(var) || vars.contains(defaultvar) || args.length - i <= 1 || buffer.getInfo(defaultvar) == null)) {
                        boolean ok = false;
                        for (int j = i + 1; j < args.length; ++j) {
                            if (!dash || !CommandLineConfigurator.isAnArgument(args[j])) continue;
                            ok = true;
                            break;
                        }
                        if (!ok) {
                            throw new ConfigurationException.AmbiguousParse(defaultvar, var, "command line", -1);
                        }
                    }
                    argList.add(args[i++]);
                    if (argList.size() != varArgCount) break;
                    mode = 3;
                    break;
                }
                case 3: {
                    if (varArgCount != -1 && argList.size() != varArgCount) {
                        throw new ConfigurationException.IncorrectArgumentCount(varArgCount, argList.size(), var, "command line", -1);
                    }
                    if (varArgCount == 0) {
                        argList.add("true");
                    }
                    if (vars.contains(var) && defaultvar != null && var.equals(defaultvar)) {
                        throw new ConfigurationException.InterspersedDefaults(var, "command line", -1);
                    }
                    iEnd = i;
                    buffer.setVar(var, new LinkedList(argList), "command line", -1, null, append);
                    buffer.addPosition(var, iStart, iEnd);
                    append = false;
                    vars.add(var);
                    argList.clear();
                    mode = 1;
                    break;
                }
                case 4: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }
    }

    private static boolean isAnArgument(String arg) {
        return arg.startsWith("-") && arg.length() > 1 && !Character.isDigit(arg.charAt(1));
    }

    private static Map getAliases(ConfigurationBuffer buffer) {
        HashMap<String, String> aliases = new HashMap<String, String>();
        aliases.putAll(buffer.getAliases());
        Iterator it = buffer.getVarIterator();
        while (it.hasNext()) {
            String leafname;
            String varname = (String)it.next();
            if (varname.indexOf(46) == -1 || aliases.containsKey(leafname = varname.substring(varname.lastIndexOf(46) + 1))) continue;
            aliases.put(leafname, varname);
        }
        return aliases;
    }

    private static boolean isBoolean(ConfigurationBuffer buffer, String var) {
        ConfigurationInfo info = buffer.getInfo(var);
        if (info.getArgCount() > 1) {
            return false;
        }
        Class c = info.getArgType(0);
        return c == Boolean.TYPE || c == Boolean.class;
    }

    public static String brief(String program, String defaultvar, LocalizationManager l10n, String l10nPrefix) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("defaultVar", defaultvar);
        params.put("program", program);
        return l10n.getLocalizedTextString(l10nPrefix + ".Brief", params);
    }

    public static String usage(String program, String defaultVar, ConfigurationBuffer cfgbuf, Set keywords, LocalizationManager lmgr, String l10nPrefix) {
        ConfigurationInfo info;
        String var;
        String keyword;
        Map aliases = CommandLineConfigurator.getAliases(cfgbuf);
        HashMap sesaila = new HashMap();
        Iterator it = aliases.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            sesaila.put(e.getValue(), e.getKey());
        }
        TreeSet<Object> printSet = new TreeSet<Object>();
        boolean all = false;
        boolean advanced = false;
        boolean details = false;
        boolean syntax = false;
        boolean printaliases = false;
        HashSet<String> newSet = new HashSet<String>();
        Iterator kit = keywords.iterator();
        while (kit.hasNext()) {
            keyword = (String)kit.next();
            if (keyword.equals("list")) {
                all = true;
                newSet.add("*");
                continue;
            }
            if (keyword.equals("advanced")) {
                advanced = true;
                if (keywords.size() != 1) continue;
                all = true;
                newSet.add("*");
                continue;
            }
            if (keyword.equals("details")) {
                details = true;
                continue;
            }
            if (keyword.equals("syntax")) {
                syntax = true;
                continue;
            }
            if (keyword.equals("aliases")) {
                printaliases = true;
                continue;
            }
            details = true;
            newSet.add(keyword);
        }
        if (syntax) {
            List lines = ConfigurationBuffer.formatText(CommandLineConfigurator.getSyntaxDescription(program, defaultVar, advanced, lmgr, l10nPrefix), 78);
            StringBuffer text = new StringBuffer(512);
            Iterator it2 = lines.iterator();
            while (it2.hasNext()) {
                text.append(it2.next());
                text.append("\n");
            }
            return text.toString();
        }
        keywords = newSet;
        kit = keywords.iterator();
        while (kit.hasNext()) {
            keyword = ((String)kit.next()).toLowerCase();
            Iterator varit = cfgbuf.getVarIterator();
            while (varit.hasNext()) {
                var = (String)varit.next();
                info = cfgbuf.getInfo(var);
                String description = CommandLineConfigurator.getDescription(cfgbuf, var, lmgr, l10nPrefix);
                if (!all && var.indexOf(keyword) == -1 && (description == null || description.toLowerCase().indexOf(keyword) == -1) && !keyword.matches(var) && (sesaila.get(var) == null || ((String)sesaila.get(var)).indexOf(keyword) == -1) || info.isHidden() || !advanced && info.isAdvanced()) continue;
                if (printaliases && sesaila.containsKey(var)) {
                    printSet.add(sesaila.get(var));
                    continue;
                }
                printSet.add(var);
            }
        }
        StringBuffer output = new StringBuffer(1024);
        if (printSet.size() == 0) {
            String nkm = lmgr.getLocalizedTextString(l10nPrefix + ".NoKeywordsMatched");
            output.append(nkm);
            output.append("\n");
        } else {
            Iterator it3 = printSet.iterator();
            while (it3.hasNext()) {
                String avar;
                var = avar = (String)it3.next();
                if (aliases.containsKey(avar)) {
                    var = (String)aliases.get(avar);
                }
                info = cfgbuf.getInfo(var);
                if (!$assertionsDisabled && info == null) {
                    throw new AssertionError();
                }
                output.append("-");
                output.append(avar);
                int count = cfgbuf.getVarArgCount(var);
                if (count >= 1 && !CommandLineConfigurator.isBoolean(cfgbuf, var)) {
                    for (int i = 0; i < count; ++i) {
                        output.append(" <");
                        output.append(cfgbuf.getVarArgName(var, i));
                        output.append(">");
                    }
                } else if (count == -1) {
                    String last = "";
                    for (int i = 0; i < 5; ++i) {
                        String argname = cfgbuf.getVarArgName(var, i);
                        if (argname.equals(last)) {
                            output.append(" [...]");
                            break;
                        }
                        output.append(" [");
                        output.append(argname);
                        output.append("]");
                        last = argname;
                    }
                }
                output.append("\n");
                if (!details) continue;
                StringBuffer description = new StringBuffer(160);
                if (printaliases) {
                    if (aliases.containsKey(avar)) {
                        String fullname = lmgr.getLocalizedTextString(l10nPrefix + ".FullName");
                        description.append(fullname);
                        description.append(" -");
                        description.append(aliases.get(avar));
                        description.append("\n");
                    }
                } else if (sesaila.containsKey(var)) {
                    String alias = lmgr.getLocalizedTextString(l10nPrefix + ".Alias");
                    description.append(alias);
                    description.append(" -");
                    description.append(sesaila.get(var));
                    description.append("\n");
                }
                String d = CommandLineConfigurator.getDescription(cfgbuf, var, lmgr, l10nPrefix);
                if (var.equals("help") && printSet.size() > 2) {
                    String helpKeywords = lmgr.getLocalizedTextString(l10nPrefix + ".HelpKeywords");
                    description.append(helpKeywords);
                } else if (d != null) {
                    description.append(d);
                }
                String flags = "";
                if (info.isAdvanced()) {
                    String advancedString = lmgr.getLocalizedTextString(l10nPrefix + ".Advanced");
                    flags = flags + (flags.length() == 0 ? " (" : ", ") + advancedString;
                }
                if (info.allowMultiple()) {
                    String repeatableString = lmgr.getLocalizedTextString(l10nPrefix + ".Repeatable");
                    flags = flags + (flags.length() == 0 ? " (" : ", ") + repeatableString;
                }
                if (defaultVar != null && var.equals(defaultVar)) {
                    String defaultString = lmgr.getLocalizedTextString(l10nPrefix + ".Default");
                    flags = flags + (flags.length() == 0 ? " (" : ", ") + defaultString;
                }
                if (flags.length() != 0) {
                    flags = flags + ")";
                }
                description.append(flags);
                List descriptionLines = ConfigurationBuffer.formatText(description.toString(), 70);
                Iterator descit = descriptionLines.iterator();
                while (descit.hasNext()) {
                    output.append("    ");
                    output.append((String)descit.next());
                    output.append("\n");
                }
            }
        }
        return output.toString();
    }

    public static String getDescription(ConfigurationBuffer buffer, String var, LocalizationManager l10n, String l10nPrefix) {
        String key = l10nPrefix == null ? var : l10nPrefix + "." + var;
        String description = l10n.getLocalizedTextString(key, null);
        return description;
    }

    public static String getSyntaxDescription(String program, String defaultVar, boolean advanced, LocalizationManager l10n, String l10nPrefix) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("defaultVar", defaultVar);
        params.put("program", program);
        String key = l10nPrefix + "." + (advanced ? "AdvancedSyntax" : "Syntax");
        String text = l10n.getLocalizedTextString(key, params);
        if (text == null) {
            text = "No syntax help available, try '-help list' to list available configuration variables.";
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Localized text for syntax description not found!");
            }
        }
        return text;
    }

    static {
        $assertionsDisabled = !CommandLineConfigurator.class.desiredAssertionStatus();
    }
}

